/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.help.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.help.IToc;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.toc.TocFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpContextGenerator {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String INVALID_LABEL_CHARS = "[^a-zA-Z$\\d]";
    private static final String INVALID_CHAR_REPLACEMENT = "_";
    private static final String PHP_CONTRIBUTOR_ID = "org.eclipse.php.help";
    private static final String JAVA_HELP_CONTEXT_TEMPLATE = "template.txt";
    private static final String JAVA_HELP_CONTEXT_NAME = "IPHPHelpContextIds.java";
    private static final String HELP_CONTEXT_FILE = "helpContexts.xml";
    private static final String DESCRIPTION_POSTFIX = " Help";
    private static final String CONTEXT_BLOCK = "\t<context id=\"%1$s\">" + NEW_LINE + "\t\t<description>%2$s</description>" + NEW_LINE + "\t\t<topic href=\"%3$s\" label=\"%4$s\"/>" + NEW_LINE + "\t</context>" + NEW_LINE;
    private static final String JAVA_CONSTANT_LINE = "public static final String %1$s = PREFIX + \"%2$s\"; //$NON-NLS-1$ [%3$s]" + NEW_LINE;
    private LinkedHashSet<String> topics = new LinkedHashSet();

    public void run() {
        TocFileProvider tocProvider = new TocFileProvider();
        ITocContribution[] tocContributions = tocProvider.getTocContributions(null);
        ArrayList<ITocContribution> phpTocs = new ArrayList<ITocContribution>();
        ITocContribution[] iTocContributionArray = tocContributions;
        int n = tocContributions.length;
        int n2 = 0;
        while (n2 < n) {
            ITocContribution contribution = iTocContributionArray[n2];
            if (!contribution.isPrimary() && PHP_CONTRIBUTOR_ID.equals(contribution.getContributorId())) {
                phpTocs.add(contribution);
            }
            ++n2;
        }
        try {
            this.generateFiles(phpTocs);
        }
        catch (Exception exception) {}
    }

    private void generateFiles(ArrayList<ITocContribution> phpTocs) throws Exception {
        File javaTemplateFile = this.getJavaTemplateFile();
        File helpContextFile = new File(javaTemplateFile.getParent(), HELP_CONTEXT_FILE);
        File newJavaFile = new File(javaTemplateFile.getParent(), JAVA_HELP_CONTEXT_NAME);
        StringBuilder helpContextBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NEW_LINE + "<!-- Auto generated using the HelpContextGenerator -->" + NEW_LINE + "<contexts>" + NEW_LINE);
        StringBuilder newJavaFileBuilder = new StringBuilder();
        this.loadJavaTemplate(newJavaFileBuilder, javaTemplateFile);
        for (ITocContribution tocContribution : phpTocs) {
            IToc toc = tocContribution.getToc();
            IUAElement[] children = toc.getChildren();
            this.writeElements(children, helpContextBuilder, newJavaFileBuilder, 1);
        }
        newJavaFileBuilder.append('}');
        helpContextBuilder.append("</contexts>");
        this.writeFile(helpContextFile, helpContextBuilder.toString());
        this.writeFile(newJavaFile, newJavaFileBuilder.toString());
    }

    private void writeElements(IUAElement[] children, StringBuilder helpContextBuilder, StringBuilder newJavaFileBuilder, int tocLevel) {
        IUAElement[] iUAElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IUAElement child = iUAElementArray[n2];
            if (child instanceof ITopic) {
                ITopic topic = (ITopic)child;
                String href = topic.getHref();
                String label = topic.getLabel();
                String labelAsKey = this.cleanLabel(label).toLowerCase();
                String labelAsModifier = labelAsKey;
                if (Character.isDigit(labelAsModifier.charAt(0))) {
                    labelAsModifier = String.valueOf('_') + labelAsModifier;
                }
                if (this.topics.contains(labelAsModifier)) {
                    ITopic parent = (ITopic)((Topic)topic).getParentElement();
                    String parentLabel = this.cleanLabel(parent.getLabel()).toLowerCase();
                    if (Character.isDigit(parentLabel.charAt(0))) {
                        parentLabel = String.valueOf('_') + parentLabel;
                    }
                    labelAsModifier = String.valueOf(parentLabel) + labelAsModifier;
                }
                this.topics.add(labelAsModifier);
                int i = 0;
                while (i < tocLevel) {
                    newJavaFileBuilder.append('\t');
                    ++i;
                }
                newJavaFileBuilder.append(String.format(JAVA_CONSTANT_LINE, labelAsModifier.toUpperCase(), labelAsKey, href));
                helpContextBuilder.append(String.format(CONTEXT_BLOCK, labelAsKey, String.valueOf(label) + DESCRIPTION_POSTFIX, href, label));
                ITopic[] subtopics = topic.getSubtopics();
                if (subtopics != null && subtopics.length > 0) {
                    this.writeElements((IUAElement[])subtopics, helpContextBuilder, newJavaFileBuilder, tocLevel + 1);
                }
            }
            ++n2;
        }
    }

    private String cleanLabel(String labelAsKey) {
        return labelAsKey.replaceAll(INVALID_LABEL_CHARS, INVALID_CHAR_REPLACEMENT);
    }

    private void loadJavaTemplate(StringBuilder newJavaFileBuilder, File javaTemplateFile) throws IOException {
        String line = null;
        BufferedReader reader = new BufferedReader(new FileReader(javaTemplateFile));
        while ((line = reader.readLine()) != null) {
            newJavaFileBuilder.append(line);
            newJavaFileBuilder.append(NEW_LINE);
        }
    }

    private void writeFile(File file, String toWrite) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(toWrite);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private File getJavaTemplateFile() throws IOException {
        URL url = this.getClass().getResource(JAVA_HELP_CONTEXT_TEMPLATE);
        File javaTemplateFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        if (!javaTemplateFile.exists()) {
            javaTemplateFile = new File(URLDecoder.decode(FileLocator.toFileURL((URL)url).getFile(), "UTF-8"));
        }
        String srcFilePath = javaTemplateFile.toString().replace(String.valueOf(File.separatorChar) + "bin" + File.separatorChar, String.valueOf(File.separatorChar) + "src" + File.separatorChar);
        javaTemplateFile = new File(srcFilePath);
        return javaTemplateFile;
    }
}

