/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;

public class ExpressionValue {
    public static int NULL_TYPE = 0;
    public static int INT_TYPE = 1;
    public static int STRING_TYPE = 2;
    public static int BOOLEAN_TYPE = 3;
    public static int DOUBLE_TYPE = 4;
    public static int ARRAY_TYPE = 5;
    public static int OBJECT_TYPE = 6;
    public static int RESOURCE_TYPE = 7;
    public static final ExpressionValue NULL_VALUE = new ExpressionValue(NULL_TYPE, null, "null", null);
    protected int type;
    protected Expression[] children;
    protected Object value;
    protected String valueAsString;

    public ExpressionValue(int type, Object value, String valueAsString, Expression[] children) {
        this.type = type;
        this.value = value;
        this.valueAsString = valueAsString;
        this.children = children;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public Expression[] getOriChildren() {
        return this.children;
    }

    public Expression[] getChildren() {
        return ExpressionValue.sort(this.children);
    }

    public static Expression[] sort(Expression[] children) {
        if (PHPProjectPreferences.isSortByName()) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            Expression[] expressionArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                list.add(expression);
                ++n2;
            }
            Collections.sort(list, new Comparator<Expression>(){

                @Override
                public int compare(Expression o1, Expression o2) {
                    return o1.getName()[o1.getName().length - 1].compareTo(o2.getName()[o1.getName().length - 1]);
                }
            });
            return list.toArray(new Expression[list.size()]);
        }
        return children;
    }

    public boolean isNull() {
        return this.type == NULL_TYPE;
    }

    public boolean isPrimitive() {
        return this.type == NULL_TYPE || this.type != ARRAY_TYPE && this.type != OBJECT_TYPE;
    }
}

