/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.formatter.autoedit;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.formatter.FormatterTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.Bundle;

public class FormatterAutoEditTests
extends FormatterTests {
    protected static final char OFFSET_CHAR = '|';

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit"});
    }

    public FormatterAutoEditTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Formatter Auto Edit Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = (String[])TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = FormatterAutoEditTests.getPDTTFiles((String)testsDirectory, (Bundle)PHPUiTests.getDefault().getBundle());
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
                        filesMap.put(pdttFile, null);
                        phpVerSuite.addTest((Test)new FormatterAutoEditTests("/" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion((IProject)project, (PHPVersion)phpVersion);
                            }

                            protected void runTest() throws Throwable {
                                IFile file = (IFile)filesMap.get(pdttFile);
                                ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
                                if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
                                    modelElement.becomeWorkingCopy(new IProblemRequestor(){

                                        public void acceptProblem(IProblem problem) {
                                        }

                                        public void beginReporting() {
                                        }

                                        public void endReporting() {
                                        }

                                        public boolean isActive() {
                                            return false;
                                        }
                                    }, null);
                                }
                                IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
                                try {
                                    IStructuredDocument document = modelForEdit.getStructuredDocument();
                                    String beforeFormat = document.get();
                                    String data = document.get();
                                    int offset = data.lastIndexOf(124);
                                    if (offset == -1) {
                                        throw new IllegalArgumentException("Offset character is not set");
                                    }
                                    data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
                                    document.set(data);
                                    MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
                                    DocumentCommand cmd = new DocumentCommand(){};
                                    cmd.offset = offset;
                                    cmd.length = 0;
                                    cmd.text = pdttFile.getOther() != null ? pdttFile.getOther() : "\n";
                                    cmd.doit = true;
                                    cmd.shiftsCaret = true;
                                    cmd.caretOffset = -1;
                                    indentLineAutoEditStrategy.customizeDocumentCommand((IDocument)document, cmd);
                                    document.replace(cmd.offset, cmd.length, cmd.text);
                                    this.assertContents(pdttFile.getExpected(), document.get());
                                    document.set(beforeFormat);
                                    modelForEdit.save();
                                }
                                finally {
                                    if (modelForEdit != null) {
                                        modelForEdit.releaseFromEdit();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                FormatterAutoEditTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                FormatterAutoEditTests.tearDownSuite();
            }
        };
        return setup;
    }
}

