/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP54;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTests;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP54;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTRewriteTests
extends TestCase {
    protected AST ast;
    protected IDocument document;
    protected Program program;

    public ASTRewriteTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(new Class[]{ASTRewriteTests.class, NodeDeletionTests.class, ASTRewriteTestsPHP54.class, NodeDeletionTestsPHP54.class}, ASTRewriteTests.class.getName());
    }

    public void testVariable1() throws Exception {
        String str = "<?php $a; $A;?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 2 ? 1 : 0) != 0);
        variables.get(1).setName((Expression)this.ast.newIdentifier("B1"));
        this.rewrite();
        this.checkResult("<?php $a; $B1;?>");
    }

    public void testVariable2() throws Exception {
        String str = "<?php $AAA;?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 1 ? 1 : 0) != 0);
        ((Identifier)variables.get(0).getName()).setName("B");
        this.rewrite();
        this.checkResult("<?php $B;?>");
    }

    public void testFunctionName() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionName functionName = invocations.get(0).getFunctionName();
        functionName.setName((Expression)this.ast.newIdentifier("boobo"));
        this.rewrite();
        this.checkResult("<?php boobo(); ?>");
    }

    public void testFunctionInvocationName() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.setFunctionName(this.ast.newFunctionName((Expression)this.ast.newIdentifier("boobo")));
        this.rewrite();
        this.checkResult("<?php boobo(); ?>");
    }

    public void testFunctionInvocationAddParam() throws Exception {
        String str = "<?php foo( ); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().add(this.ast.newVariable("aaa"));
        this.rewrite();
        this.checkResult("<?php foo($aaa ); ?>");
    }

    public void testFunctionInvocationAddParams() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().add(this.ast.newVariable("aaa"));
        functionInvocation.parameters().add(this.ast.newVariable("bbb"));
        functionInvocation.parameters().add(this.ast.newVariable("ccc"));
        this.rewrite();
        this.checkResult("<?php foo($aaa, $bbb, $ccc); ?>");
    }

    public void testFunctionInvocationRemoveParam1() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().remove(1);
        this.rewrite();
        this.checkResult("<?php foo($aaa); ?>");
    }

    public void testFunctionInvocationRemoveParam2() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().remove(0);
        this.rewrite();
        this.checkResult("<?php foo($bbb); ?>");
    }

    public void testFunctionInvocationRemoveParams() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().clear();
        this.rewrite();
        this.checkResult("<?php foo(); ?>");
    }

    public void testVariable3() throws Exception {
        String str = "<?php $myClass->bar();?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 2 ? 1 : 0) != 0);
        variables.get(1).setName((Expression)this.ast.newIdentifier("foo"));
        variables.get(1).setIsDollared(true);
        variables.get(0).setIsDollared(false);
        this.rewrite();
        this.checkResult("<?php myClass->$foo();?>");
    }

    public void testStaticFunctionInvocation() throws Exception {
        String str = "<?php A::foo($a); ?>";
        this.initialize(str);
        List<StaticMethodInvocation> staticInvocations = this.getAllOfType(this.program, StaticMethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticInvocations.size() == 1 ? 1 : 0) != 0);
        staticInvocations.get(0).setClassName((Expression)this.ast.newIdentifier("B"));
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.ast.newScalar("b", 2));
        parameters.add(this.ast.newVariable("c"));
        staticInvocations.get(0).setMethod(this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newIdentifier("bar")), parameters));
        this.rewrite();
        this.checkResult("<?php B::bar(b,$c); ?>");
    }

    public void testArrayAccessWithoutIndex() throws Exception {
        String str = "<?php $a[]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setName((VariableBase)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b[]; ?>");
    }

    public void testArrayAccess() throws Exception {
        String str = "<?php $a[$b]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setIndex((Expression)this.ast.newScalar("1"));
        this.rewrite();
        this.checkResult("<?php $a[1]; ?>");
    }

    public void testArrayVariableMultiIndex() throws Exception {
        String str = "<?php $a[$b][5][3]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 3 ? 1 : 0) != 0);
        arrayAccess.get(0).setIndex((Expression)this.ast.newVariable("foo"));
        arrayAccess.get(2).setName((VariableBase)this.ast.newVariable("boo"));
        this.rewrite();
        this.checkResult("<?php $boo[$b][5][$foo]; ?>");
    }

    public void testArrayAccessType1() throws Exception {
        String str = "<?php $a[$b]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setArrayType(2);
        this.rewrite();
        this.checkResult("<?php $a{$b}; ?>");
    }

    public void testArrayAccessType2() throws Exception {
        String str = "<?php $a{'name'}; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setArrayType(1);
        arrayAccess.get(0).setIndex((Expression)this.ast.newScalar("333"));
        this.rewrite();
        this.checkResult("<?php $a[333]; ?>");
    }

    public void testListVariable1() throws Exception {
        String str = "<?php list($a,$b)=1; ?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 1 ? 1 : 0) != 0);
        listVariables.get(0).variables().add(this.ast.newVariable("c"));
        listVariables.get(0).variables().remove(0);
        this.rewrite();
        this.checkResult("<?php list($b,$c)=1; ?>");
    }

    public void testListVariable2() throws Exception {
        String str = "<?php list($a,$b)=1; ?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 1 ? 1 : 0) != 0);
        listVariables.get(0).variables().remove(1);
        this.rewrite();
        this.checkResult("<?php list($a)=1; ?>");
    }

    public void testNestedListVariable() throws Exception {
        String str = "<?php list($a, list($b,$c))=1;?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 2 ? 1 : 0) != 0);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.add(this.ast.newVariable("foo"));
        variables.add(this.ast.newVariable("bar"));
        listVariables.get(1).variables().add(this.ast.newListVariable(variables));
        this.rewrite();
        this.checkResult("<?php list($a, list($b,$c,list($foo, $bar)))=1;?>");
    }

    public void testAssignmentLeft() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setLeftHandSide((VariableBase)this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $foo = 1;?>");
    }

    public void testAssignmentRight() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setRightHandSide((Expression)this.ast.newScalar("12345"));
        this.rewrite();
        this.checkResult("<?php $a = 12345;?>");
    }

    public void testAssignmentOperator() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setOperator(3);
        this.rewrite();
        this.checkResult("<?php $a *= 1;?>");
    }

    public void testReflectionSimple() throws Exception {
        String str = "<?php $$a;?>";
        this.initialize(str);
        List<ReflectionVariable> reflectionVariables = this.getAllOfType(this.program, ReflectionVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (reflectionVariables.size() == 1 ? 1 : 0) != 0);
        reflectionVariables.get(0).setName((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $$b;?>");
    }

    public void testReflectionFunction() throws Exception {
        String str = "<?php $$$bar(); ?>";
        this.initialize(str);
        List<FunctionInvocation> functionInvocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (functionInvocations.size() == 1 ? 1 : 0) != 0);
        functionInvocations.get(0).setFunctionName(this.ast.newFunctionName((Expression)this.ast.newReflectionVariable((Expression)this.ast.newReflectionVariable((Expression)this.ast.newVariable("foo")))));
        this.rewrite();
        this.checkResult("<?php $$$foo(); ?>");
    }

    public void testReflectionComplex() throws Exception {
        String str = "<?php ${\"var\"};?>";
        this.initialize(str);
        List<ReflectionVariable> reflectionVariables = this.getAllOfType(this.program, ReflectionVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (reflectionVariables.size() == 1 ? 1 : 0) != 0);
        reflectionVariables.get(0).setName((Expression)this.ast.newScalar("\"boobo\"", 2));
        this.rewrite();
        this.checkResult("<?php ${\"boobo\"};?>");
    }

    public void testStaticMemberSimple() throws Exception {
        String str = "<?php MyClass::$a;?>";
        this.initialize(str);
        List<StaticFieldAccess> fieldsAccess = this.getAllOfType(this.program, StaticFieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setField(this.ast.newVariable("boobo"));
        fieldsAccess.get(0).setClassName((Expression)this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php Foo::$boobo;?>");
    }

    public void testStaticMemberWithArray() throws Exception {
        String str = "<?php MyClass::$$a[5];?>";
        this.initialize(str);
        List<StaticFieldAccess> fieldsAccess = this.getAllOfType(this.program, StaticFieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setField((Variable)this.ast.newReflectionVariable((Expression)this.ast.newArrayAccess((VariableBase)this.ast.newVariable("bar"), (Expression)this.ast.newScalar("333"))));
        this.rewrite();
        this.checkResult("<?php MyClass::$$bar[333];?>");
    }

    public void testDispatchSimple() throws Exception {
        String str = "<?php $a->$b;?>";
        this.initialize(str);
        List<FieldAccess> fieldsAccess = this.getAllOfType(this.program, FieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setDispatcher((VariableBase)this.ast.newVariable("boo"));
        fieldsAccess.get(0).setField(this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $boo->$foo;?>");
    }

    public void testDispatchNested() throws Exception {
        String str = "<?php $myClass->foo()->bar(); ?>";
        this.initialize(str);
        List<MethodInvocation> methodInvocations = this.getAllOfType(this.program, MethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (methodInvocations.size() == 2 ? 1 : 0) != 0);
        methodInvocations.get(1).getMethod().setFunctionName(this.ast.newFunctionName((Expression)this.ast.newScalar("boobo")));
        this.rewrite();
        this.checkResult("<?php $myClass->boobo()->bar(); ?>");
    }

    public void testDispatchWithStaticCall() throws Exception {
        String str = "<?php MyClass::$a->foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> functionInvocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (functionInvocations.size() == 1 ? 1 : 0) != 0);
        functionInvocations.get(0).getFunctionName().setName((Expression)this.ast.newScalar("bar"));
        List<MethodInvocation> methodInvocations = this.getAllOfType(this.program, MethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (methodInvocations.size() == 1 ? 1 : 0) != 0);
        ((StaticFieldAccess)methodInvocations.get(0).getDispatcher()).getField().setName((Expression)this.ast.newScalar("boobo"));
        this.rewrite();
        this.checkResult("<?php MyClass::$boobo->bar(); ?>");
    }

    public void testClone() throws Exception {
        String str = "<?php clone $a; ?>";
        this.initialize(str);
        List<CloneExpression> cloneExpressions = this.getAllOfType(this.program, CloneExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (cloneExpressions.size() == 1 ? 1 : 0) != 0);
        cloneExpressions.get(0).setExpression((Expression)this.ast.newVariable("bbb"));
        this.rewrite();
        this.checkResult("<?php clone $bbb; ?>");
    }

    public void testCastOfVariable() throws Exception {
        String str = "<?php (int) $a; ?>";
        this.initialize(str);
        List<CastExpression> castExpressions = this.getAllOfType(this.program, CastExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (castExpressions.size() == 1 ? 1 : 0) != 0);
        castExpressions.get(0).setExpression((Expression)this.ast.newVariable("b"));
        castExpressions.get(0).setCastingType(2);
        this.rewrite();
        this.checkResult("<?php (string) $b; ?>");
    }

    public void testCastOfDispatch() throws Exception {
        String str = "<?php (string) $b->foo(); ?>";
        this.initialize(str);
        List<CastExpression> castExpressions = this.getAllOfType(this.program, CastExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (castExpressions.size() == 1 ? 1 : 0) != 0);
        castExpressions.get(0).setCastingType(0);
        this.rewrite();
        this.checkResult("<?php (int) $b->foo(); ?>");
    }

    public void testClassConstant() throws Exception {
        String str = "<?php $a = MyClass::MY_CONST; ?>";
        this.initialize(str);
        List<StaticConstantAccess> staticConstants = this.getAllOfType(this.program, StaticConstantAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticConstants.size() == 1 ? 1 : 0) != 0);
        ((Identifier)staticConstants.get(0).getClassName()).setName("Foo");
        staticConstants.get(0).setConstant(this.ast.newIdentifier("BAR_CONST"));
        this.rewrite();
        this.checkResult("<?php $a = Foo::BAR_CONST; ?>");
    }

    public void testPostfixSimple() throws Exception {
        String str = "<?php $a++;?>";
        this.initialize(str);
        List<PostfixExpression> postfixExp = this.getAllOfType(this.program, PostfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (postfixExp.size() == 1 ? 1 : 0) != 0);
        postfixExp.get(0).setOperator(1);
        postfixExp.get(0).setVariable((VariableBase)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b--;?>");
    }

    public void testPostfixWithFunction() throws Exception {
        String str = "<?php foo()--;?>";
        this.initialize(str);
        List<PostfixExpression> postfixExp = this.getAllOfType(this.program, PostfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (postfixExp.size() == 1 ? 1 : 0) != 0);
        postfixExp.get(0).setOperator(0);
        ((FunctionInvocation)postfixExp.get(0).getVariable()).setFunctionName(this.ast.newFunctionName((Expression)this.ast.newScalar("bar")));
        this.rewrite();
        this.checkResult("<?php bar()++;?>");
    }

    public void testPrefixSimple() throws Exception {
        String str = "<?php ++$a;?>";
        this.initialize(str);
        List<PrefixExpression> prefixExp = this.getAllOfType(this.program, PrefixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (prefixExp.size() == 1 ? 1 : 0) != 0);
        prefixExp.get(0).setOperator(1);
        this.rewrite();
        this.checkResult("<?php --$a;?>");
    }

    public void testUnaryOperationSimple() throws Exception {
        String str = "<?php +$a;?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 1 ? 1 : 0) != 0);
        ops.get(0).setOperator(3);
        ops.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php ~$b;?>");
    }

    public void testUnaryOperationWithFunction() throws Exception {
        String str = "<?php -foo(); ?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 1 ? 1 : 0) != 0);
        ops.get(0).setOperator(2);
        this.rewrite();
        this.checkResult("<?php !foo(); ?>");
    }

    public void testUnaryOperationComplex() throws Exception {
        String str = "<?php +-+-$b;?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 4 ? 1 : 0) != 0);
        ops.get(2).setOperator(3);
        ops.get(0).setOperator(2);
        this.rewrite();
        this.checkResult("<?php !-~-$b;?>");
    }

    public void testClassInstanciationSimple() throws Exception {
        String str = "<?php new MyClass(); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).getClassName().setClassName((Expression)this.ast.newScalar("Foo"));
        this.rewrite();
        this.checkResult("<?php new Foo(); ?>");
    }

    public void testClassInstanciationAddParam() throws Exception {
        String str = "<?php new MyClass(); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(this.ast.newVariable("foo"));
        instanciations.get(0).ctorParams().add(this.ast.newVariable("bar"));
        this.rewrite();
        this.checkResult("<?php new MyClass($foo, $bar); ?>");
    }

    public void testClassInstanciationVariable() throws Exception {
        String str = "<?php new $a('start'); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(this.ast.newScalar("'hello'"));
        instanciations.get(0).setClassName(this.ast.newClassName((Expression)this.ast.newVariable("b")));
        this.rewrite();
        this.checkResult("<?php new $b('start', 'hello'); ?>");
    }

    public void testClassInstanciationVariableRemove() throws Exception {
        String str = "<?php new $a('start','end'); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().remove(1);
        this.rewrite();
        this.checkResult("<?php new $a('start'); ?>");
    }

    public void testClassInstanciationFunction() throws Exception {
        String str = "<?php new $a->$b(1, $a); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(0, this.ast.newScalar("'Welcome'"));
        this.rewrite();
        this.checkResult("<?php new $a->$b('Welcome', 1, $a); ?>");
    }

    public void testRefernceSimple() throws Exception {
        String str = "<?php $b = &$a;?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        references.get(0).setExpression((Expression)this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $b = &$foo;?>");
    }

    public void testRefernceWithFunction() throws Exception {
        String str = "<?php $g = &$foo(); ?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        references.get(0).setExpression((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newVariable("bar")), null));
        this.rewrite();
        this.checkResult("<?php $g = &$bar(); ?>");
    }

    public void testRefernceInstanciation() throws Exception {
        String str = "<?php $b = &new MyClass(); ?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        ((ClassInstanceCreation)references.get(0).getExpression()).ctorParams().add(this.ast.newVariable("boobo"));
        this.rewrite();
        this.checkResult("<?php $b = &new MyClass($boobo); ?>");
    }

    public void testInstanceofSimple() throws Exception {
        String str = "<?php $a instanceof MyClass;?>";
        this.initialize(str);
        List<InstanceOfExpression> instanceOf = this.getAllOfType(this.program, InstanceOfExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanceOf.size() == 1 ? 1 : 0) != 0);
        instanceOf.get(0).getClassName().setClassName((Expression)this.ast.newScalar("Foo", 2));
        instanceOf.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b instanceof Foo;?>");
    }

    public void testIgnoreError() throws Exception {
        String str = "<?php @$a->foo(); ?>";
        this.initialize(str);
        List<IgnoreError> ignoreErrors = this.getAllOfType(this.program, IgnoreError.class);
        Assert.assertTrue((String)"Unexpected list size.", (ignoreErrors.size() == 1 ? 1 : 0) != 0);
        ignoreErrors.get(0).setExpression((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("bar")), null));
        this.rewrite();
        this.checkResult("<?php @bar(); ?>");
    }

    public void testInclude() throws Exception {
        String str = "<?php include('myFile.php'); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newScalar("'newFile.php'"));
        includes.get(0).setIncludetype(3);
        this.rewrite();
        this.checkResult("<?php include_once 'newFile.php'; ?>");
    }

    public void testIncludeWithParenthesis1() throws Exception {
        String str = "<?php include('myFile.php'); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newParenthesisExpression((Expression)this.ast.newScalar("'newFile.php'")));
        includes.get(0).setIncludetype(0);
        this.rewrite();
        this.checkResult("<?php require('newFile.php'); ?>");
    }

    public void testIncludeWithParenthesis2() throws Exception {
        String str = "<?php include 'myFile.php'; ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newParenthesisExpression((Expression)this.ast.newScalar("'file.php'")));
        includes.get(0).setIncludetype(1);
        this.rewrite();
        this.checkResult("<?php require_once ('file.php'); ?>");
    }

    public void testIncludeOnce() throws Exception {
        String str = "<?php include_once($myFile); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setIncludetype(2);
        this.rewrite();
        this.checkResult("<?php include($myFile); ?>");
    }

    public void testArrayCreation1() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        arrays.get(0).elements().add(this.ast.newArrayElement((Expression)this.ast.newScalar("'foo'"), (Expression)this.ast.newScalar("'boo'")));
        this.rewrite();
        this.checkResult("<?php array(1,2,3, 'foo'=>'boo',); ?>");
    }

    public void testArrayCreation2() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        arrays.get(0).elements().add(this.ast.newArrayElement(null, (Expression)this.ast.newScalar("4")));
        this.rewrite();
        this.checkResult("<?php array(1,2,3, 4,); ?>");
    }

    public void testArrayCreation3() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        arrays.get(0).elements().remove(1);
        this.rewrite();
        this.checkResult("<?php array(1,3,); ?>");
    }

    public void testFunctionDeclaration() throws Exception {
        String str = "<?php function foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setFunctionName(this.ast.newIdentifier("bar"));
        declarations.get(0).formalParameters().add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), null, false));
        this.rewrite();
        this.checkResult("<?php function bar(int $a) {} ?> ");
    }

    public void testFunctionDeclarationPHP4() throws Exception {
        String str = "<?php function foo() {} ?> ";
        this.initialize(str, PHPVersion.PHP4);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setFunctionName(this.ast.newIdentifier("bar"));
        declarations.get(0).formalParameters().add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), null, true));
        this.rewrite();
        this.checkResult("<?php function bar(const int $a) {} ?> ");
    }

    public void testFunctionDeclarationWithParam1() throws Exception {
        String str = "<?php function foo( $a) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo( string $a) {} ?> ");
    }

    public void testFunctionDeclarationWithParam2() throws Exception {
        String str = "<?php function foo($a, boolean $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    public void testFunctionDeclarationWithParam3() throws Exception {
        String str = "<?php function foo($a, $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    public void testFunctionDeclarationDeleteType() throws Exception {
        String str = "<?php function foo(boolean $a) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).getParameterType().delete();
        this.rewrite();
        this.checkResult("<?php function foo( $a) {} ?> ");
    }

    public void testFunctionDeclarationCreationPHP4() throws Exception {
        String str = "<?php ?> ";
        this.initialize(str, PHPVersion.PHP4);
        Identifier name = this.ast.newIdentifier("foo");
        ArrayList<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
        formalParameters.add(this.ast.newFormalParameter(null, (Expression)this.ast.newVariable("a"), (Expression)this.ast.newScalar("5"), false));
        formalParameters.add(this.ast.newFormalParameter(null, (Expression)this.ast.newVariable("b"), (Expression)this.ast.newScalar("'boobo'"), true));
        Block body = this.ast.newBlock();
        this.program.statements().add(0, this.ast.newFunctionDeclaration(name, formalParameters, body, false));
        this.rewrite();
        this.checkResult("<?php function foo($a = 5, const $b = 'boobo'){\n}\n?> ");
    }

    public void testFunctionDeclarationCreationPHP5() throws Exception {
        String str = "<?php ?> ";
        this.initialize(str);
        Identifier name = this.ast.newIdentifier("foo");
        ArrayList<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
        formalParameters.add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), (Expression)this.ast.newScalar("5"), false));
        formalParameters.add(this.ast.newFormalParameter(null, (Expression)this.ast.newVariable("b"), (Expression)this.ast.newScalar("'boobo'"), false));
        Block body = this.ast.newBlock();
        this.program.statements().add(0, this.ast.newFunctionDeclaration(name, formalParameters, body, true));
        this.rewrite();
        this.checkResult("<?php function &foo(int $a = 5,  $b = 'boobo') {\n}\n?> ");
    }

    public void testFunctionDeclarationChangeDefault1() throws Exception {
        String str = "<?php function foo(boolean $a = false) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Scalar)((FormalParameter)declarations.get(0).formalParameters().get(0)).getDefaultValue()).setStringValue("true");
        this.rewrite();
        this.checkResult("<?php function foo(boolean $a = true) {} ?> ");
    }

    public void testFunctionDeclarationDeleteDefault1() throws Exception {
        String str = "<?php function foo(string $a = 'foo') {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).setDefaultValue(null);
        this.rewrite();
        this.checkResult("<?php function foo(string $a) {} ?> ");
    }

    public void testFunctionDeclarationDeleteDefault2() throws Exception {
        String str = "<?php function foo(string $a = 'foo') {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).getDefaultValue().delete();
        this.rewrite();
        this.checkResult("<?php function foo(string $a) {} ?> ");
    }

    public void testClassDeclarationSimple() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php class Foo { } ?> ");
    }

    public void testFunctionDeclarationRemoveReference() throws Exception {
        String str = "<?php function  &foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php function foo() {} ?> ");
    }

    public void testFunctionDeclarationAddReference() throws Exception {
        String str = "<?php function  foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php function &foo() {} ?> ");
    }

    public void testClassDeclarationAddSuper() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(2);
        declarations.get(0).setSuperClass((Expression)this.ast.newIdentifier("Boo"));
        this.rewrite();
        this.checkResult("<?php final class MyClass extends Boo { } ?> ");
    }

    public void testClassDeclarationDeleteSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).getSuperClass().delete();
        this.rewrite();
        this.checkResult("<?php class MyClass { } ?> ");
    }

    public void testClassDeclarationDeleteSuperWithImplements() throws Exception {
        String str = "<?php class MyClass extends Foo implements Bar { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).getSuperClass().delete();
        this.rewrite();
        this.checkResult("<?php class MyClass implements Bar { } ?> ");
    }

    public void testClassDeclarationReplaceSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).getSuperClass()).setName("Bar");
        this.rewrite();
        this.checkResult("<?php class MyClass extends Bar { } ?> ");
    }

    public void testClassDeclarationAddInterfaces() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Foo"));
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Bar"));
        this.rewrite();
        this.checkResult("<?php class MyClass implements Foo, Bar { } ?> ");
    }

    public void testClassDeclarationRemoveInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().remove(0);
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Bar{ } ?> ");
    }

    public void testClassDeclarationRemoveAllInterfaces() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().clear();
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA{ } ?> ");
    }

    public void testClassDeclarationRenameInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).interfaces().get(1)).setName("BooBo");
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Foo,BooBo{ } ?> ");
    }

    public void testInterfaceDeclarationSimple() throws Exception {
        String str = "<?php interface MyInterface { } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php interface Foo { } ?> ");
    }

    public void testInterfaceDeclarationAddExtends() throws Exception {
        String str = "<?php interface MyInterface { const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Foo"));
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Bar"));
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Foo, Bar { const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    public void testInterfaceDeclarationRemoveExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().remove(1);
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Foo{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    public void testInterfaceDeclarationRemoveAllExtends() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar { const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().clear();
        this.rewrite();
        this.checkResult("<?php interface MyInterface { const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    public void testInterfaceDeclarationRenameExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).interfaces().get(0)).setName("Boobo");
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Boobo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    public void testArrayKeyValueRemoveKey() throws Exception {
        String str = "<?php array('Dodo'=>'Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(1)).getKey().delete();
        this.rewrite();
        this.checkResult("<?php array('Dodo'=>'Golo','Dodidu'); ?>");
    }

    public void testArrayKeyValueAddKey() throws Exception {
        String str = "<?php array('Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(0)).setKey((Expression)this.ast.newScalar("'Dodo'"));
        this.rewrite();
        this.checkResult("<?php array('Dodo'=>'Golo','Dafna'=>'Dodidu'); ?>");
    }

    public void testArrayKeyValueChangeKey() throws Exception {
        String str = "<?php array('Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((Scalar)((ArrayElement)arrays.get(0).elements().get(1)).getKey()).setStringValue("'Boobo'");
        this.rewrite();
        this.checkResult("<?php array('Golo','Boobo'=>'Dodidu'); ?>");
    }

    public void testArrayKeyDelete() throws Exception {
        String str = "<?php array('Dudu'=>'Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(1)).delete();
        this.rewrite();
        this.checkResult("<?php array('Dudu'=>'Golo'); ?>");
    }

    public void testConditionalExpression() throws Exception {
        String str = "<?php (bool)$a ? 3 : 4;?>";
        this.initialize(str);
        List<ConditionalExpression> conditional = this.getAllOfType(this.program, ConditionalExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (conditional.size() == 1 ? 1 : 0) != 0);
        ((CastExpression)conditional.get(0).getCondition()).setExpression((Expression)this.ast.newVariable("b"));
        conditional.get(0).setIfFalse((Expression)this.ast.newScalar("100"));
        conditional.get(0).setIfTrue((Expression)this.ast.newScalar("200"));
        this.rewrite();
        this.checkResult("<?php (bool)$b ? 200 : 100;?>");
    }

    public void testInfixExpression() throws Exception {
        String str = "<?php $a + 1;?>";
        this.initialize(str);
        List<InfixExpression> expressions = this.getAllOfType(this.program, InfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (expressions.size() == 1 ? 1 : 0) != 0);
        expressions.get(0).setOperator(21);
        expressions.get(0).setRight((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("foo")), null));
        this.rewrite();
        this.checkResult("<?php $a % foo();?>");
    }

    public void testConcatOperation() throws Exception {
        String str = "<?php 'string'.$c;?>";
        this.initialize(str);
        List<InfixExpression> expressions = this.getAllOfType(this.program, InfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (expressions.size() == 1 ? 1 : 0) != 0);
        expressions.get(0).setOperator(3);
        this.rewrite();
        this.checkResult("<?php 'string'!=$c;?>");
    }

    public void testQuoteHeredoc() throws Exception {
        String str = "<?php \"this\nis $a quote\";?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(2);
        this.rewrite();
        this.checkResult("<?php <<<Heredoc\nthis\nis $a quote\nHeredoc;\n;?>");
    }

    public void testQuoteSingle() throws Exception {
        String str = "<?php \"this is $a quote\";?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(1);
        this.rewrite();
        this.checkResult("<?php 'this is $a quote';?>");
    }

    public void testQuoteDouble() throws Exception {
        String str = "<?php <<<Heredoc\r\nthis is $a quote\r\nHeredoc;\r\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(0);
        this.rewrite();
        this.checkResult("<?php \"this is $a quote\";\r\n?>");
    }

    public void testQuoteWithCurly() throws Exception {
        String str = "<?php $text = <<<EOF\ntest{test}test\nEOF;\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(0);
        this.rewrite();
        this.checkResult("<?php $text = \"test{test}test\";\n?>");
    }

    public void testEmptyHeredoc() throws Exception {
        String str = "<?php <<<Heredoc\nHeredoc;\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).expressions().add(this.ast.newScalar("Hello World"));
        this.rewrite();
        this.checkResult("<?php <<<Heredoc\nHello World\nHeredoc;\n?>");
    }

    public void testBreakStatementChange() throws Exception {
        String str = "<?php break $a;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php break $b;?>");
    }

    public void testBreakStatementRemove() throws Exception {
        String str = "<?php break $a;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php break;?>");
    }

    public void testBreakStatementAdd() throws Exception {
        String str = "<?php break;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php break $b;?>");
    }

    public void testContinueStatementAdd() throws Exception {
        String str = "<?php continue;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php continue $b;?>");
    }

    public void testContinueStatementRemove() throws Exception {
        String str = "<?php continue $a;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php continue;?>");
    }

    public void testContinueStatementChange() throws Exception {
        String str = "<?php continue $a;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php continue $b;?>");
    }

    public void testReturnStatementAdd() throws Exception {
        String str = "<?php return; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        returnStatements.get(0).setExpression((Expression)this.ast.newVariable("a"));
        this.rewrite();
        this.checkResult("<?php return $a; ?>");
    }

    public void testReturnExprStatementChange() throws Exception {
        String str = "<?php return $a; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        ((Variable)returnStatements.get(0).getExpression()).setName((Expression)this.ast.newScalar("b"));
        this.rewrite();
        this.checkResult("<?php return $b; ?>");
    }

    public void testReturnExprStatementRemove() throws Exception {
        String str = "<?php return $c; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        returnStatements.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php return; ?>");
    }

    public void testEchoStatement() throws Exception {
        String str = "<?php echo \"hello \",$b;?>";
        this.initialize(str);
        List<EchoStatement> list = this.getAllOfType(this.program, EchoStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (list.size() == 1 ? 1 : 0) != 0);
        list.get(0).expressions().set(0, this.ast.newScalar("\"replaced hello\""));
        list.get(0).expressions().add(this.ast.newScalar("'1111'"));
        this.rewrite();
        this.checkResult("<?php echo \"replaced hello\",$b, '1111';?>");
    }

    public void testNewEchoStatement() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<Object> expressions = new ArrayList<Object>(2);
        expressions.add(this.ast.newScalar("\"hello\""));
        expressions.add(this.ast.newVariable("b"));
        this.program.statements().add(0, this.ast.newEchoStatement(expressions));
        this.rewrite();
        this.checkResult("<?php echo \"hello\", $b;\n?>");
    }

    public void testSwitchStatementSetExpression() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchStatement> statements = this.getAllOfType(this.program, SwitchStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setExpression((Expression)this.ast.newVariable("a"));
        this.rewrite();
        this.checkResult("<?php switch ($a) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    public void testSwitchStatementChangeCaseAction() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchCase> switchCases = this.getAllOfType(this.program, SwitchCase.class);
        Assert.assertTrue((String)"Unexpected list size.", (switchCases.size() == 3 ? 1 : 0) != 0);
        switchCases.get(0).setValue((Expression)this.ast.newScalar("5"));
        switchCases.get(0).actions().set(0, this.ast.newEchoStatement((Expression)this.ast.newScalar("'i equals 5'")));
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 5:    echo 'i equals 5';\n    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    public void testSwitchStatementCaseDeletion() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchCase> switchCases = this.getAllOfType(this.program, SwitchCase.class);
        Assert.assertTrue((String)"Unexpected list size.", (switchCases.size() == 3 ? 1 : 0) != 0);
        switchCases.get(0).delete();
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    public void testSwitchStatementChangeAddCase() throws Exception {
        String newLine = System.getProperty("line.separator");
        String str = "<?php " + newLine + "switch ($i) { " + newLine + "\tcase 0:" + newLine + "\t\techo 'i equals 0';" + newLine + "\t\tbreak;" + newLine + "\tcase 1:" + newLine + "\t\techo 'i equals 1';" + newLine + "\t\tbreak;" + newLine + "\tdefault:" + newLine + "\t\techo 'i not equals 0,1';" + newLine + "}  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (blocks.size() == 1 ? 1 : 0) != 0);
        ArrayList<Object> actions = new ArrayList<Object>(3);
        actions.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'a new case'")));
        actions.add(this.ast.newExpressionStatement((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("foo")), null)));
        actions.add(this.ast.newBreakStatement());
        blocks.get(0).statements().add(2, this.ast.newSwitchCase((Expression)this.ast.newScalar("2"), actions, false));
        this.rewrite();
        this.checkResult("<?php \nswitch ($i) { \n\tcase 0:\n\t\techo 'i equals 0';\n\t\tbreak;\n\tcase 1:\n\t\techo 'i equals 1';\n\t\tbreak;\n\tcase 2 :\n\t\techo 'a new case';\n\t\tfoo ();\n\t\tbreak;\n\n\tdefault:\n\t\techo 'i not equals 0,1';\n}  ?>");
    }

    public void testIfStatementCondition() throws Exception {
        String str = "<?php if ($a > $b) {   echo 'a is bigger than b';} elseif ($a == $b) {   echo 'a is equal to b';} else {   echo 'a is smaller than b';} ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 2 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("c"), 8, (Expression)this.ast.newVariable("d")));
        this.rewrite();
        this.checkResult("<?php if ($c || $d) {   echo 'a is bigger than b';} elseif ($a == $b) {   echo 'a is equal to b';} else {   echo 'a is smaller than b';} ?>");
    }

    public void testIfStatementCurlyToAlternative() throws Exception {
        String str = "<?php if ($a > $b) {\n\techo 'a > b';\n\t} else {\n\techo 'a <= b';\n} ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        blocks.get(0).setIsCurly(false);
        blocks.get(1).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\techo 'a > b';\n\t else :\n\techo 'a <= b';\nendif; ?>");
    }

    public void testIfStatementAlternativeToCurly() throws Exception {
        String str = "<?php if ($a > $b) :\n\techo 'a > b';\n else :\n\techo 'a <= b';\nendif; ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        blocks.get(0).setIsCurly(true);
        blocks.get(1).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php if ($a > $b) {\n\techo 'a > b';\n}\n else {\n\techo 'a <= b';\n}\n ?>");
    }

    public void testNestedIfStatementCurlyToAlternative1() throws Exception {
        String str = "<?php if ($a > $b) {\n\tif ($a == $b) {\n\techo 'a > b';\n\t}\n} else {\n\techo 'a <= b';\n} ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        for (Block block : blocks) {
            block.setIsCurly(false);
        }
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\tif ($a == $b) :\n\techo 'a > b';\n\tendif;\n else :\n\techo 'a <= b';\nendif; ?>");
    }

    public void testNestedIfStatementCurlyToAlternative2() throws Exception {
        String str = "<?php if ($a > $b) {\n\tif ($a == $b) {\n\techo 'a > b'; \n} elseif ($b == 1) {\n\techo 'boobo';\n} else {\n\techo 5;\n\t}\n} else {\n\techo 'a <= b';\n}\n?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        for (Block block : blocks) {
            block.setIsCurly(false);
        }
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\tif ($a == $b) :\n\techo 'a > b'; \n elseif ($b == 1) :\n\techo 'boobo';\n else :\n\techo 5;\n\tendif;\n else :\n\techo 'a <= b';\nendif;\n?>");
    }

    public void testWhileStatementCurlyToAlternative() throws Exception {
        String str = "<?php while ($i <= 10){\n echo $i++;\n}\n?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php while ($i <= 10):\n echo $i++;\nendwhile;\n?>");
    }

    public void testWhileStatementAlternativeToCurly() throws Exception {
        String str = "<?php while ($i <= 10):  echo $i;   $i++; endwhile; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php while ($i <= 10){  echo $i;   $i++;\n}  ?>");
    }

    public void testForStatementCurlyToAlternative() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10; $i++) :  echo $i; endfor; ?>");
    }

    public void testForStatementAlternativeToCurly() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) :  echo $i; endfor; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10; $i++) {  echo $i;\n}  ?>");
    }

    public void testForEachStatementCurlyToAlternative() throws Exception {
        String str = "<?php foreach ($arr as &$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as &$value) : $value = $value * 2; endforeach; ?>");
    }

    public void testForEachStatementAlternativeToCurly() throws Exception {
        String str = "<?php foreach ($arr as &$value) : $value = $value * 2; endforeach; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as &$value) { $value = $value * 2;\n}  ?>");
    }

    public void testSwitchStatementCurlyToAlternative() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php switch ($i) : case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  endswitch;  ?>");
    }

    public void testSwitchStatementAlternativeToCurly() throws Exception {
        String str = "<?php switch ($i) : case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  endswitch;  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  \n}  ?>");
    }

    public void testWhileStatement() throws Exception {
        String str = "<?php while ($i <= 10) echo $i++; ?>";
        this.initialize(str);
        List<WhileStatement> statements = this.getAllOfType(this.program, WhileStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("a"), 8, (Expression)this.ast.newVariable("b")));
        statements.get(0).setBody((Statement)this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello!!'")));
        this.rewrite();
        this.checkResult("<?php while ($a || $b)echo 'Hello!!';\n ?>");
    }

    public void testDoWhileStatement() throws Exception {
        String str = "<?php do { echo $i;} while ($i > 0); ?>";
        this.initialize(str);
        List<DoStatement> statements = this.getAllOfType(this.program, DoStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("a"), 3, (Expression)this.ast.newVariable("b")));
        ArrayList<EchoStatement> newStatements = new ArrayList<EchoStatement>(2);
        newStatements.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello!!'")));
        newStatements.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Goodbye!!'")));
        statements.get(0).setBody((Statement)this.ast.newBlock(newStatements));
        this.rewrite();
        this.checkResult("<?php do {\n\techo 'Hello!!';\n\techo 'Goodbye!!';\n}\nwhile ($a != $b); ?>");
    }

    public void testCurlyBlockCreation() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<EchoStatement> trueStatement = new ArrayList<EchoStatement>(1);
        trueStatement.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Boobo'")));
        Block block = this.ast.newBlock(trueStatement);
        block.setIsCurly(true);
        this.program.statements().add(0, this.ast.newIfStatement((Expression)this.ast.newVariable("a"), (Statement)block, null));
        this.rewrite();
        this.checkResult("<?php if ($a) {\n\techo 'Boobo';\n}\n?>");
    }

    public void testAlternativeBlockCreation() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<EchoStatement> trueStatement = new ArrayList<EchoStatement>(1);
        trueStatement.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Boobo'")));
        Block block = this.ast.newBlock(trueStatement);
        block.setIsCurly(false);
        this.program.statements().add(0, this.ast.newIfStatement((Expression)this.ast.newVariable("a"), (Statement)block, null));
        this.rewrite();
        this.checkResult("<?php if ($a) :\n\techo 'Boobo';\n\nendif;\n?>");
    }

    public void testForStatement() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).initializers().add(this.ast.newAssignment((VariableBase)this.ast.newVariable("j"), 0, (Expression)this.ast.newScalar("5")));
        statements.get(0).conditions().add(this.ast.newInfixExpression((Expression)this.ast.newVariable("j"), 6, (Expression)this.ast.newScalar("20")));
        statements.get(0).updaters().add(this.ast.newPrefixExpression((VariableBase)this.ast.newVariable("j"), 0));
        this.rewrite();
        this.checkResult("<?php for ($i = 1, $j=5; $i <= 10, $j > 20; $i++, $j++) {  echo $i; } ?>");
    }

    public void testForStatementRemoveInitialization() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((Expression)statements.get(0).initializers().get(0)).delete();
        this.rewrite();
        this.checkResult("<?php for (; $i <= 10; $i++) {  echo $i; } ?>");
    }

    public void testForStatementRemoveCondition() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).conditions().clear();
        this.rewrite();
        this.checkResult("<?php for ($i = 1;; $i++) {  echo $i; } ?>");
    }

    public void testForStatementRemoveUpdaters() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((Expression)statements.get(0).updaters().get(0)).delete();
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10;) {  echo $i; } ?>");
    }

    public void testForEachStatementAddKey() throws Exception {
        String str = "<?php foreach ($arr as &$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setExpression((Expression)this.ast.newVariable("foo"));
        statements.get(0).setKey((Expression)this.ast.newVariable("bar"));
        this.rewrite();
        this.checkResult("<?php foreach ($foo as $bar=>&$value) { $value = $value * 2; } ?>");
    }

    public void testForEachStatementChangeKeyAndValue() throws Exception {
        String str = "<?php foreach ($arr as $foo=>&$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setKey((Expression)this.ast.newVariable("bar"));
        Reference ref = this.ast.newReference((Expression)this.ast.newVariable("val"));
        statements.get(0).setValue((Expression)ref);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as $bar=>&$val) { $value = $value * 2; } ?>");
    }

    public void testForEachStatementRemoveKey() throws Exception {
        String str = "<?php foreach ($foo as $bar=>&$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).getKey().delete();
        this.rewrite();
        this.checkResult("<?php foreach ($foo as &$value) { $value = $value * 2; } ?>");
    }

    public void testTryCatchStatement() throws Exception {
        String str = "<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }  ?>";
        this.initialize(str);
        List<TryStatement> statements = this.getAllOfType(this.program, TryStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Block newBlock = this.ast.newBlock();
        newBlock.statements().add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello'")));
        statements.get(0).catchClauses().add(this.ast.newCatchClause(this.ast.newIdentifier("Boobo"), this.ast.newVariable("b"), newBlock));
        this.rewrite();
        this.checkResult("<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }catch (Boobo $b) {\necho 'Hello';\n}\n  ?>");
    }

    public void testTryMultiCatchStatement() throws Exception {
        String str = "<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; } catch (AnotherException $ea) { echo ''; }  ?>";
        this.initialize(str);
        List<TryStatement> statements = this.getAllOfType(this.program, TryStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((CatchClause)statements.get(0).catchClauses().get(1)).delete();
        this.rewrite();
        this.checkResult("<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }  ?>");
    }

    public void testGlobalStatementSimple() throws Exception {
        String str = "<?php global $a; ?>";
        this.initialize(str);
        List<GlobalStatement> statements = this.getAllOfType(this.program, GlobalStatement.class);
        statements.get(0).variables().add(this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php global $a, $b; ?>");
    }

    public void testGlobalStatementReflection() throws Exception {
        String str = "<?php global $$a; ?>";
        this.initialize(str);
        List<GlobalStatement> statements = this.getAllOfType(this.program, GlobalStatement.class);
        statements.get(0).variables().add(this.ast.newReflectionVariable((Expression)this.ast.newVariable("b")));
        this.rewrite();
        this.checkResult("<?php global $$a, $$b; ?>");
    }

    public void testStaticSimple() throws Exception {
        String str = "<?php static $a;?>";
        this.initialize(str);
        List<StaticStatement> statements = this.getAllOfType(this.program, StaticStatement.class);
        statements.get(0).expressions().add(this.ast.newAssignment((VariableBase)this.ast.newVariable("b"), 0, (Expression)this.ast.newScalar("8")));
        this.rewrite();
        this.checkResult("<?php static $a, $b=8;?>");
    }

    public void testInLineHtml() throws Exception {
        String str = "<html> </html>";
        this.initialize(str);
        List<InLineHtml> inline = this.getAllOfType(this.program, InLineHtml.class);
        Assert.assertTrue((String)"Unexpected list size.", (inline.size() == 1 ? 1 : 0) != 0);
        this.rewrite();
        this.checkResult("<html> </html>");
    }

    public void testFieldDeclaration() throws Exception {
        String str = "<?php class A { public $a = 3; final private static $var; }?>";
        this.initialize(str);
        List<FieldsDeclaration> declarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 2 ? 1 : 0) != 0);
        declarations.get(0).fields().add(this.ast.newSingleFieldDeclaration(this.ast.newVariable("b"), (Expression)this.ast.newScalar("4")));
        ((SingleFieldDeclaration)declarations.get(0).fields().get(0)).getValue().delete();
        declarations.get(1).setModifier(36);
        this.rewrite();
        this.checkResult("<?php class A { public $a, $b = 4; protected final $var; }?>");
    }

    public void testMethodDeclaration() throws Exception {
        String str = "<?php class A { public function foo(int $a){} }?> ";
        this.initialize(str);
        List<MethodDeclaration> declarations = this.getAllOfType(this.program, MethodDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(33);
        declarations.get(0).getFunction().setFunctionName(this.ast.newIdentifier("bar"));
        this.rewrite();
        this.checkResult("<?php class A { protected abstract function bar(int $a){} }?> ");
    }

    public void testComment() throws Exception {
        String str = "<?php\n class A { \n\tpublic function foo(int $a){}\n }?> ";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (blocks.size() == 2 ? 1 : 0) != 0);
        AST astRoot = this.program.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot);
        Block block = blocks.get(0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
        ASTNode placeHolder = rewrite.createStringPlaceholder("//mycomment", 16);
        listRewrite.insertFirst(placeHolder, null);
        TextEdit textEdits = rewrite.rewriteAST(this.document, null);
        textEdits.apply(this.document);
        this.checkResult("<?php\n class A { \n\t//mycomment\n\tpublic function foo(int $a){}\n }?> ");
    }

    private void initialize(String content, PHPVersion phpVersion) throws Exception {
        this.document = new Document(content);
        ASTParser parser = ASTParser.newParser((PHPVersion)phpVersion, (boolean)ProjectOptions.useShortTags(null));
        parser.setSource(this.document.get().toCharArray());
        this.program = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        this.ast = this.program.getAST();
        this.program.recordModifications();
    }

    protected final void initialize(String content) throws Exception {
        this.initialize(content, this.getPHPVersion());
    }

    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5;
    }

    protected final void rewrite() throws Exception {
        TextEdit edits = this.program.rewrite(this.document, null);
        edits.apply(this.document);
    }

    protected final void checkResult(String expected) {
        String actual = this.document.get();
        String diff = PHPCoreTests.compareContentsIgnoreWhitespace(expected, actual);
        if (diff != null) {
            ASTRewriteTests.fail((String)diff);
        }
    }

    public <T extends ASTNode> List<T> getAllOfType(Program program, final String className) {
        final ArrayList list = new ArrayList();
        program.accept((Visitor)new ApplyAll(){

            protected boolean apply(ASTNode node) {
                if (node.getClass().getName().equals(className)) {
                    list.add(node);
                }
                return true;
            }
        });
        return list;
    }

    public <T extends ASTNode> List<T> getAllOfType(Program program, final Class<T> nodeClass) {
        final ArrayList list = new ArrayList();
        program.accept((Visitor)new ApplyAll(){

            protected boolean apply(ASTNode node) {
                if (node.getClass() == nodeClass) {
                    list.add(node);
                }
                return true;
            }
        });
        return list;
    }
}

