/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBackwardCompatibilityUtil {
    public static final String TAG_INCLUDEPATHENTRY = "includepathentry";
    public static final String TAG_ENTRY_KIND = "kind";
    public static final String TAG_PATH = "path";
    public static final String TAG_RESOURCE = "resource";
    public static final String TAG_EXPORTED = "exported";
    private static final String PREF_QUALIFIER = "org.eclipse.php.core.projectOptions";
    private IBuildpathEntry[] buildpathEntries = new IBuildpathEntry[0];
    private List<String> notImportedIncludePathVariableNames = new ArrayList<String>();

    public List<String> getNotImportedIncludePathVariableNames() {
        return this.notImportedIncludePathVariableNames;
    }

    public IBuildpathEntry[] convertIncludePathForProject(IProject project) {
        try {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
            String includePathXml = preferences.get("org.eclipse.php.core.includePath", null);
            if (includePathXml == null) {
                return this.buildpathEntries;
            }
            Element cpElement = null;
            StringReader reader = new StringReader(includePathXml);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
                }
            }
            finally {
                ((Reader)reader).close();
            }
            if (cpElement == null) {
                return this.buildpathEntries;
            }
            ArrayList<IBuildpathEntry> paths = new ArrayList<IBuildpathEntry>();
            NodeList list = cpElement.getElementsByTagName(TAG_INCLUDEPATHENTRY);
            int i = 0;
            while (i < list.getLength()) {
                IBuildpathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = this.elementDecode((Element)node)) != null) {
                    paths.add(entry);
                }
                ++i;
            }
            int pathSize = paths.size();
            this.buildpathEntries = new IBuildpathEntry[pathSize];
            return paths.toArray(this.buildpathEntries);
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
            return this.buildpathEntries;
        }
    }

    private IBuildpathEntry elementDecode(Element element) {
        String entryKindAttr = element.getAttribute(TAG_ENTRY_KIND);
        String pathAttr = element.getAttribute(TAG_PATH);
        String resourceAttr = element.getAttribute(TAG_RESOURCE);
        boolean isExported = element.getAttribute(TAG_EXPORTED).equals("true");
        IBuildpathEntry entry = null;
        IPath path = null;
        String variableName = null;
        int entryKind = ProjectBackwardCompatibilityUtil.entryKindFromString(entryKindAttr);
        switch (entryKind) {
            case 2: {
                path = ResourcesPlugin.getWorkspace().getRoot().getProject(resourceAttr).getFullPath();
                if (path == null) break;
                entry = DLTKCore.newProjectEntry((IPath)path, (boolean)isExported);
                break;
            }
            case 1: {
                if ("var".equalsIgnoreCase(entryKindAttr)) {
                    variableName = pathAttr;
                    if (variableName == null || variableName.length() <= 0) break;
                    Preferences pluginPreferences = PHPCorePlugin.getDefault().getPluginPreferences();
                    String pathString = pluginPreferences.getString(variableName);
                    if (pathString != null && (path = IncludePathVariableManager.instance().getIncludePathVariable(pathString)) == null) {
                        path = IncludePathVariableManager.instance().resolveVariablePath(variableName);
                    }
                    if (path != null) {
                        entry = DLTKCore.newExtLibraryEntry((IPath)EnvironmentPathUtils.getFullPath((IEnvironment)LocalEnvironment.getInstance(), (IPath)path));
                        break;
                    }
                    this.notImportedIncludePathVariableNames.add(variableName);
                    break;
                }
                entry = DLTKCore.newLibraryEntry((IPath)new Path(pathAttr).makeAbsolute());
            }
            case 5: {
                break;
            }
            case 3: {
                entry = DLTKCore.newSourceEntry(path);
            }
        }
        return entry;
    }

    static int entryKindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        return -1;
    }

    static class IncludePathVariableManager {
        private static IncludePathVariableManager instance;
        Preferences preferenceStore = PHPCorePlugin.getDefault().getPluginPreferences();
        HashMap<String, Path> variables = new HashMap();

        public static IncludePathVariableManager instance() {
            if (instance == null) {
                instance = new IncludePathVariableManager();
            }
            return instance;
        }

        private IncludePathVariableManager() {
            this.startUp();
        }

        public IPath getIncludePathVariable(String variableName) {
            IPath varPath = null;
            Path path = new Path(variableName);
            if (path.segmentCount() == 1) {
                varPath = (IPath)this.variables.get(variableName);
            } else {
                varPath = (IPath)this.variables.get(path.segment(0));
                if (varPath != null) {
                    varPath = varPath.append(path.removeFirstSegments(1));
                }
            }
            return varPath;
        }

        public String[] getIncludePathVariableNames() {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.variables.keySet());
            return list.toArray(new String[list.size()]);
        }

        public void startUp() {
            String namesString = this.preferenceStore.getString("org.eclipse.php.core.includePathVariableNames");
            String pathsString = this.preferenceStore.getString("org.eclipse.php.core.includePathVariablePaths");
            String[] names = new String[]{};
            if (namesString.length() > 0) {
                names = namesString.split(",");
            }
            String[] paths = new String[]{};
            if (pathsString.length() > 0) {
                paths = pathsString.split(",");
            }
            int i = 0;
            while (i < names.length) {
                String path = i < paths.length ? paths[i] : "";
                this.variables.put(names[i], new Path(path));
                ++i;
            }
        }

        public IPath resolveVariablePath(String path) {
            int index = path.indexOf(47);
            if (index != -1) {
                String var = path.substring(0, index);
                IPath varPath = this.getIncludePathVariable(var);
                if (varPath != null && index + 1 < path.length()) {
                    varPath = varPath.append(path.substring(index + 1));
                }
                return varPath;
            }
            return this.getIncludePathVariable(path);
        }
    }
}

