/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.php.internal.core.codeassist.CompletionRequestorExtension;

public abstract class CodeCompletionRequestor
extends CompletionRequestor
implements CompletionRequestorExtension {
    List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    Comparator sorter = this.getSorter();

    public CodeCompletionRequestor() {
        this.setIgnored(2, true);
    }

    protected Comparator getSorter() {
        return new Comparator<CompletionProposal>(){

            @Override
            public int compare(CompletionProposal o1, CompletionProposal o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }

    public void accept(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return;
        }
        this.addProposal(proposal);
    }

    public final void addProposal(CompletionProposal proposal) {
        this.proposals.add(proposal);
    }

    public String[] getVariables() {
        Collections.sort(this.proposals, this.sorter);
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (CompletionProposal proposal : this.proposals) {
            if (nameSet.contains(proposal.getName())) continue;
            nameSet.add(proposal.getName());
            nameList.add(proposal.getName());
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public String[] getArrayVariables() {
        return this.getVariables();
    }
}

