/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingInstanceCall
extends Expression {
    private PHPArrayDereferenceList arrayDereferenceList;
    private List<VariableBase> chainingMethodOrProperty = new LinkedList<VariableBase>();
    public static final ChildPropertyDescriptor ARRAY_DEREFERENCE_LIST = new ChildPropertyDescriptor(ChainingInstanceCall.class, "arrayDereferenceList", PHPArrayDereferenceList.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(ARRAY_DEREFERENCE_LIST);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public ChainingInstanceCall(int start, int end, AST ast, PHPArrayDereferenceList arrayDereferenceList, List<VariableBase> chainingMethodOrProperty) {
        super(start, end, ast);
        this.arrayDereferenceList = arrayDereferenceList;
        if (chainingMethodOrProperty != null) {
            this.chainingMethodOrProperty.addAll(chainingMethodOrProperty);
        }
    }

    public ChainingInstanceCall(AST ast, PHPArrayDereferenceList arrayDereferenceList, List<VariableBase> chainingMethodOrProperty) {
        super(ast);
        this.setArrayDereferenceList(arrayDereferenceList);
        if (chainingMethodOrProperty != null) {
            this.chainingMethodOrProperty.addAll(chainingMethodOrProperty);
        }
    }

    public List<VariableBase> getChainingMethodOrProperty() {
        return this.chainingMethodOrProperty;
    }

    public void setChainingMethodOrProperty(ASTNode.NodeList<VariableBase> chainingMethodOrProperty) {
        this.chainingMethodOrProperty = chainingMethodOrProperty;
    }

    public void setArrayDereferenceList(PHPArrayDereferenceList arrayDereferenceList) {
        PHPArrayDereferenceList oldChild = this.arrayDereferenceList;
        this.preReplaceChild(oldChild, arrayDereferenceList, ARRAY_DEREFERENCE_LIST);
        this.arrayDereferenceList = arrayDereferenceList;
        this.postReplaceChild(oldChild, arrayDereferenceList, ARRAY_DEREFERENCE_LIST);
    }

    public PHPArrayDereferenceList getArrayDereferenceList() {
        return this.arrayDereferenceList;
    }

    public int getKind() {
        return 70;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.accept(visitor);
        }
        if (this.chainingMethodOrProperty != null) {
            for (VariableBase variableBase : this.chainingMethodOrProperty) {
                variableBase.accept(visitor);
            }
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.traverseTopDown(visitor);
        }
        if (this.chainingMethodOrProperty != null) {
            for (VariableBase variableBase : this.chainingMethodOrProperty) {
                variableBase.traverseTopDown(visitor);
            }
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.arrayDereferenceList != null) {
            this.arrayDereferenceList.traverseBottomUp(visitor);
        }
        if (this.chainingMethodOrProperty != null) {
            for (VariableBase variableBase : this.chainingMethodOrProperty) {
                variableBase.traverseBottomUp(visitor);
            }
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ChainingInstanceCall");
        this.appendInterval(buffer);
        buffer.append(">\n");
        if (this.arrayDereferenceList != null) {
            buffer.append("\t").append(tab).append("<PHPArrayDereferenceList>\n");
            this.arrayDereferenceList.toString(buffer, "\t" + tab);
            buffer.append("\n");
            buffer.append("\t").append(tab).append("</PHPArrayDereferenceList>");
        }
        if (this.chainingMethodOrProperty != null) {
            buffer.append("\t").append(tab).append("<ChainingMethodOrProperty>\n");
            for (VariableBase variableBase : this.chainingMethodOrProperty) {
                variableBase.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append("\t").append(tab).append("</ChainingMethodOrProperty>");
        }
        buffer.append("\n");
        buffer.append(tab).append("</ChainingInstanceCall>");
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        PHPArrayDereferenceList arrayDereferenceList = ASTNode.copySubtree(target, this.getArrayDereferenceList());
        List chainingMethodOrProperty = ASTNode.copySubtrees(target, this.getChainingMethodOrProperty());
        ChainingInstanceCall result = new ChainingInstanceCall(this.getStart(), this.getEnd(), target, arrayDereferenceList, chainingMethodOrProperty);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == ARRAY_DEREFERENCE_LIST) {
            if (get) {
                return this.getArrayDereferenceList();
            }
            this.setArrayDereferenceList((PHPArrayDereferenceList)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

