/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.php.internal.ui.wizards.Messages;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public abstract class NewGenericFileTemplatesWizardPage
extends WizardPage {
    protected String fLastSelectedTemplateName;
    private SourceViewer fPatternViewer;
    private TableViewer fTableViewer;
    private ProjectTemplateStore fTemplateStore;
    protected Button fUseTemplateButton;
    private IProject fProject;

    public NewGenericFileTemplatesWizardPage(String title, String description) {
        super("NewGenericTemplatesWizardPage", title, null);
        this.setDescription(description);
    }

    private void configureTableResizing(final Composite parent, final Table table, final TableColumn column1, final TableColumn column2) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                }
            }
        });
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.fUseTemplateButton = new Button(parent, 32);
        this.fUseTemplateButton.setText(this.getUseTemplateMessage());
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fUseTemplateButton.setLayoutData((Object)data);
        this.fUseTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewGenericFileTemplatesWizardPage.this.enableTemplates();
            }
        });
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        innerParent.setLayoutData((Object)gd);
        Link link = new Link(innerParent, 0);
        link.setText(this.getTemplatesLocationMessage());
        data = new GridData(4, 4, true, false, 2, 1);
        link.setLayoutData((Object)data);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewGenericFileTemplatesWizardPage.this.linkClicked();
            }
        });
        Table table = new Table(innerParent, 67584);
        data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(2);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.NewGenericFileTemplatesWizardPage_0);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.NewGenericFileTemplatesWizardPage_1);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Template && object2 instanceof Template) {
                    Template left = (Template)object1;
                    Template right = (Template)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NewGenericFileTemplatesWizardPage.this.updateViewerInput();
            }
        });
        this.fPatternViewer = this.doCreateViewer(parent);
        this.configureTableResizing(innerParent, table, column1, column2);
        String helpId = this.getNewFileWizardTemplatePageHelpId();
        if (helpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpId);
        }
        this.resetTableViewerInput();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.new");
        this.setControl((Control)parent);
    }

    public void resetTableViewerInput() {
        IProject newProject = this.getProject();
        if (this.fProject == null && this.fProject != newProject || this.fProject != null && !this.fProject.equals((Object)newProject)) {
            this.fProject = newProject;
            this.fTemplateStore = this.getTemplateStore();
            this.fTableViewer.setInput((Object)this.fTemplateStore);
            this.loadLastSavedPreferences();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resetTableViewerInput();
        }
        super.setVisible(visible);
    }

    protected abstract ProjectTemplateStore getTemplateStore();

    protected abstract String getNewFileWizardTemplatePageHelpId();

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new PHPStructuredTextViewerConfiguration();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForPHP.ContentTypeID_PHP);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.NewGenericFileTemplatesWizardPage_2);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected void enableTemplates() {
        boolean enabled = this.fUseTemplateButton.getSelection();
        if (!enabled) {
            Template template = this.getSelectedTemplate();
            this.fLastSelectedTemplateName = template != null ? template.getName() : "";
            this.fTableViewer.setSelection(null);
        } else {
            this.setSelectedTemplate(this.fLastSelectedTemplateName);
        }
        this.fTableViewer.getControl().setEnabled(enabled);
        this.fPatternViewer.getControl().setEnabled(enabled);
    }

    protected abstract String getPreferencePageId();

    private Template getSelectedTemplate() {
        Template template = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            template = (Template)selection.getFirstElement();
        }
        return template;
    }

    public PHPTemplateStore.CompiledTemplate compileTemplate() {
        Template template = this.getSelectedTemplate();
        return PHPTemplateStore.compileTemplate(this.getTemplatesContextTypeRegistry(), template);
    }

    public PHPTemplateStore.CompiledTemplate compileTemplate(String containerName, String fileName) {
        Template template = this.getSelectedTemplate();
        return PHPTemplateStore.compileTemplate(this.getTemplatesContextTypeRegistry(), template, containerName, fileName);
    }

    public TemplateProposal createTemplateProposal() {
        TemplateProposal proposal = null;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            TemplateContextType contextType = this.getTemplatesContextTypeRegistry().getContextType(this.getTemplateContextTypeId());
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)new Document(), 0, 0);
            proposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)new Region(0, 0), null);
        }
        return proposal;
    }

    void linkClicked() {
        String pageId = this.getPreferencePageId();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
        this.fTableViewer.refresh();
    }

    protected void loadLastSavedPreferences() {
        String templateName = this.getPreferenceStore().getString("newFileTemplateName");
        if (templateName == null || templateName.length() == 0) {
            this.fLastSelectedTemplateName = "";
            this.fUseTemplateButton.setSelection(false);
        } else {
            this.fLastSelectedTemplateName = templateName;
            this.fUseTemplateButton.setSelection(true);
        }
        this.enableTemplates();
    }

    protected IProject getProject() {
        IWizard wizard = this.getWizard();
        IProject project = null;
        if (wizard instanceof PHPFileCreationWizard) {
            project = ((PHPFileCreationWizard)wizard).getProject();
        }
        return project;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    void saveLastSavedPreferences() {
        String templateName = "";
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        this.getPreferenceStore().setValue("newFileTemplateName", templateName);
    }

    private void setSelectedTemplate(String templateName) {
        Object template = null;
        if (templateName != null && templateName.length() > 0) {
            template = this.fTemplateStore.findTemplate(templateName, this.getTemplateContextTypeId());
        }
        if (template == null) {
            template = this.fTableViewer.getElementAt(0);
        }
        if (template != null) {
            StructuredSelection selection = new StructuredSelection(template);
            this.fTableViewer.setSelection((ISelection)selection, true);
        }
    }

    void updateViewerInput() {
        Template template = this.getSelectedTemplate();
        if (template != null) {
            this.fPatternViewer.getDocument().set(template.getPattern());
        }
    }

    protected abstract String getTemplateContextTypeId();

    protected abstract String getUseTemplateMessage();

    protected abstract String getTemplatesLocationMessage();

    protected abstract ContextTypeRegistry getTemplatesContextTypeRegistry();

    private class TemplateContentProvider
    implements IStructuredContentProvider {
        private ProjectTemplateStore fStore;

        private TemplateContentProvider() {
        }

        public void dispose() {
            this.fStore = null;
        }

        public Object[] getElements(Object input) {
            return this.fStore.getTemplates(NewGenericFileTemplatesWizardPage.this.getTemplateContextTypeId());
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fStore = (ProjectTemplateStore)newInput;
        }
    }

    private class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Template template = (Template)element;
            switch (columnIndex) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    return template.getDescription();
                }
            }
            return "";
        }
    }
}

