/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PHPEditorPreferencePage
extends AbstractPreferencePage {
    private Button useSmartHomeEndCB;
    private Button useSmartSubWordNavigation;

    protected Control createContents(Composite parent) {
        this.createHeader(parent);
        this.createMainComposite(parent);
        this.initValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.editor_preferences");
        return super.createContents(parent);
    }

    private void createMainComposite(Composite parent) {
        Composite firstComposite = new Composite(parent, 4);
        firstComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        firstComposite.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.useSmartHomeEndCB = new Button(firstComposite, 16416);
        this.useSmartHomeEndCB.setLayoutData((Object)gd);
        this.useSmartHomeEndCB.setText(PHPUIMessages.PHPEditorPreferencePage_smartCaretPositioning);
        gd = new GridData(768);
        this.useSmartSubWordNavigation = new Button(firstComposite, 16416);
        this.useSmartSubWordNavigation.setLayoutData((Object)gd);
        this.useSmartSubWordNavigation.setText(PHPUIMessages.PHPEditorPreferencePage_0);
    }

    protected void performDefaults() {
        this.useSmartHomeEndCB.setSelection(true);
        this.useSmartSubWordNavigation.setSelection(true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        store.setValue("useSmartHomeEnd", this.useSmartHomeEndCB.getSelection());
        store.setValue("editorSubWordNavigation", this.useSmartSubWordNavigation.getSelection());
        return super.performOk();
    }

    private void createHeader(Composite contents) {
        final Shell shell = contents.getShell();
        String text = PHPUIMessages.PHPEditorPreferencePage_prefEditorMessage;
        Link link = new Link(contents, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PHPUIMessages.PHPEditorPreferencePage_prefEditorTooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
    }

    protected void initValues() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        this.useSmartHomeEndCB.setSelection(store.getBoolean("useSmartHomeEnd"));
        this.useSmartSubWordNavigation.setSelection(store.getBoolean("editorSubWordNavigation"));
        super.initializeValues();
    }
}

