/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.phar.PharException;
import org.eclipse.php.internal.core.phar.PharFile;
import org.eclipse.php.internal.core.tar.TarException;
import org.eclipse.php.internal.core.tar.TarFile;
import org.eclipse.php.internal.ui.phar.wizard.ArchiveFileManipulations;
import org.eclipse.php.internal.ui.phar.wizard.PharImportMessages;
import org.eclipse.php.internal.ui.phar.wizard.PharLeveledStructureProvider;
import org.eclipse.php.internal.ui.phar.wizard.TarLeveledStructureProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardPharFileResourceImportPage1
extends WizardFileSystemResourceImportPage1
implements Listener {
    ILeveledImportStructureProvider structureProvider;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.phar;*.zip;*.tar;*.tar.gz;*.tgz;*.tar.bz2", "*.*"};
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardZipFileResourceImportPage1.STORE_SELECTED_TYPES_ID";
    private final String[] fileImportMask;

    public WizardPharFileResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        this(aWorkbench, selection, null);
    }

    public WizardPharFileResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection, String[] fileImportMask) {
        super("zipFileImportPage1", aWorkbench, selection);
        this.setTitle(PharImportMessages.ArchiveExport_exportTitle);
        this.setDescription(PharImportMessages.ArchiveImport_description);
        this.fileImportMask = fileImportMask == null ? FILE_IMPORT_MASK : fileImportMask;
    }

    public boolean cancel() {
        this.disposeStructureProvider();
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.phar_file_import_wizard_page");
    }

    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingResourcesCheckbox = new Button(parent, 32);
        this.overwriteExistingResourcesCheckbox.setText(PharImportMessages.FileImport_overwriteExisting);
        this.overwriteExistingResourcesCheckbox.setFont(parent.getFont());
    }

    private boolean validateSourceFile(String fileName) {
        if (ArchiveFileManipulations.isPharFile(fileName)) {
            PharFile pharFile = this.getSpecifiedPharSourceFile(fileName);
            if (pharFile != null) {
                ArchiveFileManipulations.closePharFile(pharFile, this.getShell());
                return true;
            }
            return false;
        }
        if (ArchiveFileManipulations.isTarFile(fileName)) {
            TarFile tarFile = this.getSpecifiedTarSourceFile(fileName);
            if (tarFile != null) {
                ArchiveFileManipulations.closeTarFile(tarFile, this.getShell());
                return true;
            }
            return false;
        }
        ZipFile zipFile = this.getSpecifiedZipSourceFile(fileName);
        if (zipFile != null) {
            ArchiveFileManipulations.closeZipFile(zipFile, this.getShell());
            return true;
        }
        return false;
    }

    private PharFile getSpecifiedPharSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new PharFile(new File(fileName));
        }
        catch (PharException e) {
            this.displayErrorDialog(e.getLocalizedMessage());
        }
        catch (IOException iOException) {
            this.displayErrorDialog(PharImportMessages.ZipImport_couldNotRead);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    private boolean ensureZipSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedZipSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeZipFile(specifiedFile, this.getShell());
    }

    private boolean ensureTarSourceIsValid() {
        TarFile specifiedFile = this.getSpecifiedTarSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeTarFile(specifiedFile, this.getShell());
    }

    private boolean ensurePharSourceIsValid() {
        PharFile specifiedFile = this.getSpecifiedPharSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closePharFile(specifiedFile, this.getShell());
    }

    protected boolean ensureSourceIsValid() {
        if (ArchiveFileManipulations.isPharFile(this.sourceNameField.getText())) {
            return this.ensurePharSourceIsValid();
        }
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            return this.ensureTarSourceIsValid();
        }
        return this.ensureZipSourceIsValid();
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.disposeStructureProvider();
        return true;
    }

    private void disposeStructureProvider() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        this.structureProvider = null;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    AdaptableList l = element.getFiles((IImportStructureProvider)WizardPharFileResourceImportPage1.this.structureProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        this.disposeStructureProvider();
        if (ArchiveFileManipulations.isPharFile(this.sourceNameField.getText())) {
            PharFile sourceTarFile = this.getSpecifiedPharSourceFile();
            if (sourceTarFile == null) {
                return null;
            }
            this.structureProvider = new PharLeveledStructureProvider(sourceTarFile);
            return this.selectFiles(this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider);
        }
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            TarFile sourceTarFile = this.getSpecifiedTarSourceFile();
            if (sourceTarFile == null) {
                return null;
            }
            this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
            return this.selectFiles(this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider);
        }
        ZipFile sourceFile = this.getSpecifiedZipSourceFile();
        if (sourceFile == null) {
            return null;
        }
        this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
        return this.selectFiles(this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    AdaptableList l = element.getFolders((IImportStructureProvider)WizardPharFileResourceImportPage1.this.structureProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                return o instanceof MinimizedFileSystemElement;
            }
        };
    }

    protected String getSourceLabel() {
        return PharImportMessages.ArchiveImport_fromFile;
    }

    protected ZipFile getSpecifiedZipSourceFile() {
        return this.getSpecifiedZipSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(PharImportMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(PharImportMessages.ZipImport_couldNotRead);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected TarFile getSpecifiedTarSourceFile() {
        return this.getSpecifiedTarSourceFile(this.sourceNameField.getText());
    }

    protected PharFile getSpecifiedPharSourceFile() {
        return this.getSpecifiedPharSourceFile(this.sourceNameField.getText());
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(PharImportMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(PharImportMessages.ZipImport_couldNotRead);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && this.validateSourceFile(selectedFile)) {
            this.setSourceName(selectedFile);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResources(List fileSystemObjects) {
        Object importStructureProvider = null;
        if (ArchiveFileManipulations.isPharFile(this.sourceNameField.getText())) {
            if (this.ensurePharSourceIsValid()) {
                PharFile pharFile = this.getSpecifiedPharSourceFile();
                importStructureProvider = new PharLeveledStructureProvider(pharFile);
            }
        } else if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            if (this.ensureTarSourceIsValid()) {
                TarFile tarFile = this.getSpecifiedTarSourceFile();
                importStructureProvider = new TarLeveledStructureProvider(tarFile);
            }
        } else if (this.ensureZipSourceIsValid()) {
            ZipFile zipFile = this.getSpecifiedZipSourceFile();
            importStructureProvider = new ZipLeveledStructureProvider(zipFile);
        }
        if (importStructureProvider == null) {
            return false;
        }
        ImportOperation operation = new ImportOperation(this.getContainerFullPath(), importStructureProvider.getRoot(), (IImportStructureProvider)importStructureProvider, (IOverwriteQuery)this, fileSystemObjects);
        operation.setContext(this.getShell());
        if (!this.executeImportOperation(operation)) {
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(importStructureProvider, this.getShell());
        return true;
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 0x10001000);
        dialog.setFilterExtensions(this.fileImportMask);
        dialog.setText(PharImportMessages.ArchiveImportSource_title);
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void resetSelection() {
        super.resetSelection();
        this.setAllSelections(true);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    protected boolean validateSourceGroup() {
        if (this.structureProvider == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        List resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.size() == 0) {
            this.setErrorMessage(PharImportMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }
}

