/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.php.internal.ui.refactor.processors.DeleteUserInterfaceManager;
import org.eclipse.php.internal.ui.refactor.processors.ScriptDeleteProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.DeleteAction_3);
        this.setDescription(ReorgMessages.DeleteAction_4);
        ISharedImages workbenchImages = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects((List)selection.toList())) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        try {
            this.setEnabled(RefactoringAvailabilityTester.isDeleteAvailable((Object[])selection.toArray()));
        }
        catch (CoreException e) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)e)) {
                DLTKUIPlugin.log((Throwable)e);
            }
            this.setEnabled(false);
        }
    }

    private IAction createWorkbenchAction(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects((List)selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            this.startDeleteRefactoring(selection.toArray(), this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void startDeleteRefactoring(Object[] elements, Shell shell) throws CoreException {
        DeleteRefactoring refactoring = new DeleteRefactoring((DeleteProcessor)new ScriptDeleteProcessor(elements));
        DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, false);
    }
}

