/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.ui.view;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Scene;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.examples.logo.MvcLogoExample;
import org.eclipse.gef.mvc.examples.logo.MvcLogoExampleModule;
import org.eclipse.gef.mvc.examples.logo.MvcLogoExampleViewersComposite;
import org.eclipse.gef.mvc.examples.logo.model.GeometricCurve;
import org.eclipse.gef.mvc.examples.logo.ui.MvcLogoExampleUiModule;
import org.eclipse.gef.mvc.examples.logo.ui.properties.GeometricCurvePropertySource;
import org.eclipse.gef.mvc.examples.logo.ui.properties.MvcLogoExampleViewPropertySource;
import org.eclipse.gef.mvc.fx.behaviors.SelectionBehavior;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.ui.actions.FitToViewportAction;
import org.eclipse.gef.mvc.fx.ui.actions.FitToViewportLockAction;
import org.eclipse.gef.mvc.fx.ui.actions.ScrollActionGroup;
import org.eclipse.gef.mvc.fx.ui.actions.ZoomActionGroup;
import org.eclipse.gef.mvc.fx.ui.parts.AbstractFXView;
import org.eclipse.gef.mvc.fx.ui.properties.SetPropertyValueOperation;
import org.eclipse.gef.mvc.fx.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.gef.mvc.fx.ui.properties.UndoablePropertySheetPage;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;

public class MvcLogoExampleView
extends AbstractFXView {
    private UndoablePropertySheetEntry rootEntry;
    private ZoomActionGroup zoomActionGroup;
    private ScrollActionGroup scrollActionGroup;
    private FitToViewportLockAction fitToViewportLockAction;

    public MvcLogoExampleView() {
        super(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new MvcLogoExampleModule()}).with(new Module[]{new MvcLogoExampleUiModule()})}));
        this.getContentViewer().getContents().setAll((Collection)MvcLogoExample.createContentViewerContents());
        this.getPaletteViewer().getContents().setAll((Collection)MvcLogoExample.createPaletteViewerContents());
    }

    public void dispose() {
        ((SelectionModel)this.getContentViewer().getAdapter(SelectionModel.class)).clearSelection();
        ((HoverModel)this.getContentViewer().getAdapter(HoverModel.class)).clearHover();
        ((FocusModel)this.getContentViewer().getAdapter(FocusModel.class)).setFocus(null);
        this.getContentViewer().contentsProperty().clear();
        ((SelectionModel)this.getPaletteViewer().getAdapter(SelectionModel.class)).clearSelection();
        ((HoverModel)this.getPaletteViewer().getAdapter(HoverModel.class)).clearHover();
        ((FocusModel)this.getPaletteViewer().getAdapter(FocusModel.class)).setFocus(null);
        this.getPaletteViewer().contentsProperty().clear();
        if (this.zoomActionGroup != null) {
            this.getContentViewer().unsetAdapter((Object)this.zoomActionGroup);
            this.zoomActionGroup.dispose();
            this.zoomActionGroup = null;
        }
        if (this.scrollActionGroup != null) {
            this.getContentViewer().unsetAdapter((Object)this.scrollActionGroup);
            this.scrollActionGroup.dispose();
            this.scrollActionGroup = null;
        }
        if (this.fitToViewportLockAction != null) {
            this.getContentViewer().unsetAdapter((Object)this.fitToViewportLockAction);
            this.fitToViewportLockAction = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.zoomActionGroup = new ZoomActionGroup(new IAction[]{new FitToViewportAction()});
        this.getContentViewer().setAdapter((Object)this.zoomActionGroup);
        this.fitToViewportLockAction = new FitToViewportLockAction();
        this.getContentViewer().setAdapter((Object)this.fitToViewportLockAction);
        this.scrollActionGroup = new ScrollActionGroup();
        this.getContentViewer().setAdapter((Object)this.scrollActionGroup);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager mgr = actionBars.getToolBarManager();
        this.zoomActionGroup.fillActionBars(actionBars);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.fitToViewportLockAction);
        mgr.add((IContributionItem)new Separator());
        this.scrollActionGroup.fillActionBars(actionBars);
    }

    public Object getAdapter(Class key) {
        if (IPropertySheetPage.class.equals((Object)key)) {
            UndoablePropertySheetPage propertySheetPage = (UndoablePropertySheetPage)super.getAdapter(key);
            if (this.rootEntry == null) {
                this.rootEntry = new UndoablePropertySheetEntry((IWorkbenchPart)this, (IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class)){

                    private Point computeEndHint(Connection connection) {
                        if (connection.getEndAnchor() instanceof DynamicAnchor && connection.getPointsUnmodifiable().size() > 1) {
                            Point endPoint = connection.getEndPoint();
                            Point neighbor = connection.getPoint(connection.getPointsUnmodifiable().size() - 2);
                            Point translated = endPoint.getTranslated(endPoint.getDifference(neighbor).getScaled(0.5));
                            return translated;
                        }
                        return null;
                    }

                    private Point computeStartHint(Connection connection) {
                        if (connection.getStartAnchor() instanceof DynamicAnchor && connection.getPointsUnmodifiable().size() > 1) {
                            Point startPoint = connection.getStartPoint();
                            Point neighbor = connection.getPoint(1);
                            Point translated = startPoint.getTranslated(startPoint.getDifference(neighbor).getScaled(0.5));
                            return translated;
                        }
                        return null;
                    }

                    protected void valueChanged(UndoablePropertySheetEntry child, ITransactionalOperation operation) {
                        if (operation instanceof SetPropertyValueOperation) {
                            SetPropertyValueOperation changeRoutingStyleOperation = (SetPropertyValueOperation)operation;
                            if (changeRoutingStyleOperation.getPropertySource() instanceof GeometricCurvePropertySource && GeometricCurvePropertySource.ROUTING_STYLE_PROPERTY.getId().equals(changeRoutingStyleOperation.getPropertyId())) {
                                GeometricCurvePropertySource ps = (GeometricCurvePropertySource)changeRoutingStyleOperation.getPropertySource();
                                IContentPart contentPart = (IContentPart)MvcLogoExampleView.this.getContentViewer().getContentPartMap().get(ps.getCurve());
                                ArrayList<Point> newWaypoints = new ArrayList<Point>();
                                List currentWaypoints = ps.getCurve().getWayPointsCopy();
                                newWaypoints.add(this.computeStartHint((Connection)contentPart.getVisual()));
                                newWaypoints.add(this.computeEndHint((Connection)contentPart.getVisual()));
                                ChangeWayPointsOperation clearWaypointsOperation = new ChangeWayPointsOperation("Clear waypoints", ps.getCurve(), currentWaypoints, newWaypoints);
                                ForwardUndoCompositeOperation c = new ForwardUndoCompositeOperation("Change routing style");
                                c.add((IUndoableOperation)changeRoutingStyleOperation);
                                c.add((IUndoableOperation)clearWaypointsOperation);
                                c.add((IUndoableOperation)new UpdateSelectionHandlesOperation((IContentPart<? extends Node>)contentPart));
                                super.valueChanged(child, (ITransactionalOperation)c);
                            } else {
                                super.valueChanged(child, operation);
                            }
                        } else {
                            super.valueChanged(child, operation);
                        }
                    }
                };
                propertySheetPage.setRootEntry((IPropertySheetEntry)this.rootEntry);
            }
            return propertySheetPage;
        }
        if (IPropertySource.class.equals((Object)key)) {
            return new MvcLogoExampleViewPropertySource(this);
        }
        return super.getAdapter(key);
    }

    protected IViewer getPaletteViewer() {
        return (IViewer)this.getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"paletteViewer"));
    }

    protected void hookViewers() {
        MvcLogoExampleViewersComposite viewersComposite = new MvcLogoExampleViewersComposite(this.getContentViewer(), this.getPaletteViewer());
        this.getCanvas().setScene(new Scene(viewersComposite.getComposite()));
    }

    public static final class ChangeWayPointsOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private final GeometricCurve curve;
        private final List<Point> newWayPoints;
        private final List<Point> oldWayPoints;

        public ChangeWayPointsOperation(String label, GeometricCurve curve, List<Point> oldWayPoints, List<Point> newWayPoints) {
            super(label);
            this.curve = curve;
            this.oldWayPoints = oldWayPoints;
            this.newWayPoints = newWayPoints;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.newWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }

        public boolean isContentRelevant() {
            return true;
        }

        public boolean isNoOp() {
            return this.oldWayPoints == this.newWayPoints || this.oldWayPoints != null && this.oldWayPoints.equals(this.newWayPoints);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.oldWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }
    }

    private static class UpdateSelectionHandlesOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private IContentPart<? extends Node> part;

        public UpdateSelectionHandlesOperation(IContentPart<? extends Node> part) {
            super("UpdateHandles");
            this.part = part;
        }

        public boolean isContentRelevant() {
            return false;
        }

        public boolean isNoOp() {
            return false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ((SelectionBehavior)this.part.getRoot().getAdapter(SelectionBehavior.class)).updateHandles(this.part, null, null);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }
    }
}

