/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelPackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotHtmlLabelJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotHtmlLabelJavaValidator
extends AbstractDotHtmlLabelJavaValidator {
    @Check
    public void checkTagIsClosed(HtmlTag tag) {
        if (!tag.getName().toUpperCase().equals(tag.getCloseName().toUpperCase())) {
            this.reportRangeBasedError("Tag '<" + tag.getName() + ">' is not closed (expected '</" + tag.getName() + ">' but got '</" + tag.getCloseName() + ">').", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__CLOSE_NAME);
        }
    }

    @Check
    public void checkSelfClosingTagIsAllowed(HtmlTag tag) {
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (tag.isSelfClosing() && DotHtmlLabelHelper.getNonSelfClosingTags().contains(tagNameUpperCase)) {
            this.reportRangeBasedError("Tag '<" + tag.getName() + "/>' cannot be self closing.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        }
    }

    @Check
    public void checkStringLiteralIsAllowed(HtmlTag tag) {
        Object[] stringLiteralIsNotAllowed = new String[]{"BR", "HR", "IMG", "TABLE", "TR", "VR"};
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (Arrays.binarySearch(stringLiteralIsNotAllowed, tagNameUpperCase) >= 0) {
            for (HtmlContent child : tag.getChildren()) {
                String text = child.getText();
                if (text == null || text.trim().isEmpty()) continue;
                this.reportRangeBasedError("Tag '<" + tag.getName() + ">' cannot contain a string literal.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkTagNameIsValid(HtmlTag tag) {
        String tagName = tag.getName();
        if (!DotHtmlLabelHelper.getAllTags().contains(tagName.toUpperCase())) {
            this.reportRangeBasedError("Tag '<" + tagName + ">' is not supported.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        } else {
            EObject container = tag.eContainer().eContainer();
            HtmlTag parent = null;
            if (container instanceof HtmlTag) {
                parent = (HtmlTag)container;
            }
            String parentName = parent == null ? DotHtmlLabelHelper.getRootTagKey() : parent.getName();
            Map<String, Set<String>> validTags = DotHtmlLabelHelper.getValidTags();
            if (!validTags.containsKey(parentName.toUpperCase()) || !validTags.get(parentName.toUpperCase()).contains(tagName.toUpperCase())) {
                this.reportRangeBasedError("Tag '<" + tagName + ">' is not allowed inside '<" + parentName + ">', but only inside '<" + String.join((CharSequence)">', '<", (Iterable<? extends CharSequence>)DotHtmlLabelHelper.getAllowedParents().get(tagName.toUpperCase())) + ">'.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkAttributeNameIsValid(HtmlAttr attr) {
        String attrName = attr.getName();
        EObject container = attr.eContainer();
        if (container instanceof HtmlTag) {
            HtmlTag tag = (HtmlTag)container;
            String tagName = tag.getName();
            Map<String, Set<String>> validAttributes = DotHtmlLabelHelper.getValidAttributes();
            if (!validAttributes.containsKey(tagName.toUpperCase()) || !validAttributes.get(tagName.toUpperCase()).contains(attrName.toUpperCase())) {
                this.reportRangeBasedError("Attribute '" + attrName + "' is not allowed inside '<" + tagName + ">'.", attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__NAME);
            }
        }
    }

    private void reportRangeBasedError(String message, EObject object, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = null;
        this.getMessageAcceptor().acceptError(message, object, offset, length, code, issueData);
    }
}

