/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.DotStandaloneSetup;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotAst;
import org.eclipse.gef.dot.internal.language.dot.DotFactory;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Stmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.parser.antlr.DotParser;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DotImport {
    @Inject
    private static IParser dotParser;
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalGraphAttributes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalNodeAttributes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalEdgeAttributes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, Node> _createCache_createSubgraph = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, Node> _createCache_createNode = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    private static IParser getDotParser() {
        boolean _tripleEquals;
        boolean bl = _tripleEquals = dotParser == null;
        if (_tripleEquals) {
            DotStandaloneSetup _dotStandaloneSetup = new DotStandaloneSetup();
            Injector _createInjectorAndDoEMFRegistration = _dotStandaloneSetup.createInjectorAndDoEMFRegistration();
            DotParser _instance = (DotParser)((Object)_createInjectorAndDoEMFRegistration.getInstance(DotParser.class));
            dotParser = _instance;
        }
        return dotParser;
    }

    public List<Graph> importDot(File dotFile) {
        String _read = DotFileUtils.read(dotFile);
        return this.importDot(_read);
    }

    public List<Graph> importDot(String dotString) {
        StringReader _stringReader;
        List _xblockexpression = null;
        IParser _dotParser = DotImport.getDotParser();
        IParseResult parseResult = _dotParser.parse((Reader)(_stringReader = new StringReader(dotString)));
        boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
        if (_hasSyntaxErrors) {
            Iterable _syntaxErrors = parseResult.getSyntaxErrors();
            Functions.Function1<INode, String> _function = new Functions.Function1<INode, String>(){

                public String apply(INode it) {
                    SyntaxErrorMessage _syntaxErrorMessage = it.getSyntaxErrorMessage();
                    return _syntaxErrorMessage.getMessage();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_syntaxErrors, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
            String _plus = "Given DOT string is not valid: " + _join;
            throw new IllegalArgumentException(_plus);
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        EList<DotGraph> _graphs = ((DotAst)_rootASTElement).getGraphs();
        Functions.Function1<DotGraph, Graph> _function_1 = new Functions.Function1<DotGraph, Graph>(){

            public Graph apply(DotGraph it) {
                return DotImport.this.transformDotGraph(it);
            }
        };
        List _map_1 = ListExtensions.map(_graphs, (Functions.Function1)_function_1);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map_1);
        _xblockexpression = IterableExtensions.toList((Iterable)_filterNull);
        return _xblockexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalGraphAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalGraphAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalGraphAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalGraphAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this._createCache_globalGraphAttributes.put(_cacheKey, _result);
        }
        this._init_globalGraphAttributes(_result, context);
        return _result;
    }

    private void _init_globalGraphAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalNodeAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalNodeAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalNodeAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalNodeAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this._createCache_globalNodeAttributes.put(_cacheKey, _result);
        }
        this._init_globalNodeAttributes(_result, context);
        return _result;
    }

    private void _init_globalNodeAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalEdgeAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalEdgeAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalEdgeAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalEdgeAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this._createCache_globalEdgeAttributes.put(_cacheKey, _result);
        }
        this._init_globalEdgeAttributes(_result, context);
        return _result;
    }

    private void _init_globalEdgeAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    private Graph transformDotGraph(final DotGraph it) {
        Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>> _function_2;
        boolean _tripleNotEquals;
        Graph _xblockexpression = null;
        this._createCache_globalGraphAttributes.clear();
        this._createCache_globalNodeAttributes.clear();
        this._createCache_globalEdgeAttributes.clear();
        this._createCache_createNode.clear();
        this._createCache_createSubgraph.clear();
        final Graph.Builder graphBuilder = new Graph.Builder();
        ID _name = it.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            ID _name_1 = it.getName();
            graphBuilder.attr("_name", (Object)_name_1);
        }
        GraphType _type = it.getType();
        graphBuilder.attr("_type", (Object)_type);
        EList<Stmt> _stmts = it.getStmts();
        Functions.Function1<Stmt, Boolean> _function = new Functions.Function1<Stmt, Boolean>(){

            public Boolean apply(Stmt it) {
                return !(it instanceof Attribute);
            }
        };
        Iterable _filter = IterableExtensions.filter(_stmts, (Functions.Function1)_function);
        Consumer<Stmt> _function_1 = new Consumer<Stmt>(){

            @Override
            public void accept(Stmt it) {
                DotImport.this.transformStmt(it, graphBuilder);
            }
        };
        _filter.forEach(_function_1);
        final Graph graph = graphBuilder.build();
        Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>> setter = _function_2 = new Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>>(){

            public void apply(String attributeName, Procedures.Procedure2<? super Graph, ? super ID> f) {
                boolean _tripleNotEquals;
                ID attributeValue = DotAstHelper.getAttributeValue(it, attributeName);
                boolean bl = _tripleNotEquals = attributeValue != null;
                if (_tripleNotEquals) {
                    f.apply((Object)graph, (Object)attributeValue);
                } else {
                    Map _globalGraphAttributes = DotImport.this.globalGraphAttributes(graphBuilder);
                    boolean _containsKey = _globalGraphAttributes.containsKey(attributeName);
                    if (_containsKey) {
                        Map _globalGraphAttributes_1 = DotImport.this.globalGraphAttributes(graphBuilder);
                        ID _get = (ID)_globalGraphAttributes_1.get(attributeName);
                        f.apply((Object)graph, (Object)_get);
                    }
                }
            }
        };
        Procedures.Procedure2<Graph, ID> _function_3 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setBbRaw(g, value);
            }
        };
        setter.apply((Object)"bb", (Object)_function_3);
        Procedures.Procedure2<Graph, ID> _function_4 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setBgcolorRaw(g, value);
            }
        };
        setter.apply((Object)"bgcolor", (Object)_function_4);
        Procedures.Procedure2<Graph, ID> _function_5 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setClusterrankRaw(g, value);
            }
        };
        setter.apply((Object)"clusterrank", (Object)_function_5);
        Procedures.Procedure2<Graph, ID> _function_6 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setFontcolorRaw(g, value);
            }
        };
        setter.apply((Object)"fontcolor", (Object)_function_6);
        Procedures.Procedure2<Graph, ID> _function_7 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setLabelRaw(g, value);
            }
        };
        setter.apply((Object)"label", (Object)_function_7);
        Procedures.Procedure2<Graph, ID> _function_8 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setLayoutRaw(g, value);
            }
        };
        setter.apply((Object)"layout", (Object)_function_8);
        Procedures.Procedure2<Graph, ID> _function_9 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setOutputorderRaw(g, value);
            }
        };
        setter.apply((Object)"outputorder", (Object)_function_9);
        Procedures.Procedure2<Graph, ID> _function_10 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setPagedirRaw(g, value);
            }
        };
        setter.apply((Object)"pagedir", (Object)_function_10);
        Procedures.Procedure2<Graph, ID> _function_11 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setRankdirRaw(g, value);
            }
        };
        setter.apply((Object)"rankdir", (Object)_function_11);
        Procedures.Procedure2<Graph, ID> _function_12 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setSplinesRaw(g, value);
            }
        };
        setter.apply((Object)"splines", (Object)_function_12);
        _xblockexpression = graph;
        return _xblockexpression;
    }

    private Node transformNodeId(NodeId it, Graph.Builder graphBuilder) {
        AttrList _createAttrList = DotFactory.eINSTANCE.createAttrList();
        return this.transformNodeId(it, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AttrList[]{_createAttrList})), graphBuilder);
    }

    private Node transformNodeId(NodeId it, final List<AttrList> attrLists, final Graph.Builder graphBuilder) {
        Procedures.Procedure2<String, Procedures.Procedure2<? super Node, ? super ID>> _function;
        Node _xblockexpression = null;
        ID _name = it.getName();
        String _value = _name.toValue();
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{_value});
        final boolean isExistingNode = this._createCache_createNode.containsKey(_newArrayList);
        ID _name_1 = it.getName();
        String _value_1 = _name_1.toValue();
        final Node node = this.createNode(_value_1);
        if (!isExistingNode) {
            ID _name_2 = it.getName();
            DotAttributes._setNameRaw(node, _name_2);
            graphBuilder.nodes(new Node[]{node});
        }
        Procedures.Procedure2<String, Procedures.Procedure2<? super Node, ? super ID>> setter = _function = new Procedures.Procedure2<String, Procedures.Procedure2<? super Node, ? super ID>>(){

            public void apply(String attributeName, Procedures.Procedure2<? super Node, ? super ID> f) {
                boolean _tripleNotEquals;
                ID attributeValue = DotAstHelper.getAttributeValue(attrLists, attributeName);
                boolean bl = _tripleNotEquals = attributeValue != null;
                if (_tripleNotEquals) {
                    f.apply((Object)node, (Object)attributeValue);
                } else {
                    boolean _and = false;
                    if (isExistingNode) {
                        _and = false;
                    } else {
                        boolean _containsKey;
                        Map _globalNodeAttributes = DotImport.this.globalNodeAttributes(graphBuilder);
                        _and = _containsKey = _globalNodeAttributes.containsKey(attributeName);
                    }
                    if (_and) {
                        Map _globalNodeAttributes_1 = DotImport.this.globalNodeAttributes(graphBuilder);
                        ID _get = (ID)_globalNodeAttributes_1.get(attributeName);
                        f.apply((Object)node, (Object)_get);
                    }
                }
            }
        };
        Procedures.Procedure2<Node, ID> _function_1 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setColorRaw(n, value);
            }
        };
        setter.apply((Object)"color", (Object)_function_1);
        Procedures.Procedure2<Node, ID> _function_2 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setColorschemeRaw(n, value);
            }
        };
        setter.apply((Object)"colorscheme", (Object)_function_2);
        Procedures.Procedure2<Node, ID> _function_3 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setDistortionRaw(n, value);
            }
        };
        setter.apply((Object)"distortion", (Object)_function_3);
        Procedures.Procedure2<Node, ID> _function_4 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setFillcolorRaw(n, value);
            }
        };
        setter.apply((Object)"fillcolor", (Object)_function_4);
        Procedures.Procedure2<Node, ID> _function_5 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setFixedsizeRaw(n, value);
            }
        };
        setter.apply((Object)"fixedsize", (Object)_function_5);
        Procedures.Procedure2<Node, ID> _function_6 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setFontcolorRaw(n, value);
            }
        };
        setter.apply((Object)"fontcolor", (Object)_function_6);
        Procedures.Procedure2<Node, ID> _function_7 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setHeightRaw(n, value);
            }
        };
        setter.apply((Object)"height", (Object)_function_7);
        Procedures.Procedure2<Node, ID> _function_8 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setIdRaw(n, value);
            }
        };
        setter.apply((Object)"id", (Object)_function_8);
        Procedures.Procedure2<Node, ID> _function_9 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setLabelRaw(n, value);
            }
        };
        setter.apply((Object)"label", (Object)_function_9);
        Procedures.Procedure2<Node, ID> _function_10 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setPosRaw(n, value);
            }
        };
        setter.apply((Object)"pos", (Object)_function_10);
        Procedures.Procedure2<Node, ID> _function_11 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setShapeRaw(n, value);
            }
        };
        setter.apply((Object)"shape", (Object)_function_11);
        Procedures.Procedure2<Node, ID> _function_12 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setSidesRaw(n, value);
            }
        };
        setter.apply((Object)"sides", (Object)_function_12);
        Procedures.Procedure2<Node, ID> _function_13 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setSkewRaw(n, value);
            }
        };
        setter.apply((Object)"skew", (Object)_function_13);
        Procedures.Procedure2<Node, ID> _function_14 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setStyleRaw(n, value);
            }
        };
        setter.apply((Object)"style", (Object)_function_14);
        Procedures.Procedure2<Node, ID> _function_15 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setWidthRaw(n, value);
            }
        };
        setter.apply((Object)"width", (Object)_function_15);
        Procedures.Procedure2<Node, ID> _function_16 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setXlabelRaw(n, value);
            }
        };
        setter.apply((Object)"xlabel", (Object)_function_16);
        Procedures.Procedure2<Node, ID> _function_17 = new Procedures.Procedure2<Node, ID>(){

            public void apply(Node n, ID value) {
                DotAttributes.setXlpRaw(n, value);
            }
        };
        setter.apply((Object)"xlp", (Object)_function_17);
        _xblockexpression = node;
        return _xblockexpression;
    }

    private void _transformStmt(Stmt it, Graph.Builder graphBuilder) {
        System.err.println("DotImport cannot transform Stmt: " + it);
    }

    private void _transformStmt(AttrStmt it, final Graph.Builder graphBuilder) {
        AttributeType _type = it.getType();
        if (_type != null) {
            switch (_type) {
                case GRAPH: {
                    EList<AttrList> _attrLists = it.getAttrLists();
                    Consumer<AttrList> _function = new Consumer<AttrList>(){

                        @Override
                        public void accept(AttrList it) {
                            EList<Attribute> _attributes = it.getAttributes();
                            Consumer<Attribute> _function = new Consumer<Attribute>(){

                                @Override
                                public void accept(Attribute it) {
                                    Map _globalGraphAttributes = DotImport.this.globalGraphAttributes(graphBuilder);
                                    ID _name = it.getName();
                                    String _value = _name.toValue();
                                    ID _value_1 = it.getValue();
                                    _globalGraphAttributes.put(_value, _value_1);
                                }
                            };
                            _attributes.forEach((Consumer)_function);
                        }
                    };
                    _attrLists.forEach((Consumer)_function);
                    break;
                }
                case NODE: {
                    EList<AttrList> _attrLists_1 = it.getAttrLists();
                    Consumer<AttrList> _function_1 = new Consumer<AttrList>(){

                        @Override
                        public void accept(AttrList it) {
                            EList<Attribute> _attributes = it.getAttributes();
                            Consumer<Attribute> _function = new Consumer<Attribute>(){

                                @Override
                                public void accept(Attribute it) {
                                    Map _globalNodeAttributes = DotImport.this.globalNodeAttributes(graphBuilder);
                                    ID _name = it.getName();
                                    String _value = _name.toValue();
                                    ID _value_1 = it.getValue();
                                    _globalNodeAttributes.put(_value, _value_1);
                                }
                            };
                            _attributes.forEach((Consumer)_function);
                        }
                    };
                    _attrLists_1.forEach((Consumer)_function_1);
                    break;
                }
                case EDGE: {
                    EList<AttrList> _attrLists_2 = it.getAttrLists();
                    Consumer<AttrList> _function_2 = new Consumer<AttrList>(){

                        @Override
                        public void accept(AttrList it) {
                            EList<Attribute> _attributes = it.getAttributes();
                            Consumer<Attribute> _function = new Consumer<Attribute>(){

                                @Override
                                public void accept(Attribute it) {
                                    Map _globalEdgeAttributes = DotImport.this.globalEdgeAttributes(graphBuilder);
                                    ID _name = it.getName();
                                    String _value = _name.toValue();
                                    ID _value_1 = it.getValue();
                                    _globalEdgeAttributes.put(_value, _value_1);
                                }
                            };
                            _attributes.forEach((Consumer)_function);
                        }
                    };
                    _attrLists_2.forEach((Consumer)_function_2);
                    break;
                }
            }
        }
    }

    private void _transformStmt(NodeStmt it, Graph.Builder graphBuilder) {
        NodeId _node = it.getNode();
        EList<AttrList> _attrLists = it.getAttrLists();
        this.transformNodeId(_node, (List<AttrList>)_attrLists, graphBuilder);
    }

    private void _transformStmt(EdgeStmtNode it, Graph.Builder graphBuilder) {
        NodeId _node = it.getNode();
        Node sourceNode = this.transformNodeId(_node, graphBuilder);
        EList<EdgeRhs> _edgeRHS = it.getEdgeRHS();
        for (EdgeRhs edgeRhs : _edgeRHS) {
            boolean _matched = false;
            if (!_matched && edgeRhs instanceof EdgeRhsNode) {
                _matched = true;
                NodeId _node_1 = ((EdgeRhsNode)edgeRhs).getNode();
                Node targetNode = this.transformNodeId(_node_1, graphBuilder);
                EdgeOp _op = ((EdgeRhsNode)edgeRhs).getOp();
                String _literal = _op.getLiteral();
                EList<AttrList> _attrLists = it.getAttrLists();
                Edge _createEdge = this.createEdge(sourceNode, _literal, targetNode, (List<AttrList>)_attrLists, graphBuilder);
                graphBuilder.edges(new Edge[]{_createEdge});
                sourceNode = targetNode;
            }
            if (_matched) continue;
            System.err.println("DotImport cannot transform EdgeStmtNode: " + it);
        }
    }

    private void _transformStmt(final Subgraph it, Graph.Builder graphBuilder) {
        Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>> _function_3;
        boolean _tripleNotEquals_1;
        boolean _tripleEquals;
        boolean _tripleNotEquals;
        boolean _and = false;
        ID _name = it.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _containsKey;
            ID _name_1 = it.getName();
            String _value = _name_1.toValue();
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{_value});
            _and = _containsKey = this._createCache_createSubgraph.containsKey(_newArrayList);
        }
        boolean isExistingSubgraph = _and;
        final Graph.Builder subgraphBuilder = new Graph.Builder();
        Node _xifexpression = null;
        ID _name_2 = it.getName();
        boolean bl2 = _tripleEquals = _name_2 == null;
        if (_tripleEquals) {
            int _identityHashCode = System.identityHashCode(subgraphBuilder);
            String _string = Integer.valueOf(_identityHashCode).toString();
            _xifexpression = this.createSubgraph(_string);
        } else {
            ID _name_3 = it.getName();
            String _value_1 = _name_3.toValue();
            _xifexpression = this.createSubgraph(_value_1);
        }
        final Node subgraphNode = _xifexpression;
        ID _name_4 = it.getName();
        boolean bl3 = _tripleNotEquals_1 = _name_4 != null;
        if (_tripleNotEquals_1) {
            ID _name_5 = it.getName();
            subgraphBuilder.attr("_name", (Object)_name_5);
        }
        Map<String, ID> _globalGraphAttributes = this.globalGraphAttributes(subgraphBuilder);
        Map<String, ID> _globalGraphAttributes_1 = this.globalGraphAttributes(graphBuilder);
        _globalGraphAttributes.putAll(_globalGraphAttributes_1);
        Map<String, ID> _globalNodeAttributes = this.globalNodeAttributes(subgraphBuilder);
        Map<String, ID> _globalNodeAttributes_1 = this.globalNodeAttributes(graphBuilder);
        _globalNodeAttributes.putAll(_globalNodeAttributes_1);
        Map<String, ID> _globalEdgeAttributes = this.globalEdgeAttributes(subgraphBuilder);
        Map<String, ID> _globalEdgeAttributes_1 = this.globalEdgeAttributes(graphBuilder);
        _globalEdgeAttributes.putAll(_globalEdgeAttributes_1);
        EList<Stmt> _stmts = it.getStmts();
        Consumer<Stmt> _function = new Consumer<Stmt>(){

            @Override
            public void accept(Stmt it) {
                DotImport.this.transformStmt(it, subgraphBuilder);
            }
        };
        _stmts.forEach((Consumer)_function);
        final Graph subgraph = subgraphBuilder.build();
        if (!isExistingSubgraph) {
            subgraphNode.setNestedGraph(subgraph);
            subgraph.setNestingNode(subgraphNode);
            graphBuilder.nodes(new Node[]{subgraphNode});
        } else {
            Graph _nestedGraph = subgraphNode.getNestedGraph();
            ObservableMap _attributes = _nestedGraph.getAttributes();
            ObservableMap _attributes_1 = subgraph.getAttributes();
            _attributes.putAll((Map)_attributes_1);
            Graph _nestedGraph_1 = subgraphNode.getNestedGraph();
            ObservableList _nodes = _nestedGraph_1.getNodes();
            ObservableList _nodes_1 = subgraph.getNodes();
            Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    Graph _nestedGraph = subgraphNode.getNestedGraph();
                    ObservableList _nodes = _nestedGraph.getNodes();
                    boolean _contains = _nodes.contains((Object)it);
                    return !_contains;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_nodes_1, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)_nodes, (Iterable)_filter);
            Graph _nestedGraph_2 = subgraphNode.getNestedGraph();
            ObservableList _edges = _nestedGraph_2.getEdges();
            ObservableList _edges_1 = subgraph.getEdges();
            Functions.Function1<Edge, Boolean> _function_2 = new Functions.Function1<Edge, Boolean>(){

                public Boolean apply(Edge it) {
                    Graph _nestedGraph = subgraphNode.getNestedGraph();
                    ObservableList _nodes = _nestedGraph.getNodes();
                    boolean _contains = _nodes.contains((Object)it);
                    return !_contains;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_edges_1, (Functions.Function1)_function_2);
            Iterables.addAll((Collection)_edges, (Iterable)_filter_1);
        }
        Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>> setter = _function_3 = new Procedures.Procedure2<String, Procedures.Procedure2<? super Graph, ? super ID>>(){

            public void apply(String attributeName, Procedures.Procedure2<? super Graph, ? super ID> f) {
                boolean _tripleNotEquals;
                ID attributeValue = DotAstHelper.getAttributeValue(it, attributeName);
                boolean bl = _tripleNotEquals = attributeValue != null;
                if (_tripleNotEquals) {
                    f.apply((Object)subgraph, (Object)attributeValue);
                } else {
                    Map _globalGraphAttributes = DotImport.this.globalGraphAttributes(subgraphBuilder);
                    boolean _containsKey = _globalGraphAttributes.containsKey(attributeName);
                    if (_containsKey) {
                        Map _globalGraphAttributes_1 = DotImport.this.globalGraphAttributes(subgraphBuilder);
                        ID _get = (ID)_globalGraphAttributes_1.get(attributeName);
                        f.apply((Object)subgraph, (Object)_get);
                    }
                }
            }
        };
        Procedures.Procedure2<Graph, ID> _function_4 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setBbRaw(g, value);
            }
        };
        setter.apply((Object)"bb", (Object)_function_4);
        Procedures.Procedure2<Graph, ID> _function_5 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setBgcolorRaw(g, value);
            }
        };
        setter.apply((Object)"bgcolor", (Object)_function_5);
        Procedures.Procedure2<Graph, ID> _function_6 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setFontcolorRaw(g, value);
            }
        };
        setter.apply((Object)"fontcolor", (Object)_function_6);
        Procedures.Procedure2<Graph, ID> _function_7 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setLabelRaw(g, value);
            }
        };
        setter.apply((Object)"label", (Object)_function_7);
        Procedures.Procedure2<Graph, ID> _function_8 = new Procedures.Procedure2<Graph, ID>(){

            public void apply(Graph g, ID value) {
                DotAttributes.setRankRaw(g, value);
            }
        };
        setter.apply((Object)"rank", (Object)_function_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createSubgraph(String subgraphName) {
        Node _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{subgraphName});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createSubgraph;
        synchronized (hashMap) {
            Node _buildNode;
            if (this._createCache_createSubgraph.containsKey(_cacheKey)) {
                return this._createCache_createSubgraph.get(_cacheKey);
            }
            Node.Builder _builder = new Node.Builder();
            _result = _buildNode = _builder.buildNode();
            this._createCache_createSubgraph.put(_cacheKey, _result);
        }
        this._init_createSubgraph(_result, subgraphName);
        return _result;
    }

    private void _init_createSubgraph(Node it, String subgraphName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(String nodeName) {
        Node _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{nodeName});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createNode;
        synchronized (hashMap) {
            Node _buildNode;
            if (this._createCache_createNode.containsKey(_cacheKey)) {
                return this._createCache_createNode.get(_cacheKey);
            }
            Node.Builder _builder = new Node.Builder();
            _result = _buildNode = _builder.buildNode();
            this._createCache_createNode.put(_cacheKey, _result);
        }
        this._init_createNode(_result, nodeName);
        return _result;
    }

    private void _init_createNode(Node it, String nodeName) {
    }

    private Edge createEdge(Node sourceNode, String edgeOp, Node targetNode, final List<AttrList> attrLists, final Graph.Builder graphBuilder) {
        Procedures.Procedure2<String, Procedures.Procedure2<? super Edge, ? super ID>> _function;
        Edge _xblockexpression = null;
        Edge.Builder _builder = new Edge.Builder(sourceNode, targetNode);
        final Edge edge = _builder.buildEdge();
        Procedures.Procedure2<String, Procedures.Procedure2<? super Edge, ? super ID>> setter = _function = new Procedures.Procedure2<String, Procedures.Procedure2<? super Edge, ? super ID>>(){

            public void apply(String attributeName, Procedures.Procedure2<? super Edge, ? super ID> f) {
                boolean _tripleNotEquals;
                ID attributeValue = DotAstHelper.getAttributeValue(attrLists, attributeName);
                boolean bl = _tripleNotEquals = attributeValue != null;
                if (_tripleNotEquals) {
                    f.apply((Object)edge, (Object)attributeValue);
                } else {
                    Map _globalEdgeAttributes = DotImport.this.globalEdgeAttributes(graphBuilder);
                    boolean _containsKey = _globalEdgeAttributes.containsKey(attributeName);
                    if (_containsKey) {
                        Map _globalEdgeAttributes_1 = DotImport.this.globalEdgeAttributes(graphBuilder);
                        ID _get = (ID)_globalEdgeAttributes_1.get(attributeName);
                        f.apply((Object)edge, (Object)_get);
                    }
                }
            }
        };
        Procedures.Procedure2<Edge, ID> _function_1 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setArrowheadRaw(e, value);
            }
        };
        setter.apply((Object)"arrowhead", (Object)_function_1);
        Procedures.Procedure2<Edge, ID> _function_2 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setArrowsizeRaw(e, value);
            }
        };
        setter.apply((Object)"arrowsize", (Object)_function_2);
        Procedures.Procedure2<Edge, ID> _function_3 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setArrowtailRaw(e, value);
            }
        };
        setter.apply((Object)"arrowtail", (Object)_function_3);
        Procedures.Procedure2<Edge, ID> _function_4 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setColorRaw(e, value);
            }
        };
        setter.apply((Object)"color", (Object)_function_4);
        Procedures.Procedure2<Edge, ID> _function_5 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setColorschemeRaw(e, value);
            }
        };
        setter.apply((Object)"colorscheme", (Object)_function_5);
        Procedures.Procedure2<Edge, ID> _function_6 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setDirRaw(e, value);
            }
        };
        setter.apply((Object)"dir", (Object)_function_6);
        Procedures.Procedure2<Edge, ID> _function_7 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setFillcolorRaw(e, value);
            }
        };
        setter.apply((Object)"fillcolor", (Object)_function_7);
        Procedures.Procedure2<Edge, ID> _function_8 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setFontcolorRaw(e, value);
            }
        };
        setter.apply((Object)"fontcolor", (Object)_function_8);
        Procedures.Procedure2<Edge, ID> _function_9 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setHeadLpRaw(e, value);
            }
        };
        setter.apply((Object)"head_lp", (Object)_function_9);
        Procedures.Procedure2<Edge, ID> _function_10 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setHeadlabelRaw(e, value);
            }
        };
        setter.apply((Object)"headlabel", (Object)_function_10);
        Procedures.Procedure2<Edge, ID> _function_11 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setIdRaw(e, value);
            }
        };
        setter.apply((Object)"id", (Object)_function_11);
        Procedures.Procedure2<Edge, ID> _function_12 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setLabelRaw(e, value);
            }
        };
        setter.apply((Object)"label", (Object)_function_12);
        Procedures.Procedure2<Edge, ID> _function_13 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setLabelfontcolorRaw(e, value);
            }
        };
        setter.apply((Object)"labelfontcolor", (Object)_function_13);
        Procedures.Procedure2<Edge, ID> _function_14 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setLpRaw(e, value);
            }
        };
        setter.apply((Object)"lp", (Object)_function_14);
        Procedures.Procedure2<Edge, ID> _function_15 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setPosRaw(e, value);
            }
        };
        setter.apply((Object)"pos", (Object)_function_15);
        Procedures.Procedure2<Edge, ID> _function_16 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setStyleRaw(e, value);
            }
        };
        setter.apply((Object)"style", (Object)_function_16);
        Procedures.Procedure2<Edge, ID> _function_17 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setTaillabelRaw(e, value);
            }
        };
        setter.apply((Object)"taillabel", (Object)_function_17);
        Procedures.Procedure2<Edge, ID> _function_18 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setTailLpRaw(e, value);
            }
        };
        setter.apply((Object)"tail_lp", (Object)_function_18);
        Procedures.Procedure2<Edge, ID> _function_19 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setXlabelRaw(e, value);
            }
        };
        setter.apply((Object)"xlabel", (Object)_function_19);
        Procedures.Procedure2<Edge, ID> _function_20 = new Procedures.Procedure2<Edge, ID>(){

            public void apply(Edge e, ID value) {
                DotAttributes.setXlpRaw(e, value);
            }
        };
        setter.apply((Object)"xlp", (Object)_function_20);
        _xblockexpression = edge;
        return _xblockexpression;
    }

    private void transformStmt(Stmt it, Graph.Builder graphBuilder) {
        if (it instanceof Subgraph) {
            this._transformStmt((Subgraph)it, graphBuilder);
            return;
        }
        if (it instanceof AttrStmt) {
            this._transformStmt((AttrStmt)it, graphBuilder);
            return;
        }
        if (it instanceof EdgeStmtNode) {
            this._transformStmt((EdgeStmtNode)it, graphBuilder);
            return;
        }
        if (it instanceof NodeStmt) {
            this._transformStmt((NodeStmt)it, graphBuilder);
            return;
        }
        if (it != null) {
            this._transformStmt(it, graphBuilder);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, graphBuilder).toString());
    }
}

