/*
* generated by Xtext
*/
package org.eclipse.gef.dot.internal.language.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;


@Singleton
public class DotColorGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class ColorElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Color");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cRGBColorParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cHSVColorParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cStringColorParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		/// * 
		// * This grammar comes with a custom lexer to disable the COLOR_NUMBER and the COLOR_STRING terminal rules 
		// * within the context of an RGBColor definition (when the color is defined starting with a '#' symbol)  
		// * to be able to parse the hex values (such as '#000000' and '#ffffff') properly.
		// * / Color:
		//	RGBColor | HSVColor | StringColor;
		public ParserRule getRule() { return rule; }

		//RGBColor | HSVColor | StringColor
		public Alternatives getAlternatives() { return cAlternatives; }

		//RGBColor
		public RuleCall getRGBColorParserRuleCall_0() { return cRGBColorParserRuleCall_0; }

		//HSVColor
		public RuleCall getHSVColorParserRuleCall_1() { return cHSVColorParserRuleCall_1; }

		//StringColor
		public RuleCall getStringColorParserRuleCall_2() { return cStringColorParserRuleCall_2; }
	}

	public class RGBColorElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "RGBColor");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cNumberSignKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cRAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cRHexParserRuleCall_1_0 = (RuleCall)cRAssignment_1.eContents().get(0);
		private final Assignment cGAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cGHexParserRuleCall_2_0 = (RuleCall)cGAssignment_2.eContents().get(0);
		private final Assignment cBAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBHexParserRuleCall_3_0 = (RuleCall)cBAssignment_3.eContents().get(0);
		private final Assignment cAAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cAHexParserRuleCall_4_0 = (RuleCall)cAAssignment_4.eContents().get(0);
		
		//RGBColor:
		//	"#" r=hex g=hex b=hex a=hex?;
		public ParserRule getRule() { return rule; }

		//"#" r=hex g=hex b=hex a=hex?
		public Group getGroup() { return cGroup; }

		//"#"
		public Keyword getNumberSignKeyword_0() { return cNumberSignKeyword_0; }

		//r=hex
		public Assignment getRAssignment_1() { return cRAssignment_1; }

		//hex
		public RuleCall getRHexParserRuleCall_1_0() { return cRHexParserRuleCall_1_0; }

		//g=hex
		public Assignment getGAssignment_2() { return cGAssignment_2; }

		//hex
		public RuleCall getGHexParserRuleCall_2_0() { return cGHexParserRuleCall_2_0; }

		//b=hex
		public Assignment getBAssignment_3() { return cBAssignment_3; }

		//hex
		public RuleCall getBHexParserRuleCall_3_0() { return cBHexParserRuleCall_3_0; }

		//a=hex?
		public Assignment getAAssignment_4() { return cAAssignment_4; }

		//hex
		public RuleCall getAHexParserRuleCall_4_0() { return cAHexParserRuleCall_4_0; }
	}

	public class HSVColorElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "HSVColor");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cHAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cHCOLOR_NUMBERTerminalRuleCall_0_0 = (RuleCall)cHAssignment_0.eContents().get(0);
		private final Keyword cCommaKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cSAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cSCOLOR_NUMBERTerminalRuleCall_2_0 = (RuleCall)cSAssignment_2.eContents().get(0);
		private final Keyword cCommaKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cVAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cVCOLOR_NUMBERTerminalRuleCall_4_0 = (RuleCall)cVAssignment_4.eContents().get(0);
		
		//HSVColor:
		//	h=COLOR_NUMBER ","? s=COLOR_NUMBER ","? v=COLOR_NUMBER;
		public ParserRule getRule() { return rule; }

		//h=COLOR_NUMBER ","? s=COLOR_NUMBER ","? v=COLOR_NUMBER
		public Group getGroup() { return cGroup; }

		//h=COLOR_NUMBER
		public Assignment getHAssignment_0() { return cHAssignment_0; }

		//COLOR_NUMBER
		public RuleCall getHCOLOR_NUMBERTerminalRuleCall_0_0() { return cHCOLOR_NUMBERTerminalRuleCall_0_0; }

		//","?
		public Keyword getCommaKeyword_1() { return cCommaKeyword_1; }

		//s=COLOR_NUMBER
		public Assignment getSAssignment_2() { return cSAssignment_2; }

		//COLOR_NUMBER
		public RuleCall getSCOLOR_NUMBERTerminalRuleCall_2_0() { return cSCOLOR_NUMBERTerminalRuleCall_2_0; }

		//","?
		public Keyword getCommaKeyword_3() { return cCommaKeyword_3; }

		//v=COLOR_NUMBER
		public Assignment getVAssignment_4() { return cVAssignment_4; }

		//COLOR_NUMBER
		public RuleCall getVCOLOR_NUMBERTerminalRuleCall_4_0() { return cVCOLOR_NUMBERTerminalRuleCall_4_0; }
	}

	public class StringColorElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "StringColor");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cGroup.eContents().get(0);
		private final Keyword cSolidusKeyword_0_0 = (Keyword)cGroup_0.eContents().get(0);
		private final Assignment cSchemeAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cSchemeCOLOR_STRINGTerminalRuleCall_0_1_0 = (RuleCall)cSchemeAssignment_0_1.eContents().get(0);
		private final Keyword cSolidusKeyword_0_2 = (Keyword)cGroup_0.eContents().get(2);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Alternatives cNameAlternatives_1_0 = (Alternatives)cNameAssignment_1.eContents().get(0);
		private final RuleCall cNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0 = (RuleCall)cNameAlternatives_1_0.eContents().get(0);
		private final RuleCall cNameCOLOR_STRINGTerminalRuleCall_1_0_1 = (RuleCall)cNameAlternatives_1_0.eContents().get(1);
		private final RuleCall cNameCOLOR_NUMBERTerminalRuleCall_1_0_2 = (RuleCall)cNameAlternatives_1_0.eContents().get(2);
		
		//StringColor:
		//	("/" scheme=COLOR_STRING? "/")? name=(HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER);
		public ParserRule getRule() { return rule; }

		//("/" scheme=COLOR_STRING? "/")? name=(HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER)
		public Group getGroup() { return cGroup; }

		//("/" scheme=COLOR_STRING? "/")?
		public Group getGroup_0() { return cGroup_0; }

		//"/"
		public Keyword getSolidusKeyword_0_0() { return cSolidusKeyword_0_0; }

		//scheme=COLOR_STRING?
		public Assignment getSchemeAssignment_0_1() { return cSchemeAssignment_0_1; }

		//COLOR_STRING
		public RuleCall getSchemeCOLOR_STRINGTerminalRuleCall_0_1_0() { return cSchemeCOLOR_STRINGTerminalRuleCall_0_1_0; }

		//"/"
		public Keyword getSolidusKeyword_0_2() { return cSolidusKeyword_0_2; }

		//name=(HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER)
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER
		public Alternatives getNameAlternatives_1_0() { return cNameAlternatives_1_0; }

		//HEXADECIMAL_DIGIT
		public RuleCall getNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0() { return cNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0; }

		//COLOR_STRING
		public RuleCall getNameCOLOR_STRINGTerminalRuleCall_1_0_1() { return cNameCOLOR_STRINGTerminalRuleCall_1_0_1; }

		//COLOR_NUMBER
		public RuleCall getNameCOLOR_NUMBERTerminalRuleCall_1_0_2() { return cNameCOLOR_NUMBERTerminalRuleCall_1_0_2; }
	}

	public class HexElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "hex");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cHEXADECIMAL_DIGITTerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final RuleCall cHEXADECIMAL_DIGITTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//hex:
		//	HEXADECIMAL_DIGIT HEXADECIMAL_DIGIT;
		public ParserRule getRule() { return rule; }

		//HEXADECIMAL_DIGIT HEXADECIMAL_DIGIT
		public Group getGroup() { return cGroup; }

		//HEXADECIMAL_DIGIT
		public RuleCall getHEXADECIMAL_DIGITTerminalRuleCall_0() { return cHEXADECIMAL_DIGITTerminalRuleCall_0; }

		//HEXADECIMAL_DIGIT
		public RuleCall getHEXADECIMAL_DIGITTerminalRuleCall_1() { return cHEXADECIMAL_DIGITTerminalRuleCall_1; }
	}
	
	
	private final ColorElements pColor;
	private final RGBColorElements pRGBColor;
	private final HSVColorElements pHSVColor;
	private final StringColorElements pStringColor;
	private final HexElements pHex;
	private final TerminalRule tCOLOR_NUMBER;
	private final TerminalRule tHEXADECIMAL_DIGIT;
	private final TerminalRule tCOLOR_STRING;
	private final TerminalRule tZERO_OR_ONE;
	private final TerminalRule tDIGITS;
	private final TerminalRule tWS;
	
	private final Grammar grammar;

	@Inject
	public DotColorGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.pColor = new ColorElements();
		this.pRGBColor = new RGBColorElements();
		this.pHSVColor = new HSVColorElements();
		this.pStringColor = new StringColorElements();
		this.pHex = new HexElements();
		this.tCOLOR_NUMBER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "COLOR_NUMBER");
		this.tHEXADECIMAL_DIGIT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "HEXADECIMAL_DIGIT");
		this.tCOLOR_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "COLOR_STRING");
		this.tZERO_OR_ONE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ZERO_OR_ONE");
		this.tDIGITS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "DIGITS");
		this.tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "WS");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.gef.dot.internal.language.DotColor".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	/// * 
	// * This grammar comes with a custom lexer to disable the COLOR_NUMBER and the COLOR_STRING terminal rules 
	// * within the context of an RGBColor definition (when the color is defined starting with a '#' symbol)  
	// * to be able to parse the hex values (such as '#000000' and '#ffffff') properly.
	// * / Color:
	//	RGBColor | HSVColor | StringColor;
	public ColorElements getColorAccess() {
		return pColor;
	}
	
	public ParserRule getColorRule() {
		return getColorAccess().getRule();
	}

	//RGBColor:
	//	"#" r=hex g=hex b=hex a=hex?;
	public RGBColorElements getRGBColorAccess() {
		return pRGBColor;
	}
	
	public ParserRule getRGBColorRule() {
		return getRGBColorAccess().getRule();
	}

	//HSVColor:
	//	h=COLOR_NUMBER ","? s=COLOR_NUMBER ","? v=COLOR_NUMBER;
	public HSVColorElements getHSVColorAccess() {
		return pHSVColor;
	}
	
	public ParserRule getHSVColorRule() {
		return getHSVColorAccess().getRule();
	}

	//StringColor:
	//	("/" scheme=COLOR_STRING? "/")? name=(HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER);
	public StringColorElements getStringColorAccess() {
		return pStringColor;
	}
	
	public ParserRule getStringColorRule() {
		return getStringColorAccess().getRule();
	}

	//hex:
	//	HEXADECIMAL_DIGIT HEXADECIMAL_DIGIT;
	public HexElements getHexAccess() {
		return pHex;
	}
	
	public ParserRule getHexRule() {
		return getHexAccess().getRule();
	}

	//terminal COLOR_NUMBER:
	//	"." DIGITS+ | ZERO_OR_ONE ("." DIGITS+)?;
	public TerminalRule getCOLOR_NUMBERRule() {
		return tCOLOR_NUMBER;
	} 

	//terminal HEXADECIMAL_DIGIT:
	//	DIGITS | "a".."f" | "A".."F";
	public TerminalRule getHEXADECIMAL_DIGITRule() {
		return tHEXADECIMAL_DIGIT;
	} 

	//terminal COLOR_STRING:
	//	("a".."z" | "A".."Z" | DIGITS)+;
	public TerminalRule getCOLOR_STRINGRule() {
		return tCOLOR_STRING;
	} 

	//terminal fragment ZERO_OR_ONE:
	//	"0" | "1";
	public TerminalRule getZERO_OR_ONERule() {
		return tZERO_OR_ONE;
	} 

	//terminal fragment DIGITS:
	//	ZERO_OR_ONE | "2".."9";
	public TerminalRule getDIGITSRule() {
		return tDIGITS;
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return tWS;
	} 
}
