/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model;

import org.eclipse.gef.examples.shapes.model.ModelElement;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class Connection
extends ModelElement {
    public static final Integer SOLID_CONNECTION = 1;
    public static final Integer DASHED_CONNECTION = 2;
    public static final String LINESTYLE_PROP = "LineStyle";
    private static final IPropertyDescriptor[] descriptors = new IPropertyDescriptor[1];
    private static final String SOLID_STR = "Solid";
    private static final String DASHED_STR = "Dashed";
    private static final long serialVersionUID = 1L;
    private boolean isConnected;
    private int lineStyle = 1;
    private Shape source;
    private Shape target;

    static {
        Connection.descriptors[0] = new ComboBoxPropertyDescriptor((Object)LINESTYLE_PROP, LINESTYLE_PROP, new String[]{SOLID_STR, DASHED_STR});
    }

    public Connection(Shape source, Shape target) {
        this.reconnect(source, target);
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(LINESTYLE_PROP)) {
            if (this.getLineStyle() == 2) {
                return 1;
            }
            return 0;
        }
        return super.getPropertyValue(id);
    }

    public Shape getSource() {
        return this.source;
    }

    public Shape getTarget() {
        return this.target;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(Shape newSource, Shape newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    public void setLineStyle(int lineStyle) {
        if (lineStyle != 2 && lineStyle != 1) {
            throw new IllegalArgumentException();
        }
        this.lineStyle = lineStyle;
        this.firePropertyChange(LINESTYLE_PROP, null, this.lineStyle);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(LINESTYLE_PROP)) {
            this.setLineStyle(Integer.valueOf(1).equals(value) ? 2 : 1);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

