/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetEvent;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.DidChangeBuildTarget;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.PublishDiagnosticsParams;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskProgressParams;
import ch.epfl.scala.bsp4j.TaskStartParams;
import ch.epfl.scala.bsp4j.extended.TestFinishEx;
import ch.epfl.scala.bsp4j.extended.TestName;
import ch.epfl.scala.bsp4j.extended.TestStartEx;
import com.microsoft.gradle.bs.importer.GradleBuildServerBuildSupport;
import com.microsoft.gradle.bs.importer.Utils;
import com.microsoft.gradle.bs.importer.model.JavaTestStatus;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class GradleBuildClient
implements BuildClient {
    private static final String BUILD_SERVER_TASK = "Build Server Task";
    private static final String CLIENT_APPEND_BUILD_LOG_CMD = "_java.gradle.buildServer.appendBuildLog";
    private static final String CLIENT_BUILD_LOG_CMD = "_java.gradle.buildServer.log";
    private final JavaClientConnection.JavaLanguageClient lsClient;
    private final LruCache<String> failedTaskCache = new LruCache(16);

    public GradleBuildClient() {
        this.lsClient = JavaLanguageServerPlugin.getProjectsManager().getConnection();
    }

    public void onBuildLogMessage(LogMessageParams params) {
        ch.epfl.scala.bsp4j.MessageType type = params.getType();
        if (type == ch.epfl.scala.bsp4j.MessageType.LOG) {
            Utils.sendTelemetry(this.lsClient, params.getMessage());
        } else {
            String command = CLIENT_BUILD_LOG_CMD;
            if (type == ch.epfl.scala.bsp4j.MessageType.ERROR && this.failedTaskCache.contains(params.getTask().getId())) {
                command = CLIENT_APPEND_BUILD_LOG_CMD;
            }
            this.lsClient.sendNotification(new ExecuteCommandParams(command, Arrays.asList(params.getMessage())));
        }
    }

    public void onBuildPublishDiagnostics(PublishDiagnosticsParams arg0) {
        throw new UnsupportedOperationException("Unimplemented method 'onBuildPublishDiagnostics'");
    }

    public void onBuildShowMessage(ShowMessageParams params) {
        MessageType type = switch (params.getType()) {
            case ch.epfl.scala.bsp4j.MessageType.ERROR -> MessageType.Error;
            case ch.epfl.scala.bsp4j.MessageType.WARNING -> MessageType.Warning;
            case ch.epfl.scala.bsp4j.MessageType.INFORMATION -> MessageType.Info;
            case ch.epfl.scala.bsp4j.MessageType.LOG -> MessageType.Log;
            default -> throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(params.getType()));
        };
        MessageParams messageParams = new MessageParams(type, params.getMessage());
        this.lsClient.showMessage(messageParams);
    }

    public void onBuildTargetDidChange(DidChangeBuildTarget params) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (BuildTargetEvent event : params.getChanges()) {
            BuildTargetIdentifier id = event.getTarget();
            URI uri = Utils.getUriWithoutQuery(id.getUri());
            IProject project = ProjectUtils.getProjectFromUri((String)uri.toString());
            if (project == null) continue;
            projects.add(project);
        }
        if (projects.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            GradleBuildServerBuildSupport buildSupport = new GradleBuildServerBuildSupport();
            for (IProject project : projects) {
                try {
                    buildSupport.update(project, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.log((CoreException)e);
                }
            }
        });
    }

    public void onBuildTaskStart(TaskStartParams params) {
        if (Objects.equals(params.getDataKind(), "compile-task")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            String msg = "> Build starts at " + dateFormat.format(now) + "\n" + params.getMessage();
            this.lsClient.sendNotification(new ExecuteCommandParams(CLIENT_APPEND_BUILD_LOG_CMD, Arrays.asList(msg)));
        } else if (Objects.equals(params.getDataKind(), "test-start")) {
            TestStartEx testStartEx = (TestStartEx)((Object)JSONUtility.toModel((Object)params.getData(), TestStartEx.class));
            String displayName = testStartEx.getTestName().getDisplayName();
            if (displayName.matches("(?i)test suite '.+'") || displayName.matches("(?i)test\\s+\\w+\\(.*\\)\\(\\w+(\\.\\w+)*\\)")) {
                displayName = null;
            }
            List<String> testParts = this.getTestParts(testStartEx.getTestName());
            this.lsClient.sendNotification(new ExecuteCommandParams("java.gradle.buildServer.onDidChangeTestItemStatus", Arrays.asList(testParts, 2, displayName)));
        } else {
            Either id = Either.forLeft((Object)params.getTaskId().getId());
            this.lsClient.createProgress(new WorkDoneProgressCreateParams(id));
            WorkDoneProgressBegin workDoneProgressBegin = new WorkDoneProgressBegin();
            workDoneProgressBegin.setTitle(BUILD_SERVER_TASK);
            workDoneProgressBegin.setMessage(params.getMessage());
            this.lsClient.notifyProgress(new ProgressParams(id, Either.forLeft((Object)workDoneProgressBegin)));
        }
    }

    public void onBuildTaskProgress(TaskProgressParams params) {
        if (Objects.equals(params.getDataKind(), "compile-task")) {
            this.lsClient.sendNotification(new ExecuteCommandParams(CLIENT_APPEND_BUILD_LOG_CMD, Arrays.asList(params.getMessage())));
        } else {
            Either id = Either.forLeft((Object)params.getTaskId().getId());
            WorkDoneProgressReport workDoneProgressReport = new WorkDoneProgressReport();
            workDoneProgressReport.setMessage((String)(StringUtils.isBlank((CharSequence)params.getMessage()) ? BUILD_SERVER_TASK : "Build Server Task - " + params.getMessage()));
            this.lsClient.notifyProgress(new ProgressParams(id, Either.forLeft((Object)workDoneProgressReport)));
        }
    }

    public void onBuildTaskFinish(TaskFinishParams params) {
        if (Objects.equals(params.getDataKind(), "compile-report")) {
            String msg = params.getMessage() + "\n------\n";
            this.lsClient.sendNotification(new ExecuteCommandParams(CLIENT_APPEND_BUILD_LOG_CMD, Arrays.asList(msg)));
            if (params.getStatus() == StatusCode.ERROR) {
                this.failedTaskCache.addAll(params.getTaskId().getParents());
            }
        } else if (Objects.equals(params.getDataKind(), "test-finish")) {
            JavaTestStatus testStatus;
            TestFinishEx testFinishEx = (TestFinishEx)((Object)JSONUtility.toModel((Object)params.getData(), TestFinishEx.class));
            List<String> testParts = this.getTestParts(testFinishEx.getTestName());
            switch (testFinishEx.getStatus()) {
                case PASSED: {
                    JavaTestStatus javaTestStatus = JavaTestStatus.Passed;
                    break;
                }
                case FAILED: {
                    JavaTestStatus javaTestStatus = JavaTestStatus.Failed;
                    break;
                }
                case IGNORED: 
                case CANCELLED: 
                case SKIPPED: {
                    JavaTestStatus javaTestStatus = JavaTestStatus.Skipped;
                    break;
                }
                default: {
                    JavaTestStatus javaTestStatus = testStatus = null;
                }
            }
            if (testStatus == null) {
                throw new IllegalArgumentException("Unsupported test status: " + String.valueOf(testFinishEx.getStatus()));
            }
            this.lsClient.sendNotification(new ExecuteCommandParams("java.gradle.buildServer.onDidChangeTestItemStatus", Arrays.asList(testParts, testStatus.getValue(), null, testFinishEx.getStackTrace())));
        } else if (Objects.equals(params.getDataKind(), "test-report")) {
            this.lsClient.sendNotification(new ExecuteCommandParams("java.gradle.buildServer.onDidFinishTestRun", Arrays.asList(params.getStatus().getValue(), params.getMessage())));
        } else {
            Either id = Either.forLeft((Object)params.getTaskId().getId());
            WorkDoneProgressEnd workDoneProgressEnd = new WorkDoneProgressEnd();
            workDoneProgressEnd.setMessage((String)(StringUtils.isBlank((CharSequence)params.getMessage()) ? BUILD_SERVER_TASK : "Build Server Task - " + params.getMessage()));
            this.lsClient.notifyProgress(new ProgressParams(id, Either.forLeft((Object)workDoneProgressEnd)));
        }
    }

    private List<String> getTestParts(TestName testName) {
        LinkedList<String> testNames = new LinkedList<String>();
        while (testName != null) {
            if (testName.getSuiteName() != null) {
                testNames.add(testName.getSuiteName());
            } else if (testName.getMethodName() != null) {
                testNames.add(testName.getMethodName());
            } else if (testName.getClassName() != null) {
                testNames.add(testName.getClassName());
            }
            testName = testName.getParent();
        }
        Collections.reverse(testNames);
        int i = 0;
        while (i < testNames.size() - 1) {
            String cur = (String)testNames.get(i);
            String next = (String)testNames.get(i + 1);
            if (!next.startsWith(cur + "$")) break;
            ++i;
        }
        return testNames.subList(i, testNames.size());
    }

    private class LruCache<T>
    extends LinkedHashSet<T> {
        private final int maxSize;

        public LruCache(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(T element) {
            if (this.size() >= this.maxSize) {
                Object oldestElement = this.iterator().next();
                this.remove(oldestElement);
            }
            return super.add(element);
        }
    }
}

