/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantComparisonStatementCleanUp
extends AbstractMultiFix
implements ICleanUpFix {
    public RedundantComparisonStatementCleanUp() {
        this(Collections.emptyMap());
    }

    public RedundantComparisonStatementCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.comparison_statement");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.comparison_statement")) {
            return new String[]{MultiFixMessages.RedundantComparisonStatementCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.comparison_statement")) {
            return "return i;\n\n\n\n\n";
        }
        return "if (i != 123) {\n return i;\n} else {\n return 123;\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.comparison_statement")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                IfAndReturnVisitor ifAndReturnVisitor = new IfAndReturnVisitor(node, rewriteOperations);
                node.accept((ASTVisitor)ifAndReturnVisitor);
                return ifAndReturnVisitor.result;
            }

            final class IfAndReturnVisitor
            extends ASTVisitor {
                private final Block startNode;
                private boolean result = true;
                private final /* synthetic */ List val$rewriteOperations;

                public IfAndReturnVisitor(Block startNode, List list) {
                    this.val$rewriteOperations = list;
                    this.startNode = startNode;
                }

                public boolean visit(Block node) {
                    return this.startNode == node;
                }

                public boolean visit(IfStatement node) {
                    InfixExpression condition = ASTNodes.as(node.getExpression(), InfixExpression.class);
                    Statement thenStatement = this.getThenStatement(node);
                    Statement elseStatement = this.getElseStatement(node, thenStatement);
                    if (this.result && thenStatement != null && elseStatement != null && condition != null && !condition.hasExtendedOperands() && ASTNodes.hasOperator(condition, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS)) {
                        boolean isEqual = ASTNodes.hasOperator(condition, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0]);
                        Assignment thenAssignment = ASTNodes.asExpression(thenStatement, Assignment.class);
                        Assignment elseAssignment = ASTNodes.asExpression(elseStatement, Assignment.class);
                        if (ASTNodes.hasOperator(thenAssignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && ASTNodes.hasOperator(elseAssignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && ASTNodes.match((ASTNode)thenAssignment.getLeftHandSide(), (ASTNode)elseAssignment.getLeftHandSide())) {
                            if (isEqual) {
                                return this.maybeReplace(node, condition, thenAssignment.getRightHandSide(), elseAssignment.getRightHandSide(), elseStatement, null);
                            }
                            return this.maybeReplace(node, condition, elseAssignment.getRightHandSide(), thenAssignment.getRightHandSide(), thenStatement, null);
                        }
                        ReturnStatement thenReturnStatement = ASTNodes.as(thenStatement, ReturnStatement.class);
                        ReturnStatement elseReturnStatement = ASTNodes.as(elseStatement, ReturnStatement.class);
                        if (thenReturnStatement != null && elseReturnStatement != null) {
                            if (isEqual) {
                                return this.maybeReplace(node, condition, thenReturnStatement.getExpression(), elseReturnStatement.getExpression(), (Statement)elseReturnStatement, thenReturnStatement);
                            }
                            return this.maybeReplace(node, condition, elseReturnStatement.getExpression(), thenReturnStatement.getExpression(), (Statement)thenReturnStatement, elseReturnStatement);
                        }
                    }
                    return true;
                }

                private Statement getThenStatement(IfStatement node) {
                    List<Statement> thenStatements = ASTNodes.asList(node.getThenStatement());
                    if (thenStatements.size() == 1) {
                        return thenStatements.get(0);
                    }
                    return null;
                }

                private Statement getElseStatement(IfStatement node, Statement thenStatement) {
                    List<Statement> elseStatements = ASTNodes.asList(node.getElseStatement());
                    if (elseStatements.size() == 1) {
                        return elseStatements.get(0);
                    }
                    if (ASTNodes.is(thenStatement, ReturnStatement.class)) {
                        return ASTNodes.getNextSibling((Statement)node);
                    }
                    return null;
                }

                private boolean maybeReplace(IfStatement node, InfixExpression condition, Expression hardCodedExpression, Expression valuedExpression, Statement statementToMove, ReturnStatement returnToRemove) {
                    if (ASTNodes.isHardCoded(hardCodedExpression) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)hardCodedExpression) && ASTNodes.isPassive((ASTNode)valuedExpression) && (ASTNodes.match((ASTNode)condition.getRightOperand(), (ASTNode)hardCodedExpression) && ASTNodes.match((ASTNode)condition.getLeftOperand(), (ASTNode)valuedExpression) || ASTNodes.match((ASTNode)condition.getRightOperand(), (ASTNode)valuedExpression) && ASTNodes.match((ASTNode)condition.getLeftOperand(), (ASTNode)hardCodedExpression))) {
                        this.val$rewriteOperations.add(new RedundantComparisonStatementOperation(node, statementToMove, returnToRemove));
                        this.result = false;
                        return false;
                    }
                    return true;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.RedundantComparisonStatementCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RedundantComparisonStatementOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement node;
        private final Statement toMove;
        private final ReturnStatement toRemove;

        public RedundantComparisonStatementOperation(IfStatement node, Statement toMove, ReturnStatement toRemove) {
            this.node = node;
            this.toMove = toMove;
            this.toRemove = toRemove;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantComparisonStatementCleanup_description, cuRewrite);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.node, (ASTNode)ASTNodes.createMoveTarget(rewrite, this.toMove), group);
            if (this.toRemove != null) {
                rewrite.remove((ASTNode)this.toRemove, group);
            }
        }
    }
}

