/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle;

import com.github.badsyntax.gradle.GradleService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleServer {
    private static final Logger logger = LoggerFactory.getLogger((String)GradleServer.class.getName());
    private final int port;
    private final Server server;

    public GradleServer(int port) {
        this(ServerBuilder.forPort((int)port), port);
    }

    public GradleServer(ServerBuilder<?> serverBuilder, int port) {
        this.port = port;
        this.server = serverBuilder.addService((BindableService)new GradleService()).build();
    }

    public void start() throws IOException {
        this.server.start();
        logger.info("Server started, listening on {}", (Object)this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Shutting down gRPC server since JVM is shutting down");
                try {
                    GradleServer.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                    Thread.currentThread().interrupt();
                }
                logger.info("Server shut down");
            }
        });
    }

    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8887;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        GradleServer server = new GradleServer(port);
        server.start();
        server.blockUntilShutdown();
    }
}

