/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketTimeoutException;
import java.net.SocksConsts;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import sun.net.SocksProxy;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

class SocksSocketImpl
extends PlainSocketImpl
implements SocksConsts {
    private String server = null;
    private int serverPort = 1080;
    private InetSocketAddress external_address;
    private boolean useV4 = false;
    private Socket cmdsock = null;
    private InputStream cmdIn = null;
    private OutputStream cmdOut = null;
    private boolean applicationSetProxy;

    SocksSocketImpl() {
    }

    SocksSocketImpl(String string, int n) {
        this.server = string;
        this.serverPort = n == -1 ? 1080 : n;
    }

    SocksSocketImpl(Proxy proxy) {
        SocketAddress socketAddress = proxy.address();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            this.server = inetSocketAddress.getHostString();
            this.serverPort = inetSocketAddress.getPort();
        }
    }

    void setV4() {
        this.useV4 = true;
    }

    private synchronized void privilegedConnect(final String string, final int n, final int n2) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    SocksSocketImpl.this.superConnectServer(string, n, n2);
                    SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.getInputStream();
                    SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.getOutputStream();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superConnectServer(String string, int n, int n2) throws IOException {
        super.connect(new InetSocketAddress(string, n), n2);
    }

    private static int remainingMillis(long l) throws IOException {
        if (l == 0L) {
            return 0;
        }
        long l2 = l - System.currentTimeMillis();
        if (l2 > 0L) {
            return (int)l2;
        }
        throw new SocketTimeoutException();
    }

    private int readSocksReply(InputStream inputStream, byte[] byArray) throws IOException {
        return this.readSocksReply(inputStream, byArray, 0L);
    }

    private int readSocksReply(InputStream inputStream, byte[] byArray, long l) throws IOException {
        int n;
        int n2;
        int n3 = byArray.length;
        for (n = 0; n < n3; n += n2) {
            try {
                n2 = ((SocketInputStream)inputStream).read(byArray, n, n3 - n, SocksSocketImpl.remainingMillis(l));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new SocketTimeoutException("Connect timed out");
            }
            if (n2 >= 0) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return n;
    }

    private boolean authenticate(byte by, InputStream inputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        return this.authenticate(by, inputStream, bufferedOutputStream, 0L);
    }

    private boolean authenticate(byte by, InputStream inputStream, BufferedOutputStream bufferedOutputStream, long l) throws IOException {
        if (by == 0) {
            return true;
        }
        if (by == 2) {
            String string;
            block13: {
                String string2;
                string = null;
                final InetAddress inetAddress = InetAddress.getByName(this.server);
                PasswordAuthentication passwordAuthentication = AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

                    @Override
                    public PasswordAuthentication run() {
                        return Authenticator.requestPasswordAuthentication(SocksSocketImpl.this.server, inetAddress, SocksSocketImpl.this.serverPort, "SOCKS5", "SOCKS authentication", null);
                    }
                });
                if (passwordAuthentication != null) {
                    string2 = passwordAuthentication.getUserName();
                    string = new String(passwordAuthentication.getPassword());
                } else {
                    string2 = AccessController.doPrivileged(new GetPropertyAction("user.name"));
                }
                if (string2 == null) {
                    return false;
                }
                bufferedOutputStream.write(1);
                bufferedOutputStream.write(string2.length());
                try {
                    bufferedOutputStream.write(string2.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            if (string != null) {
                bufferedOutputStream.write(string.length());
                try {
                    bufferedOutputStream.write(string.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    assert (false);
                }
            } else {
                bufferedOutputStream.write(0);
            }
            bufferedOutputStream.flush();
            byte[] byArray = new byte[2];
            int n = this.readSocksReply(inputStream, byArray, l);
            if (n != 2 || byArray[1] != 0) {
                bufferedOutputStream.close();
                inputStream.close();
                return false;
            }
            return true;
        }
        return false;
    }

    private void connectV4(InputStream inputStream, OutputStream outputStream, InetSocketAddress inetSocketAddress, long l) throws IOException {
        block12: {
            if (!(inetSocketAddress.getAddress() instanceof Inet4Address)) {
                throw new SocketException("SOCKS V4 requires IPv4 only addresses");
            }
            outputStream.write(4);
            outputStream.write(1);
            outputStream.write(inetSocketAddress.getPort() >> 8 & 0xFF);
            outputStream.write(inetSocketAddress.getPort() >> 0 & 0xFF);
            outputStream.write(inetSocketAddress.getAddress().getAddress());
            String string = this.getUserName();
            try {
                outputStream.write(string.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
        outputStream.write(0);
        outputStream.flush();
        byte[] byArray = new byte[8];
        int n = this.readSocksReply(inputStream, byArray, l);
        if (n != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (byArray[0] != 0 && byArray[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException socketException = null;
        switch (byArray[1]) {
            case 90: {
                this.external_address = inetSocketAddress;
                break;
            }
            case 91: {
                socketException = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                socketException = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                socketException = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                socketException = new SocketException("Reply from SOCKS server contains bad status");
            }
        }
        if (socketException != null) {
            inputStream.close();
            outputStream.close();
            throw socketException;
        }
    }

    @Override
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        Throwable throwable;
        Object object;
        Object object2;
        Object object3;
        long l;
        long l2 = n == 0 ? 0L : ((l = System.currentTimeMillis() + (long)n) < 0L ? Long.MAX_VALUE : l);
        SecurityManager securityManager = System.getSecurityManager();
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            } else {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
        }
        if (this.server == null) {
            object3 = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (object3 == null) {
                super.connect(inetSocketAddress, SocksSocketImpl.remainingMillis(l2));
                return;
            }
            object2 = inetSocketAddress.getHostString();
            if (inetSocketAddress.getAddress() instanceof Inet6Address && !((String)object2).startsWith("[") && ((String)object2).indexOf(":") >= 0) {
                object2 = "[" + (String)object2 + "]";
            }
            try {
                object = new URI("socket://" + ParseUtil.encodePath((String)object2) + ":" + inetSocketAddress.getPort());
            }
            catch (URISyntaxException uRISyntaxException) {
                assert (false) : uRISyntaxException;
                object = null;
            }
            Proxy proxy = null;
            throwable = null;
            Iterator<Proxy> iterator = null;
            iterator = ((ProxySelector)object3).select((URI)object).iterator();
            if (iterator == null || !iterator.hasNext()) {
                super.connect(inetSocketAddress, SocksSocketImpl.remainingMillis(l2));
                return;
            }
            while (iterator.hasNext()) {
                proxy = iterator.next();
                if (proxy == null || proxy.type() != Proxy.Type.SOCKS) {
                    super.connect(inetSocketAddress, SocksSocketImpl.remainingMillis(l2));
                    return;
                }
                if (!(proxy.address() instanceof InetSocketAddress)) {
                    throw new SocketException("Unknown address type for proxy: " + proxy);
                }
                this.server = ((InetSocketAddress)proxy.address()).getHostString();
                this.serverPort = ((InetSocketAddress)proxy.address()).getPort();
                if (proxy instanceof SocksProxy && ((SocksProxy)proxy).protocolVersion() == 4) {
                    this.useV4 = true;
                }
                try {
                    this.privilegedConnect(this.server, this.serverPort, SocksSocketImpl.remainingMillis(l2));
                    break;
                }
                catch (IOException iOException) {
                    ((ProxySelector)object3).connectFailed((URI)object, proxy.address(), iOException);
                    this.server = null;
                    this.serverPort = -1;
                    throwable = iOException;
                }
            }
            if (this.server == null) {
                throw new SocketException("Can't connect to SOCKS proxy:" + throwable.getMessage());
            }
        } else {
            try {
                this.privilegedConnect(this.server, this.serverPort, SocksSocketImpl.remainingMillis(l2));
            }
            catch (IOException iOException) {
                throw new SocketException(iOException.getMessage());
            }
        }
        object3 = new BufferedOutputStream(this.cmdOut, 512);
        object = this.cmdIn;
        if (this.useV4) {
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.toString());
            }
            this.connectV4((InputStream)object, (OutputStream)object3, inetSocketAddress, l2);
            return;
        }
        ((BufferedOutputStream)object3).write(5);
        ((BufferedOutputStream)object3).write(2);
        ((BufferedOutputStream)object3).write(0);
        ((BufferedOutputStream)object3).write(2);
        ((BufferedOutputStream)object3).flush();
        object2 = new byte[2];
        int n2 = this.readSocksReply((InputStream)object, (byte[])object2, l2);
        if (n2 != 2 || object2[0] != 5) {
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.toString());
            }
            this.connectV4((InputStream)object, (OutputStream)object3, inetSocketAddress, l2);
            return;
        }
        if (object2[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate((byte)object2[1], (InputStream)object, (BufferedOutputStream)object3, l2)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        ((BufferedOutputStream)object3).write(5);
        ((BufferedOutputStream)object3).write(1);
        ((BufferedOutputStream)object3).write(0);
        if (inetSocketAddress.isUnresolved()) {
            block55: {
                ((BufferedOutputStream)object3).write(3);
                ((BufferedOutputStream)object3).write(inetSocketAddress.getHostName().length());
                try {
                    ((FilterOutputStream)object3).write(inetSocketAddress.getHostName().getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block55;
                    throw new AssertionError();
                }
            }
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 8 & 0xFF);
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 0 & 0xFF);
        } else if (inetSocketAddress.getAddress() instanceof Inet6Address) {
            ((BufferedOutputStream)object3).write(4);
            ((FilterOutputStream)object3).write(inetSocketAddress.getAddress().getAddress());
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 8 & 0xFF);
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 0 & 0xFF);
        } else {
            ((BufferedOutputStream)object3).write(1);
            ((FilterOutputStream)object3).write(inetSocketAddress.getAddress().getAddress());
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 8 & 0xFF);
            ((BufferedOutputStream)object3).write(inetSocketAddress.getPort() >> 0 & 0xFF);
        }
        ((BufferedOutputStream)object3).flush();
        object2 = new byte[4];
        n2 = this.readSocksReply((InputStream)object, (byte[])object2, l2);
        if (n2 != 4) {
            throw new SocketException("Reply from SOCKS server has bad length");
        }
        throwable = null;
        block4 : switch (object2[1]) {
            case 0: {
                switch (object2[3]) {
                    case 1: {
                        byte[] byArray = new byte[4];
                        n2 = this.readSocksReply((InputStream)object, byArray, l2);
                        if (n2 != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object2 = new byte[2];
                        n2 = this.readSocksReply((InputStream)object, (byte[])object2, l2);
                        if (n2 == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 3: {
                        byte[] byArray = new byte[1];
                        n2 = this.readSocksReply((InputStream)object, byArray, l2);
                        if (n2 != 1) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n3 = byArray[0] & 0xFF;
                        byte[] byArray2 = new byte[n3];
                        n2 = this.readSocksReply((InputStream)object, byArray2, l2);
                        if (n2 != n3) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object2 = new byte[2];
                        n2 = this.readSocksReply((InputStream)object, (byte[])object2, l2);
                        if (n2 == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 4: {
                        int n4 = 16;
                        byte[] byArray = new byte[n4];
                        n2 = this.readSocksReply((InputStream)object, byArray, l2);
                        if (n2 != n4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object2 = new byte[2];
                        n2 = this.readSocksReply((InputStream)object, (byte[])object2, l2);
                        if (n2 == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                }
                throwable = new SocketException("Reply from SOCKS server contains wrong code");
                break;
            }
            case 1: {
                throwable = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                throwable = new SocketException("SOCKS: Connection not allowed by ruleset");
                break;
            }
            case 3: {
                throwable = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                throwable = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                throwable = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                throwable = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                throwable = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                throwable = new SocketException("SOCKS: address type not supported");
            }
        }
        if (throwable != null) {
            ((InputStream)object).close();
            ((FilterOutputStream)object3).close();
            throw throwable;
        }
        this.external_address = inetSocketAddress;
    }

    private void bindV4(InputStream inputStream, OutputStream outputStream, InetAddress inetAddress, int n) throws IOException {
        block13: {
            if (!(inetAddress instanceof Inet4Address)) {
                throw new SocketException("SOCKS V4 requires IPv4 only addresses");
            }
            super.bind(inetAddress, n);
            byte[] byArray = inetAddress.getAddress();
            InetAddress inetAddress2 = inetAddress;
            if (inetAddress2.isAnyLocalAddress()) {
                inetAddress2 = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                    @Override
                    public InetAddress run() {
                        return SocksSocketImpl.this.cmdsock.getLocalAddress();
                    }
                });
                byArray = inetAddress2.getAddress();
            }
            outputStream.write(4);
            outputStream.write(2);
            outputStream.write(super.getLocalPort() >> 8 & 0xFF);
            outputStream.write(super.getLocalPort() >> 0 & 0xFF);
            outputStream.write(byArray);
            String string = this.getUserName();
            try {
                outputStream.write(string.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        outputStream.write(0);
        outputStream.flush();
        byte[] byArray = new byte[8];
        int n2 = this.readSocksReply(inputStream, byArray);
        if (n2 != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n2);
        }
        if (byArray[0] != 0 && byArray[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException socketException = null;
        switch (byArray[1]) {
            case 90: {
                this.external_address = new InetSocketAddress(inetAddress, n);
                break;
            }
            case 91: {
                socketException = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                socketException = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                socketException = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                socketException = new SocketException("Reply from SOCKS server contains bad status");
            }
        }
        if (socketException != null) {
            inputStream.close();
            outputStream.close();
            throw socketException;
        }
    }

    protected synchronized void socksBind(InetSocketAddress inetSocketAddress) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.socket != null) {
            return;
        }
        if (this.server == null) {
            object4 = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (object4 == null) {
                return;
            }
            object3 = inetSocketAddress.getHostString();
            if (inetSocketAddress.getAddress() instanceof Inet6Address && !((String)object3).startsWith("[") && ((String)object3).indexOf(":") >= 0) {
                object3 = "[" + (String)object3 + "]";
            }
            try {
                object2 = new URI("serversocket://" + ParseUtil.encodePath((String)object3) + ":" + inetSocketAddress.getPort());
            }
            catch (URISyntaxException uRISyntaxException) {
                assert (false) : uRISyntaxException;
                object2 = null;
            }
            Proxy proxy = null;
            Throwable throwable = null;
            object = null;
            object = ((ProxySelector)object4).select((URI)object2).iterator();
            if (object == null || !object.hasNext()) {
                return;
            }
            while (object.hasNext()) {
                proxy = object.next();
                if (proxy == null || proxy.type() != Proxy.Type.SOCKS) {
                    return;
                }
                if (!(proxy.address() instanceof InetSocketAddress)) {
                    throw new SocketException("Unknown address type for proxy: " + proxy);
                }
                this.server = ((InetSocketAddress)proxy.address()).getHostString();
                this.serverPort = ((InetSocketAddress)proxy.address()).getPort();
                if (proxy instanceof SocksProxy && ((SocksProxy)proxy).protocolVersion() == 4) {
                    this.useV4 = true;
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SocksSocketImpl.this.cmdsock = new Socket(new PlainSocketImpl());
                            SocksSocketImpl.this.cmdsock.connect(new InetSocketAddress(SocksSocketImpl.this.server, SocksSocketImpl.this.serverPort));
                            SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.cmdsock.getInputStream();
                            SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.cmdsock.getOutputStream();
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    ((ProxySelector)object4).connectFailed((URI)object2, proxy.address(), new SocketException(exception.getMessage()));
                    this.server = null;
                    this.serverPort = -1;
                    this.cmdsock = null;
                    throwable = exception;
                }
            }
            if (this.server == null || this.cmdsock == null) {
                throw new SocketException("Can't connect to SOCKS proxy:" + throwable.getMessage());
            }
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SocksSocketImpl.this.cmdsock = new Socket(new PlainSocketImpl());
                        SocksSocketImpl.this.cmdsock.connect(new InetSocketAddress(SocksSocketImpl.this.server, SocksSocketImpl.this.serverPort));
                        SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.cmdsock.getInputStream();
                        SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.cmdsock.getOutputStream();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                throw new SocketException(exception.getMessage());
            }
        }
        object4 = new BufferedOutputStream(this.cmdOut, 512);
        object2 = this.cmdIn;
        if (this.useV4) {
            this.bindV4((InputStream)object2, (OutputStream)object4, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            return;
        }
        ((BufferedOutputStream)object4).write(5);
        ((BufferedOutputStream)object4).write(2);
        ((BufferedOutputStream)object4).write(0);
        ((BufferedOutputStream)object4).write(2);
        ((BufferedOutputStream)object4).flush();
        object3 = new byte[2];
        int n = this.readSocksReply((InputStream)object2, (byte[])object3);
        if (n != 2 || object3[0] != 5) {
            this.bindV4((InputStream)object2, (OutputStream)object4, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            return;
        }
        if (object3[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate((byte)object3[1], (InputStream)object2, (BufferedOutputStream)object4)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        ((BufferedOutputStream)object4).write(5);
        ((BufferedOutputStream)object4).write(2);
        ((BufferedOutputStream)object4).write(0);
        int n2 = inetSocketAddress.getPort();
        if (inetSocketAddress.isUnresolved()) {
            block53: {
                ((BufferedOutputStream)object4).write(3);
                ((BufferedOutputStream)object4).write(inetSocketAddress.getHostName().length());
                try {
                    ((FilterOutputStream)object4).write(inetSocketAddress.getHostName().getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block53;
                    throw new AssertionError();
                }
            }
            ((BufferedOutputStream)object4).write(n2 >> 8 & 0xFF);
            ((BufferedOutputStream)object4).write(n2 >> 0 & 0xFF);
        } else if (inetSocketAddress.getAddress() instanceof Inet4Address) {
            object = inetSocketAddress.getAddress().getAddress();
            ((BufferedOutputStream)object4).write(1);
            ((FilterOutputStream)object4).write((byte[])object);
            ((BufferedOutputStream)object4).write(n2 >> 8 & 0xFF);
            ((BufferedOutputStream)object4).write(n2 >> 0 & 0xFF);
            ((BufferedOutputStream)object4).flush();
        } else if (inetSocketAddress.getAddress() instanceof Inet6Address) {
            object = inetSocketAddress.getAddress().getAddress();
            ((BufferedOutputStream)object4).write(4);
            ((FilterOutputStream)object4).write((byte[])object);
            ((BufferedOutputStream)object4).write(n2 >> 8 & 0xFF);
            ((BufferedOutputStream)object4).write(n2 >> 0 & 0xFF);
            ((BufferedOutputStream)object4).flush();
        } else {
            this.cmdsock.close();
            throw new SocketException("unsupported address type : " + inetSocketAddress);
        }
        object3 = new byte[4];
        n = this.readSocksReply((InputStream)object2, (byte[])object3);
        object = null;
        switch (object3[1]) {
            case 0: {
                switch (object3[3]) {
                    case 1: {
                        byte[] byArray = new byte[4];
                        n = this.readSocksReply((InputStream)object2, byArray);
                        if (n != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object3 = new byte[2];
                        n = this.readSocksReply((InputStream)object2, (byte[])object3);
                        if (n != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n3 = (object3[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet4Address("", byArray), n3 += object3[1] & 0xFF);
                        break;
                    }
                    case 3: {
                        Object object5 = object3[1];
                        byte[] byArray = new byte[object5];
                        n = this.readSocksReply((InputStream)object2, byArray);
                        if (n != object5) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object3 = new byte[2];
                        n = this.readSocksReply((InputStream)object2, (byte[])object3);
                        if (n != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n4 = (object3[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new String(byArray), n4 += object3[1] & 0xFF);
                        break;
                    }
                    case 4: {
                        Object object6 = object3[1];
                        byte[] byArray = new byte[object6];
                        n = this.readSocksReply((InputStream)object2, byArray);
                        if (n != object6) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        object3 = new byte[2];
                        n = this.readSocksReply((InputStream)object2, (byte[])object3);
                        if (n != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n5 = (object3[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet6Address("", byArray), n5 += object3[1] & 0xFF);
                    }
                }
                break;
            }
            case 1: {
                object = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                object = new SocketException("SOCKS: Bind not allowed by ruleset");
                break;
            }
            case 3: {
                object = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                object = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                object = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                object = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                object = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                object = new SocketException("SOCKS: address type not supported");
            }
        }
        if (object != null) {
            ((InputStream)object2).close();
            ((FilterOutputStream)object4).close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw object;
        }
        this.cmdIn = object2;
        this.cmdOut = object4;
    }

    protected void acceptFrom(SocketImpl socketImpl, InetSocketAddress inetSocketAddress) throws IOException {
        if (this.cmdsock == null) {
            return;
        }
        InputStream inputStream = this.cmdIn;
        this.socksBind(inetSocketAddress);
        inputStream.read();
        int n = inputStream.read();
        inputStream.read();
        SocketException socketException = null;
        InetSocketAddress inetSocketAddress2 = null;
        switch (n) {
            case 0: {
                n = inputStream.read();
                switch (n) {
                    case 1: {
                        byte[] byArray = new byte[4];
                        this.readSocksReply(inputStream, byArray);
                        int n2 = inputStream.read() << 8;
                        inetSocketAddress2 = new InetSocketAddress(new Inet4Address("", byArray), n2 += inputStream.read());
                        break;
                    }
                    case 3: {
                        int n3 = inputStream.read();
                        byte[] byArray = new byte[n3];
                        this.readSocksReply(inputStream, byArray);
                        int n4 = inputStream.read() << 8;
                        inetSocketAddress2 = new InetSocketAddress(new String(byArray), n4 += inputStream.read());
                        break;
                    }
                    case 4: {
                        byte[] byArray = new byte[16];
                        this.readSocksReply(inputStream, byArray);
                        int n5 = inputStream.read() << 8;
                        inetSocketAddress2 = new InetSocketAddress(new Inet6Address("", byArray), n5 += inputStream.read());
                    }
                }
                break;
            }
            case 1: {
                socketException = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                socketException = new SocketException("SOCKS: Accept not allowed by ruleset");
                break;
            }
            case 3: {
                socketException = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                socketException = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                socketException = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                socketException = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                socketException = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                socketException = new SocketException("SOCKS: address type not supported");
            }
        }
        if (socketException != null) {
            this.cmdIn.close();
            this.cmdOut.close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw socketException;
        }
        if (socketImpl instanceof SocksSocketImpl) {
            ((SocksSocketImpl)socketImpl).external_address = inetSocketAddress2;
        }
        if (socketImpl instanceof PlainSocketImpl) {
            PlainSocketImpl plainSocketImpl = (PlainSocketImpl)socketImpl;
            plainSocketImpl.setInputStream((SocketInputStream)inputStream);
            plainSocketImpl.setFileDescriptor(this.cmdsock.getImpl().getFileDescriptor());
            plainSocketImpl.setAddress(this.cmdsock.getImpl().getInetAddress());
            plainSocketImpl.setPort(this.cmdsock.getImpl().getPort());
            plainSocketImpl.setLocalPort(this.cmdsock.getImpl().getLocalPort());
        } else {
            socketImpl.fd = this.cmdsock.getImpl().fd;
            socketImpl.address = this.cmdsock.getImpl().address;
            socketImpl.port = this.cmdsock.getImpl().port;
            socketImpl.localport = this.cmdsock.getImpl().localport;
        }
        this.cmdsock = null;
    }

    @Override
    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    @Override
    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    @Override
    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    @Override
    protected void close() throws IOException {
        if (this.cmdsock != null) {
            this.cmdsock.close();
        }
        this.cmdsock = null;
        super.close();
    }

    private String getUserName() {
        String string = "";
        if (this.applicationSetProxy) {
            try {
                string = System.getProperty("user.name");
            }
            catch (SecurityException securityException) {}
        } else {
            string = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        }
        return string;
    }
}

