/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaSplitPaneDividerUI;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class AquaSplitPaneUI
extends BasicSplitPaneUI
implements MouseListener,
PropertyChangeListener {
    static final String DIVIDER_PAINTER_KEY = "JSplitPane.dividerPainter";

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new AquaSplitPaneDividerUI(this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.divider.addMouseListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.divider.removeMouseListener(this);
        this.splitPane.removePropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        super.uninstallListeners();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        if (!this.splitPane.isOneTouchExpandable()) {
            return;
        }
        double d = this.splitPane.getResizeWeight();
        int n = this.splitPane.getWidth();
        int n2 = this.splitPane.getDividerSize();
        int n3 = this.splitPane.getDividerLocation();
        int n4 = this.splitPane.getLastDividerLocation();
        if (n - n2 <= n3 + 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (n2 >= n3 - 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (d > 0.5) {
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.setDividerLocation(n);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!DIVIDER_PAINTER_KEY.equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Border) {
            this.divider.setBorder((Border)object);
        } else {
            this.divider.setBorder(null);
        }
    }
}

