/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox.gc;

import jdk.test.whitebox.WhiteBox;

public enum GC {
    Serial(1),
    Parallel(2),
    G1(3),
    Epsilon(4),
    Z(5),
    Shenandoah(6);

    private static final WhiteBox WB;
    private final int name;

    private GC(int name) {
        this.name = name;
    }

    public boolean isSupported() {
        return WB.isGCSupported(this.name);
    }

    public boolean isSupportedByJVMCICompiler() {
        return WB.isGCSupportedByJVMCICompiler(this.name);
    }

    public boolean isSelected() {
        return WB.isGCSelected(this.name);
    }

    public static boolean isSelectedErgonomically() {
        return WB.isGCSelectedErgonomically();
    }

    public static GC selected() {
        for (GC gc : GC.values()) {
            if (!gc.isSelected()) continue;
            return gc;
        }
        throw new IllegalStateException("No selected GC found");
    }

    static {
        WB = WhiteBox.getWhiteBox();
    }
}

