/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.systemd;

import java.util.ArrayList;
import java.util.Collections;
import jdk.test.lib.Asserts;

public class SystemdRunOptions {
    public ArrayList<String> javaOpts = new ArrayList();
    public String classToRun;
    public ArrayList<String> classParams = new ArrayList();
    public String memoryLimit;
    public String cpuLimit;
    public String sliceName;
    public String sliceDMemoryLimit;
    public String sliceDCpuLimit;

    public SystemdRunOptions(String classToRun, String ... javaOpts) {
        this.classToRun = classToRun;
        Collections.addAll(this.javaOpts, javaOpts);
        this.sliceName = SystemdRunOptions.defaultSliceName();
    }

    private static String defaultSliceName() {
        String testname = System.getProperty("test.name");
        Asserts.assertNotNull(testname, "must be set by jtreg");
        testname = testname.replace(".java", "");
        testname = testname.replace("/", "_");
        testname = testname.replace("\\", "_");
        testname = testname.replace("-", "_");
        return testname;
    }

    public SystemdRunOptions memoryLimit(String memLimit) {
        this.memoryLimit = memLimit;
        return this;
    }

    public SystemdRunOptions sliceDMemoryLimit(String memoryLimit) {
        this.sliceDMemoryLimit = memoryLimit;
        return this;
    }

    public SystemdRunOptions cpuLimit(String cpuLimit) {
        this.cpuLimit = cpuLimit;
        return this;
    }

    public SystemdRunOptions sliceDCpuLimit(String cpuLimit) {
        this.sliceDCpuLimit = cpuLimit;
        return this;
    }

    public SystemdRunOptions sliceName(String name) {
        this.sliceName = name;
        return this;
    }

    public SystemdRunOptions addJavaOpts(String ... opts) {
        Collections.addAll(this.javaOpts, opts);
        return this;
    }

    public SystemdRunOptions addClassOptions(String ... opts) {
        Collections.addAll(this.classParams, opts);
        return this;
    }

    public boolean hasSliceDLimit() {
        return this.sliceDMemoryLimit != null || this.sliceDCpuLimit != null;
    }
}

