/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import jdk.test.lib.hprof.parser.FileReadBuffer;
import jdk.test.lib.hprof.parser.ReadBuffer;

class MappedReadBuffer
implements ReadBuffer {
    private MappedByteBuffer buf;
    private RandomAccessFile file;

    MappedReadBuffer(RandomAccessFile file, MappedByteBuffer buf) {
        this.file = file;
        this.buf = buf;
    }

    static ReadBuffer create(RandomAccessFile file) throws IOException {
        if (MappedReadBuffer.canUseFileMap()) {
            try {
                FileChannel ch = file.getChannel();
                long size = ch.size();
                MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ch.close();
                return new MappedReadBuffer(file, buf);
            }
            catch (IOException exp) {
                exp.printStackTrace();
                System.err.println("File mapping failed, will use direct read");
            }
        }
        return new FileReadBuffer(file);
    }

    private static boolean canUseFileMap() {
        String prop = System.getProperty("jhat.enableFileMap");
        return prop != null && prop.equals("true");
    }

    private void seek(long pos) throws IOException {
        assert (pos <= Integer.MAX_VALUE) : "position overflow";
        this.buf.position((int)pos);
    }

    @Override
    public synchronized char getChar(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getChar();
    }

    @Override
    public synchronized byte getByte(long pos) throws IOException {
        this.seek(pos);
        return this.buf.get();
    }

    @Override
    public synchronized short getShort(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getShort();
    }

    @Override
    public synchronized int getInt(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getInt();
    }

    @Override
    public synchronized long getLong(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getLong();
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }
}

