/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.ShapeGraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java2d.Surface;

public class AttributedStr
extends Surface {
    static final Color black = new Color(20, 20, 20);
    static final Color blue = new Color(94, 105, 176);
    static final Color yellow = new Color(255, 255, 140);
    static final Color red = new Color(149, 43, 42);
    static final Color white = new Color(240, 240, 255);
    static final String text = "  A quick brown  fox  jumped  over the lazy duke  ";
    static final AttributedString as = new AttributedString("  A quick brown  fox  jumped  over the lazy duke  ");
    static AttributedCharacterIterator aci;

    public AttributedStr() {
        this.setBackground(Color.white);
        Font font = this.getFont("A.ttf");
        font = font != null ? font.deriveFont(0, 70.0f) : new Font("Serif", 0, 50);
        int index = text.indexOf("A") + 1;
        as.addAttribute(TextAttribute.FONT, font, 0, index);
        as.addAttribute(TextAttribute.FOREGROUND, white, 0, index);
        font = new Font("Dialog", 0, 40);
        int size = this.getFontMetrics(font).getHeight();
        BufferedImage bi = new BufferedImage(size, size, 2);
        Graphics2D big = bi.createGraphics();
        big.drawImage(this.getImage("snooze.png"), 0, 0, size, size, null);
        ImageGraphicAttribute iga = new ImageGraphicAttribute(bi, -1);
        as.addAttribute(TextAttribute.CHAR_REPLACEMENT, iga, text.length() - 1, text.length());
        aci = as.getIterator();
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        float x = 5.0f;
        float y = 0.0f;
        FontRenderContext frc = g2.getFontRenderContext();
        LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
        g2.setPaint(new GradientPaint(0.0f, h, blue, w, 0.0f, black));
        g2.fillRect(0, 0, w, h);
        g2.setColor(white);
        String s = "AttributedString LineBreakMeasurer";
        Font font = new Font("Serif", 0, 12);
        TextLayout tl = new TextLayout(s, font, frc);
        tl.draw(g2, 5.0f, y += (float)tl.getBounds().getHeight());
        g2.setColor(yellow);
        while (y < (float)h - tl.getAscent()) {
            lbm.setPosition(0);
            while (lbm.getPosition() < text.length()) {
                tl = lbm.nextLayout((float)w - x);
                if (!tl.isLeftToRight()) {
                    x = (float)w - tl.getAdvance();
                }
                tl.draw(g2, x, y += tl.getAscent());
                y += tl.getDescent() + tl.getLeading();
            }
        }
    }

    public static void main(String[] s) {
        AttributedStr.createDemoFrame(new AttributedStr());
    }

    static {
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 25.0, 12.0, 12.0);
        ShapeGraphicAttribute sga = new ShapeGraphicAttribute(shape, -1, false);
        as.addAttribute(TextAttribute.CHAR_REPLACEMENT, sga, 0, 1);
        Font font = new Font("sanserif", 3, 20);
        int index = text.indexOf("quick");
        as.addAttribute(TextAttribute.FONT, font, index, index + 5);
        index = text.indexOf("brown");
        font = new Font("Serif", 1, 20);
        as.addAttribute(TextAttribute.FONT, font, index, index + 5);
        as.addAttribute(TextAttribute.FOREGROUND, red, index, index + 5);
        index = text.indexOf("fox");
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(Math.toRadians(10.0));
        Font fx = new Font("Serif", 1, 30).deriveFont(fontAT);
        as.addAttribute(TextAttribute.FONT, fx, index, index + 1);
        as.addAttribute(TextAttribute.FONT, fx, index + 1, index + 2);
        as.addAttribute(TextAttribute.FONT, fx, index + 2, index + 3);
        fontAT.setToRotation(Math.toRadians(-4.0));
        fx = font.deriveFont(fontAT);
        index = text.indexOf("jumped");
        as.addAttribute(TextAttribute.FONT, fx, index, index + 6);
        font = new Font("Serif", 3, 30);
        index = text.indexOf("over");
        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, index, index + 4);
        as.addAttribute(TextAttribute.FOREGROUND, white, index, index + 4);
        as.addAttribute(TextAttribute.FONT, font, index, text.length());
        font = new Font("Dialog", 0, 20);
        int i = text.indexOf("duke");
        as.addAttribute(TextAttribute.FONT, font, index, i - 1);
        BufferedImage bi = new BufferedImage(4, 4, 2);
        bi.setRGB(0, 0, -1);
        TexturePaint tp = new TexturePaint(bi, new Rectangle(0, 0, 4, 4));
        as.addAttribute(TextAttribute.BACKGROUND, tp, i, i + 4);
        font = new Font("Serif", 1, 40);
        as.addAttribute(TextAttribute.FONT, font, i, i + 4);
    }
}

