/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class InMemoryJavaCompiler {
    public static byte[] compile(String className, CharSequence sourceCode, String ... options) {
        byte[] byArray;
        MemoryJavaFileObject file = new MemoryJavaFileObject(className, sourceCode);
        ArrayList<String> opts = new ArrayList<String>();
        String moduleOverride = null;
        for (String opt : options) {
            if (opt.startsWith("--patch-module=")) {
                moduleOverride = opt.substring("--patch-module=".length());
                continue;
            }
            opts.add(opt);
        }
        FileManagerWrapper fileManager = new FileManagerWrapper(file, moduleOverride);
        try {
            JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompiler().getTask(null, fileManager, null, opts, null, Arrays.asList(file));
            if (!task.call().booleanValue()) {
                throw new RuntimeException("Could not compile " + className + " with source code " + String.valueOf(sourceCode));
            }
            byArray = file.getByteCode();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        fileManager.close();
        return byArray;
    }

    private static JavaCompiler getCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    private static class MemoryJavaFileObject
    extends SimpleJavaFileObject {
        private final String className;
        private final CharSequence sourceCode;
        private final ByteArrayOutputStream byteCode;

        public MemoryJavaFileObject(String className, CharSequence sourceCode) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.className = className;
            this.sourceCode = sourceCode;
            this.byteCode = new ByteArrayOutputStream();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.sourceCode;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.byteCode;
        }

        public byte[] getByteCode() {
            return this.byteCode.toByteArray();
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static class FileManagerWrapper
    extends ForwardingJavaFileManager<JavaFileManager> {
        private static final JavaFileManager.Location PATCH_LOCATION = new JavaFileManager.Location(){

            @Override
            public String getName() {
                return "patch module location";
            }

            @Override
            public boolean isOutputLocation() {
                return false;
            }
        };
        private final MemoryJavaFileObject file;
        private final String moduleOverride;

        public FileManagerWrapper(MemoryJavaFileObject file, String moduleOverride) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.file = file;
            this.moduleOverride = moduleOverride;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (!this.file.getClassName().equals(className)) {
                throw new IOException("Expected class with name " + this.file.getClassName() + ", but got " + className);
            }
            return this.file;
        }

        @Override
        public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
            if (fo == this.file && this.moduleOverride != null) {
                return PATCH_LOCATION;
            }
            return super.getLocationForModule(location, fo);
        }

        @Override
        public String inferModuleName(JavaFileManager.Location location) throws IOException {
            if (location == PATCH_LOCATION) {
                return this.moduleOverride;
            }
            return super.inferModuleName(location);
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return super.hasLocation(location) || location == StandardLocation.PATCH_MODULE_PATH;
        }
    }
}

