/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ha extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_ar = "Larabci";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_GR = "Girka";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Ibrananci";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_th = "Thai";
        final String metaValue_vai = "Vai";
        final Object[][] data = new Object[][] {
            { "001", "Duniya" },
            { "002", "Afirka" },
            { "003", "Amurka ta Arewa" },
            { "005", "Amurka ta Kudu" },
            { "009", "Osheniya" },
            { "011", "Afirka ta Yamma" },
            { "013", "Amurka ta Tsakiya" },
            { "014", "Afirka ta Gabas" },
            { "015", "Arewacin Afirka" },
            { "017", "Afirka ta Tsakiya" },
            { "018", "Kudancin Afirka" },
            { "019", "Nahiyoyin Amurka" },
            { "021", "Arewacin Amurka" },
            { "029", "Karebiyan" },
            { "030", "Gabashin Asiya" },
            { "034", "Kudancin Asiya" },
            { "035", "Kudu Maso Gabashin Asiya" },
            { "039", "Kudancin Turai" },
            { "053", "Asturesiya" },
            { "054", "Melanesia" },
            { "057", "Yankin Micronesiya" },
            { "061", "Kasar Polynesia" },
            { "142", "Asiya" },
            { "143", "Asiya ta Tsakiya" },
            { "145", "Yammacin Asiya" },
            { "150", "Turai" },
            { "151", "Gabashin Turai" },
            { "154", "Arewacin Turai" },
            { "155", "Yammacin Turai" },
            { "202", "Afirka ta Kudancin Sahara" },
            { "419", "Latin Amurka" },
            { "AC", "Tsibirin Ascension" },
            { "AD", "Andora" },
            { "AE", "Ha\u0257a\u0257\u0257iyar Daular Larabawa" },
            { "AF", "Afaganistan" },
            { "AG", "Antigua da Barbuda" },
            { "AI", "Angila" },
            { "AL", "Albaniya" },
            { "AM", "Armeniya" },
            { "AO", "Angola" },
            { "AQ", "Antatika" },
            { "AR", "Arjantiniya" },
            { "AS", "Samowa Ta Amurka" },
            { "AT", "Ostiriya" },
            { "AU", "Ostareliya" },
            { "AW", "Aruba" },
            { "AX", "Tsibirai na \u00c5land" },
            { "AZ", "Azarbaijan" },
            { "BA", "Bosniya da Harzagobina" },
            { "BB", "Barbadas" },
            { "BD", "Bangiladas" },
            { "BE", "Belgiyom" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgariya" },
            { "BH", "Baharan" },
            { "BI", "Burundi" },
            { "BJ", "Binin" },
            { "BL", "San Barth\u00e9lemy" },
            { "BM", "Barmuda" },
            { "BN", "Burune" },
            { "BO", "Bolibiya" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Birazil" },
            { "BS", "Bahamas" },
            { "BT", "Butan" },
            { "BV", "Tsibirin Bouvet" },
            { "BW", "Baswana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "CC", "Tsibirai Cocos (Keeling)" },
            { "CD", "Jamhuriyar Dimokura\u0257iyyar Kongo" },
            { "CF", "Jamhuriyar Afirka Ta Tsakiya" },
            { "CG", "Kongo" },
            { "CH", "Suwizalan" },
            { "CI", "Aibari Kwas" },
            { "CK", "Tsibiran Kuku" },
            { "CL", "Cayile" },
            { "CM", "Kamaru" },
            { "CN", "Sin" },
            { "CO", "Kolambiya" },
            { "CP", "Tsibirin Clipperton" },
            { "CR", "Kwasta Rika" },
            { "CU", "Kyuba" },
            { "CV", "Tsibiran Kap Barde" },
            { "CW", "\u0198asar Cura\u00e7ao" },
            { "CX", "Tsibirin Kirsmati" },
            { "CY", "Sifurus" },
            { "CZ", "Jamhuriyar Cak" },
            { "DE", "Jamus" },
            { "DG", "Tsibirn Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Danmark" },
            { "DM", "Dominika" },
            { "DO", "Jamhuriyar Dominika" },
            { "DZ", "Aljeriya" },
            { "EA", "Ceuta da Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estoniya" },
            { "EG", "Misira" },
            { "EH", "Yammacin Sahara" },
            { "ER", "Eritireya" },
            { "ES", "Sipen" },
            { "ET", "Habasha" },
            { "EU", "Tarayyar Turai" },
            { "EZ", "Sashin Turai" },
            { "FI", "Finlan" },
            { "FJ", "Fiji" },
            { "FK", "Tsibiran Falkilan" },
            { "FM", "Mikuronesiya" },
            { "FO", "Tsibirai na Faroe" },
            { "FR", "Faransa" },
            { "GA", "Gabon" },
            { "GB", "Biritaniya" },
            { "GD", "Girnada" },
            { "GE", "Jiwarjiya" },
            { "GF", "Gini Ta Faransa" },
            { "GG", "Yankin Guernsey" },
            { "GH", "Gana" },
            { "GI", "Jibaraltar" },
            { "GL", "Grinlan" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Gwadaluf" },
            { "GQ", "Gini Ta Ikwaita" },
            { "GR", metaValue_GR },
            { "GS", "Kudancin Geogia da Kudancin Tsibirin Sandiwic" },
            { "GT", "Gwatamala" },
            { "GU", "Gwam" },
            { "GW", "Gini Bisau" },
            { "GY", "Guyana" },
            { "HK", "Babban Yankin Mulkin Hong Kong na \u0198asar Sin" },
            { "HM", "Tsibirin Heard da McDonald" },
            { "HN", "Yankin Honduras" },
            { "HR", "Kurowaishiya" },
            { "HT", "Haiti" },
            { "HU", "Hungari" },
            { "IC", "Tsibiran Canary" },
            { "ID", "Indunusiya" },
            { "IE", "Ayalan" },
            { "IL", "Isra\u02bcila" },
            { "IM", "Isle na Mutum" },
            { "IN", "Indiya" },
            { "IO", "Yankin Birtaniya Na Tekun Indiya" },
            { "IQ", "Ira\u0199i" },
            { "IR", "Iran" },
            { "IS", "Aisalan" },
            { "IT", "Italiya" },
            { "JE", "Kasar Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodiya" },
            { "KI", "Kiribati" },
            { "KM", "Kwamoras" },
            { "KN", "San Kiti Da Nebis" },
            { "KP", "Koriya Ta Arewa" },
            { "KR", "Koriya Ta Kudu" },
            { "KW", "Kwiyat" },
            { "KY", "Tsibiran Kaiman" },
            { "KZ", "Kazakistan" },
            { "LA", "Lawas" },
            { "LB", "Labanan" },
            { "LC", "San Lusiya" },
            { "LI", "Licansitan" },
            { "LK", "Siri Lanka" },
            { "LR", "Laberiya" },
            { "LS", "Lesoto" },
            { "LT", "Lituweniya" },
            { "LU", "Lukusambur" },
            { "LV", "Litibiya" },
            { "LY", "Libiya" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Maldoba" },
            { "ME", "Mantanegara" },
            { "MF", "San Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Tsibiran Marshal" },
            { "MK", "Macedonia ta Arewa" },
            { "ML", "Mali" },
            { "MM", "Burma, Miyamar" },
            { "MN", "Mangoliya" },
            { "MO", "Babban Yankin Mulkin Macao na \u0198asar Sin" },
            { "MP", "Tsibiran Mariyana Na Arewa" },
            { "MQ", "Martinik" },
            { "MR", "Moritaniya" },
            { "MS", "Manserati" },
            { "MT", "Malta" },
            { "MU", "Moritus" },
            { "MV", "Maldibi" },
            { "MW", "Malawi" },
            { "MX", "Mesiko" },
            { "MY", "Malaisiya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiya" },
            { "NC", "Kaledoniya Sabuwa" },
            { "NE", "Nijar" },
            { "NF", "Tsibirin Narfalk" },
            { "NG", "Nijeriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Holan" },
            { "NO", "Norwe" },
            { "NP", "Nefal" },
            { "NR", metaValue_NR },
            { "NU", "Niyu" },
            { "NZ", "Nuzilan" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Feru" },
            { "PF", "Folinesiya Ta Faransa" },
            { "PG", "Papuwa Nugini" },
            { "PH", "Filipin" },
            { "PK", "Pakistan" },
            { "PL", "Polan" },
            { "PM", "San Piyar da Mikelan" },
            { "PN", "Pitakarin" },
            { "PR", "Porto Riko" },
            { "PS", "Yankunan Palas\u0257inu" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Faragwai" },
            { "QA", "Katar" },
            { "QO", "Bakin Teku" },
            { "RE", "Rawuniyan" },
            { "RO", "Romaniya" },
            { "RS", "Sabiya" },
            { "RU", "Rasha" },
            { "RW", "Ruwanda" },
            { "SA", "Saudiyya" },
            { "SB", "Tsibiran Salaman" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Suwedan" },
            { "SG", "Singapur" },
            { "SH", "San Helena" },
            { "SI", "Sulobeniya" },
            { "SJ", "Svalbard da Jan Mayen" },
            { "SK", "Sulobakiya" },
            { "SL", "Salewo" },
            { "SM", "San Marino" },
            { "SN", "Sanigal" },
            { "SO", "Somaliya" },
            { "SR", "Suriname" },
            { "SS", "Sudan ta Kudu" },
            { "ST", "Sawo Tome Da Paransip" },
            { "SV", "El Salbador" },
            { "SX", "San Maarten" },
            { "SY", "Sham, Siriya" },
            { "SZ", "Eswatini" },
            { "TA", "Tritan da Kunha" },
            { "TC", "Turkis Da Tsibiran Kaikwas" },
            { "TD", "Cadi" },
            { "TF", "Yankin Faransi ta Kudu" },
            { "TG", "Togo" },
            { "TH", "Tailan" },
            { "TJ", "Tajikistan" },
            { "TK", "Takelau" },
            { "TL", "Timor Ta Gabas" },
            { "TM", "Turkumenistan" },
            { "TN", "Tunisiya" },
            { "TO", "Tonga" },
            { "TR", "Turkiyya" },
            { "TT", "Tirinidad Da Tobago" },
            { "TV", "Tubalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzaniya" },
            { "UA", "Yukaran" },
            { "UG", "Yuganda" },
            { "UM", "Rukunin Tsibirin U.S" },
            { "UN", "Majalisar \u018ainkin Duniya" },
            { "US", "Amurka" },
            { "UY", "Yurigwai" },
            { "UZ", "Uzubekistan" },
            { "VA", "Batikan" },
            { "VC", "San Binsan Da Girnadin" },
            { "VE", "Benezuwela" },
            { "VG", "Tsibirin Birjin Na Birtaniya" },
            { "VI", "Tsibiran Birjin Ta Amurka" },
            { "VN", "Biyetinam" },
            { "VU", "Banuwatu" },
            { "WF", "Walis Da Futuna" },
            { "WS", "Samoa" },
            { "XA", "Gogewar Kwalwa" },
            { "XB", "Gano wani abu ta hanyar amfani da fasaha" },
            { "XK", "Kasar Kosovo" },
            { "YE", "Yamal" },
            { "YT", "Mayoti" },
            { "ZA", "Afirka Ta Kudu" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabuwe" },
            { "ZZ", "Yanki da ba a sani ba" },
            { "ab", "Abkhazian" },
            { "af", "Afirkanci" },
            { "ak", "Akan" },
            { "am", "Amharik" },
            { "an", "Aragonesanci" },
            { "ar", metaValue_ar },
            { "as", "Asamisanci" },
            { "av", "Avaric" },
            { "ay", "Aymaranci" },
            { "az", "Azerbaijanci" },
            { "ba", "Bashkir" },
            { "be", "Belarusanci" },
            { "bg", "Bulgariyanci" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetan" },
            { "br", "Buretananci" },
            { "bs", "Bosniyanci" },
            { "ca", "Kataloniyanci" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cs", "Cek" },
            { "cu", "Church Slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "Jamusanci" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Girkanci" },
            { "en", "Turanci" },
            { "eo", "Esperanto" },
            { "es", "Sifaniyanci" },
            { "et", "Istoniyanci" },
            { "eu", "Basque" },
            { "fa", "Farisa" },
            { "ff", "Fulah" },
            { "fi", "Yaren mutanen Finland" },
            { "fj", "Fijiyanci" },
            { "fo", "Faroese" },
            { "fr", "Faransanci" },
            { "fy", "Frisian ta Yamma" },
            { "ga", "Dan Irish" },
            { "gd", "K\u02bcabilan Scots Gaelic" },
            { "gl", "Bagalike" },
            { "gn", "Guwaraniyanci" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Harshen Hindi" },
            { "hr", "Kuroshiyan" },
            { "ht", "Haitian Creole" },
            { "hu", "Harshen Hungari" },
            { "hy", "Armeniyanci" },
            { "hz", "Herero" },
            { "ia", "Yare Tsakanin Kasashe" },
            { "id", "Harshen Indunusiya" },
            { "ie", "Intagulanci" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Yaren mutanen Iceland" },
            { "it", "Italiyanci" },
            { "iu", "Inuktitut" },
            { "ja", "Japananci" },
            { "jv", "Jafananci" },
            { "ka", "Jojiyanci" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", "Harshen Kimar" },
            { "kn", "Kannada" },
            { "ko", "Harshen Koreya" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdanci" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizanci" },
            { "la", "Dan Kabilar Latin" },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", "Lao" },
            { "lt", "Lituweniyanci" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latbiyanci" },
            { "mg", "Malagasi" },
            { "mh", "Marshallese" },
            { "mi", "Maori" },
            { "mk", "Dan Masedoniya" },
            { "ml", "Malayalamci" },
            { "mn", "Mongoliyanci" },
            { "mr", "Maratinci" },
            { "ms", "Harshen Malai" },
            { "mt", "Harshen Maltis" },
            { "my", "Burmanci" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Holanci" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Harhsen Norway" },
            { "nr", "Ndebele na Kudu" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Ositanci" },
            { "om", "Oromo" },
            { "or", "Odiya" },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pl", "Harshen Polan" },
            { "ps", "Pashtanci" },
            { "pt", "Harshen Potugis" },
            { "qu", "Quechua" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", "Romaniyanci" },
            { "ru", "Rashanci" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardiniyanci" },
            { "sd", "Sindiyanci" },
            { "se", "Sami ta Arewa" },
            { "sg", "Sango" },
            { "sh", "Kuroweshiyancin-Sabiya" },
            { "si", "Sinhalanci" },
            { "sk", "Basulke" },
            { "sl", "Basulabe" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somalianci" },
            { "sq", "Albaniyanci" },
            { "sr", "Sabiyan" },
            { "ss", "Swati" },
            { "st", "Sesotanci" },
            { "su", "Harshen Sundanese" },
            { "sv", "Harshen Suwedan" },
            { "sw", "Harshen Suwahili" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinyanci" },
            { "tk", "Tukmenistanci" },
            { "tn", "Tswana" },
            { "to", "Tonganci" },
            { "tr", "Harshen Turkiyya" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Tiwiniyanci" },
            { "ty", "Tahitiyanci" },
            { "ug", "Ugiranci" },
            { "uk", "Harshen Yukuren" },
            { "ur", "Urdanci" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Harshen Biyetinam" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Bazosa" },
            { "yi", "Yaren Yiddish" },
            { "yo", "Yarbanci" },
            { "zh", "Harshen Sinanci" },
            { "zu", "Harshen Zulu" },
            { "ace", "Achinese" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Altai na Kudanci" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Larabcin Najdi" },
            { "asa", "Asu" },
            { "ast", "Asturia" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "ban", "Balenesanci" },
            { "bas", "Basaa" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bgc", "Haryanvi" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksik\u00e1" },
            { "brx", "Bodo" },
            { "bug", "Buginesanci" },
            { "byn", "Blin" },
            { "cay", "Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Kurdawa ta Tsakiya" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Cree na Kusu-Maso-Gabas" },
            { "crk", "Plains Cree" },
            { "crl", "Cree na Arewacin-Gabas" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Harshen Dogri" },
            { "dsb", "Sorbianci ta kasa" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Dan Filifin" },
            { "fon", "Fon" },
            { "frc", "Faransancin Cajun" },
            { "frr", "Firisiyanci na Arewaci" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "Jamusanci Swiss" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawaiianci" },
            { "hax", "Haida na Kudanci" },
            { "hil", "Hiligaynon" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbianci ta Sama" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut na Yammacin Kanada" },
            { "ilo", "Ikolo" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Karbadiyanci" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkananci" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Kareliyanci" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colognian" },
            { "kum", "Kumyk" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lez", "Lezghiniyanci" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lou", "Creole na Louisiana" },
            { "loz", "Lozi" },
            { "lrc", "Arewacin Luri" },
            { "lsm", "Saamiyanci" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "mas", "Harshen Masai" },
            { "mdf", "Moksha" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u02bc" },
            { "mic", "Mi'kmaq" },
            { "min", "Minangkabau" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Harsuna masu yawa" },
            { "mus", "Muscogee" },
            { "mwl", "Mirandese" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Harshen Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Sotho na Arewaci" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Ojibwa na Arewa-Maso-Yamma" },
            { "ojc", "Ojibwa na Tsakiya" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwa na Yammaci" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinanci" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Pidgin na Najeriya" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Ferusawa" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Harshen Rohingya" },
            { "rof", "Rombo" },
            { "rup", "Aromaniyanci" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sisiliyanci" },
            { "sco", "Scots" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "slh", "Lushbootseed na Kudanci" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Komoriyanci" },
            { "syr", "Syriac" },
            { "tce", "Tutchone na Kudanci" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tatum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Tutchone na Arewaci" },
            { "tum", "Tumbuka" },
            { "tvl", "Tuvalu" },
            { "twq", "Tasawak" },
            { "tyv", "Tuviniyanci" },
            { "tzm", "Tamazight na Atlas Tsaka" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Harshen da ba a sani ba" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wuu", "Sinancin Wu" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Harshen Cantonese" },
            { "zgh", "Daidaitaccen Moroccan Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Babu abun cikin yare" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "Rubutun Nastaliq" },
            { "Armn", "Armeniyawa" },
            { "Beng", "Bangla" },
            { "Bopo", "Bopomofo" },
            { "Brai", "Rubutun Makafi" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Ha\u0257a\u0257\u0257un Ga\u0253o\u0253in \u02bcYan Asali na Kanada" },
            { "Cher", metaValue_chr },
            { "Cyrl", "Cyrillic" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopic" },
            { "Geor", "Georgian" },
            { "Grek", metaValue_GR },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han tare da Bopomofo" },
            { "Hang", "Yaren Hangul" },
            { "Hani", "Mutanen Han na \u0199asar Sin" },
            { "Hans", "Sau\u0199a\u0199a\u0199\u0199en" },
            { "Hant", "Na gargajiya" },
            { "Hebr", metaValue_he },
            { "Hira", "Tsarin Rubutun Hiragana" },
            { "Hrkt", "kalaman Jafananci" },
            { "Jamo", "Jamo" },
            { "Jpan", "Jafanis" },
            { "Kana", "Tsarin Rubutun Katakana" },
            { "Khmr", "Yaren Khmer" },
            { "Knda", "Yaren Kannada" },
            { "Kore", "Rubutun Koriya" },
            { "Laoo", "Yan lao" },
            { "Latn", "Latin" },
            { "Mlym", "Yaren Malayalam" },
            { "Mong", "Na kasar Mongolia" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "\u0198asar Myanmar" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", "Yaren Odia" },
            { "Rohg", "Hanifi" },
            { "Sinh", "Yaren Sinhala" },
            { "Sund", "Sudananci" },
            { "Syrc", "Siriyanci" },
            { "Taml", "Yaren Tamil" },
            { "Telu", "Yaren Telugu" },
            { "Tfng", "Tifinagh" },
            { "Thaa", "Yaren Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "Yaren Tibet" },
            { "Vaii", metaValue_vai },
            { "Yiii", "Yi" },
            { "Zmth", "Alamar Lissafi" },
            { "Zsye", "Alama ta hoto" },
            { "Zsym", "Alamomi" },
            { "Zxxx", "Ba rubutacce ba" },
            { "Zyyy", "Gama-gari" },
            { "Zzzz", "Rubutun da ba sani ba" },
            { "de_AT", "Jamusanci Ostiriya" },
            { "de_CH", "Jamusanci Suwizalan" },
            { "en_AU", "Turanci Ostareliya" },
            { "en_CA", "Turanci Kanada" },
            { "en_GB", "Turanci Biritaniya" },
            { "en_US", "Turanci Amirka" },
            { "es_ES", "Sifaniyanci Turai" },
            { "es_MX", "Sifaniyanci Mesiko" },
            { "fa_AF", "Farisanci na Afaganistan" },
            { "fr_CA", "Farasanci Kanada" },
            { "fr_CH", "Farasanci Suwizalan" },
            { "pt_BR", "Harshen Potugis na Birazil" },
            { "pt_PT", "Potugis \u0198asashen Turai" },
            { "ar_001", "Larabci Asali Na Zamani" },
            { "es_419", "Sifaniyancin Latin Amirka" },
            { "key.ca", "Kalanda" },
            { "key.cf", "Yanayin Kudi" },
            { "key.co", "Tsarin Rabewa" },
            { "key.cu", "Kudin Kasa" },
            { "key.hc", "Zagayen Awowi" },
            { "key.lb", "Salo na Raba Layi" },
            { "key.ms", "Tsarin Awo" },
            { "key.nu", "Lambobi" },
            { "hi_Latn", "Hindi (Latinanci)" },
            { "zh_Hans", "Sau\u0199a\u0199a\u0199\u0199en Sinanci" },
            { "zh_Hant", "Sinanci na gargajiya" },
            { "type.ca.roc", "Kalandar kasar Sin" },
            { "type.hc.h11", "Tsarin Awowi 12(0\u201311)" },
            { "type.hc.h12", "Tsarin Awowi 12(1\u201312)" },
            { "type.hc.h23", "Tsarin Awowi 24(0\u201323)" },
            { "type.hc.h24", "Tsarin Awowi 24(1\u201324)" },
            { "type.nu.arab", "Lambobi na Larabawan a Gabas" },
            { "type.nu.armn", "Lambobin \u0199irga na Armenia" },
            { "type.nu.beng", "Lambobin Yaren Bangla" },
            { "type.nu.cakm", "Lambobin Chakma" },
            { "type.nu.deva", "Lambobin Tsarin Rubutu na Devangari" },
            { "type.nu.ethi", "Lambobin \u0199irga na Ethiopia" },
            { "type.nu.geor", "Lambobin \u0199irga na Georgia" },
            { "type.nu.grek", "Lambobin \u0199irga na Girka" },
            { "type.nu.gujr", "Lambobin Yaren Gujarati" },
            { "type.nu.guru", "Lambobi na Tsarin Rubutun Gurmukhi" },
            { "type.nu.hans", "Lambobin \u0199irga na Yaren \u0199asar Sin wanda aka Sau\u0199a\u0199a" },
            { "type.nu.hant", "Lambobin \u0198irga na Yaren \u0199asar Sin na Al\u02bcada" },
            { "type.nu.hebr", "Lambobin \u0199irga na Hebrew" },
            { "type.nu.java", "Lambobin Javanese" },
            { "type.nu.jpan", "Lambobin \u0199irga na Jafananci" },
            { "type.nu.khmr", "Lambobin Yaren Khmer" },
            { "type.nu.knda", "Lambobin Yaren Kannada" },
            { "type.nu.laoo", "Lambobin Yaren Lao" },
            { "type.nu.latn", "Lambobi na Yammaci" },
            { "type.nu.mlym", "Lambobin Yaren Malayalam" },
            { "type.nu.mtei", "Lambobin Meetei Mayek" },
            { "type.nu.mymr", "Lambobin Myanmar" },
            { "type.nu.olck", "Lambobin Ol Chiki" },
            { "type.nu.orya", "Lambobin Yaren Odia" },
            { "type.nu.taml", "Lambobin \u0199irga na Tamil na Al\u02bcada" },
            { "type.nu.telu", "Lambobin yaren Telugu" },
            { "type.nu.thai", "Lambobin yaren Thai" },
            { "type.nu.tibt", "Lambobin yaren Tibet" },
            { "type.nu.vaii", "Lambobin Vai" },
            { "type.ca.dangi", "Kalandar Dangi" },
            { "type.co.ducet", "Tsarin Rabewa na Dan-ma\u0199alu na Asali" },
            { "type.lb.loose", "Salo na Raba Layi Sakakke" },
            { "type.nu.roman", "Lambobin Rumawa" },
            { "type.ca.coptic", "Kalandar Coptic" },
            { "type.ca.hebrew", "Kalandar Ibrananci" },
            { "type.co.search", "Bincike na Dalilai-Gamagari" },
            { "type.lb.normal", "Salo na Raba Layi na Kodayaushe" },
            { "type.lb.strict", "Salo na Raba Layi mai Tsauri" },
            { "type.ms.metric", "Tsarin Awo na Metric" },
            { "type.ca.chinese", "Kalandar Sin" },
            { "type.ca.islamic", "Kalandar Musulunci" },
            { "type.ca.iso8601", "Kalandar ISO-8601" },
            { "type.ca.persian", "Kalandar Farisa" },
            { "type.cf.account", "Tsarin Kudi na Kididdiga" },
            { "type.nu.arabext", "Fitattun lambobin lissafi na Larabci" },
            { "type.nu.armnlow", "Kananan Haruffan Armenia" },
            { "type.nu.greklow", "Kananan Haruffa na Girka" },
            { "type.nu.hanidec", "Lambobin Gomiya na Yaren \u0199asar Sin" },
            { "type.nu.hansfin", "Lambobin \u0198irgan Kudi na Yaren \u0199asar Sin wanda aka Sau\u0199a\u0199a" },
            { "type.nu.hantfin", "Lambobin \u0198irgan Kudi na Yaren \u0199asar Sin na Al\u02bcada" },
            { "type.nu.jpanfin", "Lambobin \u0199irgan Kudi na Jafananci" },
            { "type.nu.tamldec", "Lambobin Tamil" },
            { "type.ca.buddhist", "Kalandar Buddist" },
            { "type.ca.ethiopic", "Kalandar Etiofic" },
            { "type.ca.japanese", "Kalandar Jafan" },
            { "type.cf.standard", "Tsarin Kudi Nagartacce" },
            { "type.co.standard", "Daidaitaccen Kasawa" },
            { "type.ms.uksystem", "Tsarin Awo na Imperial" },
            { "type.ms.ussystem", "Tsarin Awo na Amurka" },
            { "type.nu.fullwide", "Lambobi masu Cikakken-Fa\u0257i" },
            { "type.nu.romanlow", "Lambobin Kirga Kanana na Rumawa" },
            { "type.ca.gregorian", "Kalandar Gregoria" },
            { "type.ca.islamic-tbla", "Kalandar Musulunci (tabular, astronomical epoch)" },
            { "type.ca.islamic-civil", "Kalandar Musulunci (tabular, civil epoch)" },
            { "type.ca.islamic-umalqura", "Kalandar Musulunci (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalandar Ethiopic Amete Alem" },
        };
        return data;
    }
}
