/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.process;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.test.lib.Asserts;
import jdk.test.lib.process.OutputBuffer;

public final class OutputAnalyzer {
    private static final String jvmwarningmsg = ".* VM warning:.*";
    private static final String deprecatedmsg = ".* VM warning:.* deprecated.*";
    private static final String FATAL_ERROR_PAT = "# A fatal error has been detected.*";
    private final OutputBuffer buffer;

    public OutputAnalyzer(Process process, Charset cs) throws IOException {
        this.buffer = OutputBuffer.of(process, cs);
    }

    public OutputAnalyzer(Process process) throws IOException {
        this.buffer = OutputBuffer.of(process);
    }

    public OutputAnalyzer(String buf) {
        this.buffer = OutputBuffer.of(buf, buf);
    }

    public OutputAnalyzer(Path file) throws IOException {
        this(Files.readString(file));
    }

    public OutputAnalyzer(String stdout, String stderr) {
        this.buffer = OutputBuffer.of(stdout, stderr);
    }

    public OutputAnalyzer(String stdout, String stderr, int exitValue) {
        this.buffer = OutputBuffer.of(stdout, stderr, exitValue);
    }

    public void waitFor() {
        this.buffer.waitFor();
    }

    public OutputAnalyzer stdoutShouldBeEmpty() {
        if (!this.getStdout().isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stdout was not empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldBeEmpty() {
        if (!this.getStderr().isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldBeEmptyIgnoreVMWarnings() {
        if (!this.getStderr().replaceAll(".* VM warning:.*\\R", "").isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldBeEmptyIgnoreWarnings() {
        if (!this.getStderr().replaceAll("(?i).*warning.*\\R", "").isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldBeEmptyIgnoreDeprecatedWarnings() {
        if (!this.getStderr().replaceAll(".* VM warning:.* deprecated.*\\R", "").isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stdoutShouldNotBeEmpty() {
        if (this.getStdout().isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stdout was empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldNotBeEmpty() {
        if (this.getStderr().isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was empty");
        }
        return this;
    }

    public boolean stdoutContains(String expectedString) {
        return this.getStdout().contains(expectedString);
    }

    public boolean stderrContains(String expectedString) {
        return this.getStderr().contains(expectedString);
    }

    public boolean contains(String expectedString) {
        return this.stdoutContains(expectedString) || this.stderrContains(expectedString);
    }

    public OutputAnalyzer shouldContain(String expectedString) {
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        if (!stdout.contains(expectedString) && !stderr.contains(expectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + expectedString + "' missing from stdout/stderr");
        }
        return this;
    }

    public OutputAnalyzer stdoutShouldContain(String expectedString) {
        String stdout = this.getStdout();
        if (!stdout.contains(expectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + expectedString + "' missing from stdout");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldContain(String expectedString) {
        String stderr = this.getStderr();
        if (!stderr.contains(expectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + expectedString + "' missing from stderr");
        }
        return this;
    }

    public OutputAnalyzer shouldNotContain(String notExpectedString) {
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        if (stdout.contains(notExpectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + notExpectedString + "' found in stdout");
        }
        if (stderr.contains(notExpectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + notExpectedString + "' found in stderr");
        }
        return this;
    }

    public OutputAnalyzer shouldBeEmpty() {
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        if (!stdout.isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stdout was not empty");
        }
        if (!stderr.isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stdoutShouldNotContain(String notExpectedString) {
        String stdout = this.getStdout();
        if (stdout.contains(notExpectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + notExpectedString + "' found in stdout");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldNotContain(String notExpectedString) {
        String stderr = this.getStderr();
        if (stderr.contains(notExpectedString)) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + notExpectedString + "' found in stderr");
        }
        return this;
    }

    public OutputAnalyzer shouldMatch(String regexp) {
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher stdoutMatcher = pattern.matcher(stdout);
        Matcher stderrMatcher = pattern.matcher(stderr);
        if (!stdoutMatcher.find() && !stderrMatcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' missing from stdout/stderr");
        }
        return this;
    }

    public OutputAnalyzer stdoutShouldMatch(String regexp) {
        String stdout = this.getStdout();
        Matcher matcher = Pattern.compile(regexp, 8).matcher(stdout);
        if (!matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' missing from stdout");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldMatch(String pattern) {
        String stderr = this.getStderr();
        Matcher matcher = Pattern.compile(pattern, 8).matcher(stderr);
        if (!matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + pattern + "' missing from stderr");
        }
        return this;
    }

    public OutputAnalyzer shouldNotMatch(String regexp) {
        String stdout = this.getStdout();
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher matcher = pattern.matcher(stdout);
        if (matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' found in stdout: '" + matcher.group() + "'");
        }
        String stderr = this.getStderr();
        matcher = pattern.matcher(stderr);
        if (matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' found in stderr: '" + matcher.group() + "'");
        }
        return this;
    }

    public OutputAnalyzer stdoutShouldNotMatch(String regexp) {
        String stdout = this.getStdout();
        Matcher matcher = Pattern.compile(regexp, 8).matcher(stdout);
        if (matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' found in stdout");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldNotMatch(String regexp) {
        String stderr = this.getStderr();
        Matcher matcher = Pattern.compile(regexp, 8).matcher(stderr);
        if (matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + regexp + "' found in stderr");
        }
        return this;
    }

    public String firstMatch(String regexp, int group) {
        String stderr;
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher stderrMatcher = pattern.matcher(stderr = this.getStderr());
        if (stderrMatcher.find()) {
            return stderrMatcher.group(group);
        }
        String stdout = this.getStdout();
        Matcher stdoutMatcher = pattern.matcher(stdout);
        if (stdoutMatcher.find()) {
            return stdoutMatcher.group(group);
        }
        return null;
    }

    public String firstMatch(String pattern) {
        return this.firstMatch(pattern, 0);
    }

    public OutputAnalyzer shouldHaveExitValue(int expectedExitValue) {
        if (this.getExitValue() != expectedExitValue) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("Expected to get exit value of [" + expectedExitValue + "], exit value is: [" + this.getExitValue() + "]");
        }
        return this;
    }

    public OutputAnalyzer shouldNotHaveExitValue(int notExpectedExitValue) {
        if (this.getExitValue() == notExpectedExitValue) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("Unexpected to get exit value of [" + notExpectedExitValue + "]");
        }
        return this;
    }

    public void reportDiagnosticSummary() {
        String msg = " stdout: [" + this.getStdout() + "];\n stderr: [" + this.getStderr() + "]\n exitValue = " + this.getExitValue() + "\n";
        System.err.println(msg);
    }

    public OutputAnalyzer outputTo(PrintStream out) {
        out.println(this.getStdout());
        return this;
    }

    public OutputAnalyzer errorTo(PrintStream out) {
        out.println(this.getStderr());
        return this;
    }

    public String getOutput() {
        return this.getStdout() + this.getStderr();
    }

    public String getStdout() {
        return this.buffer.getStdout();
    }

    public String getStderr() {
        return this.buffer.getStderr();
    }

    public int getExitValue() {
        return this.buffer.getExitValue();
    }

    public long pid() {
        return this.buffer.pid();
    }

    public List<String> asLines() {
        return this.asLines(this.getOutput());
    }

    public List<String> stdoutAsLines() {
        return this.asLines(this.getStdout());
    }

    public List<String> stderrAsLines() {
        return this.asLines(this.getStderr());
    }

    private List<String> asLines(String buffer) {
        return Arrays.asList(buffer.split("\\R"));
    }

    public OutputAnalyzer shouldBeEmptyIgnoreVMWarnings() {
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        if (!stdout.isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stdout was not empty");
        }
        if (!stderr.replaceAll(".* VM warning:.*\\R", "").isEmpty()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("stderr was not empty");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldMatchIgnoreVMWarnings(String pattern) {
        String stderr = this.getStderr().replaceAll(".* VM warning:.*\\R", "");
        Matcher matcher = Pattern.compile(pattern, 8).matcher(stderr);
        if (!matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + pattern + "' missing from stderr");
        }
        return this;
    }

    public OutputAnalyzer stderrShouldMatchIgnoreDeprecatedWarnings(String pattern) {
        String stderr = this.getStderr().replaceAll(".* VM warning:.* deprecated.*\\R", "");
        Matcher matcher = Pattern.compile(pattern, 8).matcher(stderr);
        if (!matcher.find()) {
            this.reportDiagnosticSummary();
            throw new RuntimeException("'" + pattern + "' missing from stderr");
        }
        return this;
    }

    public List<String> asLinesWithoutVMWarnings() {
        return Arrays.stream(this.getOutput().split("\\R")).filter(Pattern.compile(jvmwarningmsg).asPredicate().negate()).collect(Collectors.toList());
    }

    public OutputAnalyzer shouldMatchByLine(String pattern) {
        return this.shouldMatchByLine(null, null, pattern);
    }

    public OutputAnalyzer stdoutShouldMatchByLine(String pattern) {
        return this.stdoutShouldMatchByLine(null, null, pattern);
    }

    public OutputAnalyzer shouldMatchByLineFrom(String fromPattern, String pattern) {
        return this.shouldMatchByLine(fromPattern, null, pattern);
    }

    public OutputAnalyzer shouldMatchByLineTo(String toPattern, String pattern) {
        return this.shouldMatchByLine(null, toPattern, pattern);
    }

    public OutputAnalyzer shouldMatchByLine(String fromPattern, String toPattern, String pattern) {
        return this.shouldMatchByLine(this.getOutput(), fromPattern, toPattern, pattern);
    }

    public OutputAnalyzer stdoutShouldMatchByLine(String fromPattern, String toPattern, String pattern) {
        return this.shouldMatchByLine(this.getStdout(), fromPattern, toPattern, pattern);
    }

    private OutputAnalyzer shouldMatchByLine(String buffer, String fromPattern, String toPattern, String pattern) {
        List<String> lines = this.asLines(buffer);
        int fromIndex = 0;
        if (fromPattern != null) {
            fromIndex = this.indexOf(lines, fromPattern, 0) + 1;
            Asserts.assertGreaterThan(fromIndex, 0, "The line matched with pattern '" + fromPattern + "' from where the output should match can not be found");
        }
        int toIndex = lines.size();
        if (toPattern != null) {
            toIndex = this.indexOf(lines, toPattern, fromIndex);
            Asserts.assertGreaterThan(toIndex, fromIndex, "The line matched with pattern '" + toPattern + "' until where the output should match can not be found");
        }
        List<String> subList = lines.subList(fromIndex, toIndex);
        Asserts.assertFalse(subList.isEmpty(), "There are no lines to check: range " + fromIndex + ".." + toIndex + ", subList = " + String.valueOf(subList));
        subList.stream().filter(Pattern.compile(pattern).asPredicate().negate()).findAny().ifPresent(line -> Asserts.fail("The line '" + line + "' does not match pattern '" + pattern + "'"));
        return this;
    }

    private int indexOf(List<String> lines, String regexp, int fromIndex) {
        Pattern pattern = Pattern.compile(regexp);
        for (int i = fromIndex; i < lines.size(); ++i) {
            if (!pattern.matcher(lines.get(i)).matches()) continue;
            return i;
        }
        return -1;
    }

    private void searchLinesForMultiLinePattern(String[] haystack, String[] needles, boolean verbose) {
        int i;
        if (needles.length == 0) {
            return;
        }
        int firstNeedlePos = 0;
        for (i = 0; i < haystack.length; ++i) {
            if (verbose) {
                System.out.println(i + ":" + haystack[i]);
            }
            if (!haystack[i].contains(needles[0])) continue;
            if (verbose) {
                System.out.println("Matches pattern 0 (\"" + needles[0] + "\")");
            }
            firstNeedlePos = i;
            break;
        }
        for (i = 1; i < needles.length; ++i) {
            int haystackPos = firstNeedlePos + i;
            if (haystackPos >= haystack.length) continue;
            if (verbose) {
                System.out.println(haystackPos + ":" + haystack[haystackPos]);
            }
            if (haystack[haystackPos].contains(needles[i])) {
                if (!verbose) continue;
                System.out.println("Matches pattern " + i + "(\"" + needles[i] + "\")");
                continue;
            }
            String err = "First unmatched pattern: " + i + " (\"" + needles[i] + "\")";
            if (!verbose) {
                this.reportDiagnosticSummary();
            }
            throw new RuntimeException(err);
        }
    }

    public void stdoutShouldContainMultiLinePattern(String[] needles, boolean verbose) {
        String[] stdoutLines = this.stdoutAsLines().toArray(new String[0]);
        this.searchLinesForMultiLinePattern(stdoutLines, needles, verbose);
    }

    public void stdoutShouldContainMultiLinePattern(String ... needles) {
        this.stdoutShouldContainMultiLinePattern(needles, true);
    }

    public void stderrShouldContainMultiLinePattern(String[] needles, boolean verbose) {
        String[] stderrLines = this.stdoutAsLines().toArray(new String[0]);
        this.searchLinesForMultiLinePattern(stderrLines, needles, verbose);
    }

    public void stderrShouldContainMultiLinePattern(String ... needles) {
        this.stderrShouldContainMultiLinePattern(needles, true);
    }

    public void shouldContainMultiLinePattern(String[] needles, boolean verbose) {
        String[] lines = this.asLines().toArray(new String[0]);
        this.searchLinesForMultiLinePattern(lines, needles, verbose);
    }

    public void shouldContainMultiLinePattern(String ... needles) {
        this.shouldContainMultiLinePattern(needles, true);
    }

    public void shouldNotHaveFatalError() {
        this.shouldNotMatch(FATAL_ERROR_PAT);
    }
}

