/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;

public class VThreadRunner {
    public static final int NO_INHERIT_THREAD_LOCALS = 4;

    private VThreadRunner() {
    }

    public static <X extends Throwable> void run(String name, int characteristics, ThrowingRunnable<X> task) throws X {
        AtomicReference throwableRef = new AtomicReference();
        Runnable target = () -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                throwableRef.set(ex);
            }
        };
        Thread.Builder.OfVirtual builder = Thread.ofVirtual();
        if (name != null) {
            builder.name(name);
        }
        if ((characteristics & 4) != 0) {
            builder.inheritInheritableThreadLocals(false);
        }
        Thread thread = builder.start(target);
        try {
            while (!thread.join(Duration.ofSeconds(10L))) {
                System.out.println("-- " + String.valueOf(thread) + " --");
                for (StackTraceElement e : thread.getStackTrace()) {
                    System.out.println("  " + String.valueOf(e));
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Throwable ex = (Throwable)throwableRef.get();
        if (ex != null) {
            if (ex instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)ex;
                throw e;
            }
            if (ex instanceof Error) {
                Error e = (Error)ex;
                throw e;
            }
            throw ex;
        }
    }

    public static <X extends Throwable> void run(String name, ThrowingRunnable<X> task) throws X {
        VThreadRunner.run(name, 0, task);
    }

    public static <X extends Throwable> void run(int characteristics, ThrowingRunnable<X> task) throws X {
        VThreadRunner.run(null, characteristics, task);
    }

    public static <X extends Throwable> void run(ThrowingRunnable<X> task) throws X {
        VThreadRunner.run(null, 0, task);
    }

    private static ForkJoinPool defaultScheduler() {
        try {
            Class<?> clazz = Class.forName("java.lang.VirtualThread");
            Field field = clazz.getDeclaredField("DEFAULT_SCHEDULER");
            field.setAccessible(true);
            return (ForkJoinPool)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int setParallelism(int size) {
        return VThreadRunner.defaultScheduler().setParallelism(size);
    }

    public static int ensureParallelism(int size) {
        ForkJoinPool pool = VThreadRunner.defaultScheduler();
        int parallelism = pool.getParallelism();
        if (size > parallelism) {
            pool.setParallelism(size);
        }
        return parallelism;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<X extends Throwable> {
        public void run() throws X;
    }
}

