/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Model;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.collect.CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Maven30CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.internal.MavenDependencyCollector;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;

class Maven30DependencyCollector
implements MavenDependencyCollector {
    private final RepositorySystem repositorySystem;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> aetherRepositories;

    Maven30DependencyCollector(RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, RepositorySystemSession session, List<RemoteRepository> aetherRepositories) {
        this.repositorySystem = repositorySystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.aetherRepositories = aetherRepositories;
    }

    private static Dependency toDependency(org.apache.maven.model.Dependency mavenDependency, ArtifactTypeRegistry typeRegistry) throws DependencyCollectorException {
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{mavenDependency, typeRegistry};
        return (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }

    @Override
    public CollectorResult collectDependencies(org.apache.maven.model.Dependency root) throws DependencyCollectorException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, this.artifactHandlerManager);
        CollectRequest request = new CollectRequest();
        request.setRoot(Maven30DependencyCollector.toDependency(root, typeRegistry));
        return this.collectDependencies(request);
    }

    @Override
    public CollectorResult collectDependencies(DependableCoordinate root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getType());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), root.getClassifier(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new Dependency((Artifact)aetherArtifact, null));
        return this.collectDependencies(request);
    }

    @Override
    public CollectorResult collectDependencies(Model root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new Dependency((Artifact)aetherArtifact, null));
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, this.artifactHandlerManager);
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(root.getDependencies().size());
        for (org.apache.maven.model.Dependency mavenDependency : root.getDependencies()) {
            aetherDependencies.add(Maven30DependencyCollector.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        if (root.getDependencyManagement() != null) {
            ArrayList<Dependency> aetherManagerDependencies = new ArrayList<Dependency>(root.getDependencyManagement().getDependencies().size());
            for (org.apache.maven.model.Dependency mavenDependency : root.getDependencyManagement().getDependencies()) {
                aetherManagerDependencies.add(Maven30DependencyCollector.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.collectDependencies(request);
    }

    private CollectorResult collectDependencies(CollectRequest request) throws DependencyCollectorException {
        request.setRepositories(this.aetherRepositories);
        try {
            return new Maven30CollectorResult(this.repositorySystem.collectDependencies(this.session, request));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }
}

