/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CommentStrategy;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvReader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecord;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecordHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.FieldModifier;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.NamedCsvRecordHandler;
import org.junit.platform.commons.util.Preconditions;

class CsvReaderFactory {
    private static final String DEFAULT_DELIMITER = ",";
    private static final char EMPTY_CHAR = '\u0000';
    private static final boolean SKIP_EMPTY_LINES = true;
    private static final boolean TRIM_WHITESPACES_AROUND_QUOTES = true;
    private static final boolean ALLOW_EXTRA_FIELDS = true;
    private static final boolean ALLOW_MISSING_FIELDS = true;
    private static final boolean ALLOW_DUPLICATE_HEADER_FIELDS = true;
    private static final int MAX_FIELDS = 512;
    private static final int MAX_RECORD_SIZE = Integer.MAX_VALUE;

    static void validate(CsvSource csvSource) {
        CsvReaderFactory.validateMaxCharsPerColumn(csvSource.maxCharsPerColumn());
        CsvReaderFactory.validateDelimiter(csvSource.delimiter(), csvSource.delimiterString(), csvSource);
    }

    static void validate(CsvFileSource csvFileSource) {
        CsvReaderFactory.validateMaxCharsPerColumn(csvFileSource.maxCharsPerColumn());
        CsvReaderFactory.validateDelimiter(csvFileSource.delimiter(), csvFileSource.delimiterString(), csvFileSource);
    }

    private static void validateMaxCharsPerColumn(int maxCharsPerColumn) {
        Preconditions.condition((maxCharsPerColumn > 0 || maxCharsPerColumn == -1 ? 1 : 0) != 0, () -> "maxCharsPerColumn must be a positive number or -1: " + maxCharsPerColumn);
    }

    private static void validateDelimiter(char delimiter, String delimiterString, Annotation annotation) {
        Preconditions.condition((delimiter == '\u0000' || delimiterString.isEmpty() ? 1 : 0) != 0, () -> "The delimiter and delimiterString attributes cannot be set simultaneously in " + String.valueOf(annotation));
    }

    static CsvReader<? extends CsvRecord> createReaderFor(CsvSource csvSource, String data) {
        String delimiter = CsvReaderFactory.selectDelimiter(csvSource.delimiter(), csvSource.delimiterString());
        CommentStrategy commentStrategy = csvSource.textBlock().isEmpty() ? CommentStrategy.NONE : CommentStrategy.SKIP;
        CsvReaderFactory.validateControlCharactersDiffer(delimiter, csvSource.quoteCharacter(), csvSource.commentCharacter(), commentStrategy);
        CsvReader.CsvReaderBuilder builder = CsvReader.builder().skipEmptyLines(true).trimWhitespacesAroundQuotes(true).allowExtraFields(true).allowMissingFields(true).fieldSeparator(delimiter).quoteCharacter(csvSource.quoteCharacter()).commentStrategy(commentStrategy).commentCharacter(csvSource.commentCharacter());
        CsvCallbackHandler<? extends CsvRecord> callbackHandler = CsvReaderFactory.createCallbackHandler(csvSource.emptyValue(), Set.of(csvSource.nullValues()), csvSource.ignoreLeadingAndTrailingWhitespace(), csvSource.maxCharsPerColumn(), csvSource.useHeadersInDisplayName());
        return builder.build(callbackHandler, data);
    }

    static CsvReader<? extends CsvRecord> createReaderFor(CsvFileSource csvFileSource, InputStream inputStream, Charset charset) {
        String delimiter = CsvReaderFactory.selectDelimiter(csvFileSource.delimiter(), csvFileSource.delimiterString());
        CommentStrategy commentStrategy = CommentStrategy.SKIP;
        CsvReaderFactory.validateControlCharactersDiffer(delimiter, csvFileSource.quoteCharacter(), csvFileSource.commentCharacter(), commentStrategy);
        CsvReader.CsvReaderBuilder builder = CsvReader.builder().skipEmptyLines(true).trimWhitespacesAroundQuotes(true).allowExtraFields(true).allowMissingFields(true).fieldSeparator(delimiter).quoteCharacter(csvFileSource.quoteCharacter()).commentStrategy(commentStrategy).commentCharacter(csvFileSource.commentCharacter());
        CsvCallbackHandler<? extends CsvRecord> callbackHandler = CsvReaderFactory.createCallbackHandler(csvFileSource.emptyValue(), Set.of(csvFileSource.nullValues()), csvFileSource.ignoreLeadingAndTrailingWhitespace(), csvFileSource.maxCharsPerColumn(), csvFileSource.useHeadersInDisplayName());
        return builder.build(callbackHandler, inputStream, charset);
    }

    private static String selectDelimiter(char delimiter, String delimiterString) {
        if (delimiter != '\u0000') {
            return String.valueOf(delimiter);
        }
        if (!delimiterString.isEmpty()) {
            return delimiterString;
        }
        return DEFAULT_DELIMITER;
    }

    private static void validateControlCharactersDiffer(String delimiter, char quoteCharacter, char commentCharacter, CommentStrategy commentStrategy) {
        if (commentStrategy == CommentStrategy.NONE) {
            Preconditions.condition((boolean)CsvReaderFactory.stringValuesUnique(delimiter, Character.valueOf(quoteCharacter)), () -> "delimiter or delimiterString: '%s' and quoteCharacter: '%s' must differ".formatted(delimiter, Character.valueOf(quoteCharacter)));
        } else {
            Preconditions.condition((boolean)CsvReaderFactory.stringValuesUnique(delimiter, Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter)), () -> "delimiter or delimiterString: '%s', quoteCharacter: '%s', and commentCharacter: '%s' must all differ".formatted(delimiter, Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter)));
        }
    }

    private static boolean stringValuesUnique(Object ... values) {
        long uniqueCount = Stream.of(values).map(String::valueOf).distinct().count();
        return uniqueCount == (long)values.length;
    }

    private static CsvCallbackHandler<? extends CsvRecord> createCallbackHandler(String emptyValue, Set<String> nullValues, boolean ignoreLeadingAndTrailingWhitespaces, int maxCharsPerColumn, boolean useHeadersInDisplayName) {
        int maxFieldSize = maxCharsPerColumn == -1 ? Integer.MAX_VALUE : maxCharsPerColumn;
        DefaultFieldModifier modifier = new DefaultFieldModifier(emptyValue, nullValues, ignoreLeadingAndTrailingWhitespaces);
        if (useHeadersInDisplayName) {
            return ((NamedCsvRecordHandler.NamedCsvRecordHandlerBuilder)((NamedCsvRecordHandler.NamedCsvRecordHandlerBuilder)((NamedCsvRecordHandler.NamedCsvRecordHandlerBuilder)((NamedCsvRecordHandler.NamedCsvRecordHandlerBuilder)NamedCsvRecordHandler.builder().allowDuplicateHeaderFields(true).maxFields(512)).maxRecordSize(Integer.MAX_VALUE)).maxFieldSize(maxFieldSize)).fieldModifier(modifier)).build();
        }
        return ((CsvRecordHandler.CsvRecordHandlerBuilder)((CsvRecordHandler.CsvRecordHandlerBuilder)((CsvRecordHandler.CsvRecordHandlerBuilder)((CsvRecordHandler.CsvRecordHandlerBuilder)CsvRecordHandler.builder().maxFields(512)).maxRecordSize(Integer.MAX_VALUE)).maxFieldSize(maxFieldSize)).fieldModifier(modifier)).build();
    }

    private CsvReaderFactory() {
    }

    record DefaultFieldModifier(String emptyValue, Set<String> nullValues, boolean ignoreLeadingAndTrailingWhitespaces) implements FieldModifier
    {
        static final String NULL_MARKER = "<null marker: %s>".formatted(UUID.randomUUID());

        @Override
        public String modify(long unusedStartingLineNumber, int unusedFieldIdx, boolean quoted, String field) {
            String modifiedField;
            if (quoted && field.isEmpty() && !this.emptyValue.isEmpty()) {
                return this.emptyValue;
            }
            if (!quoted && field.isBlank()) {
                return NULL_MARKER;
            }
            String string = modifiedField = !quoted && this.ignoreLeadingAndTrailingWhitespaces ? field.trim() : field;
            if (this.nullValues.contains(modifiedField)) {
                return NULL_MARKER;
            }
            return modifiedField;
        }
    }
}

