/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.security.impl;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.lm.security.LMFilter;
import org.eclipse.emf.cdo.lm.security.LMSecurityPackage;
import org.eclipse.emf.cdo.security.impl.PermissionFilterImpl;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.cdo.security.util.AuthorizationContext;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;

public abstract class LMFilterImpl
extends PermissionFilterImpl
implements LMFilter {
    protected static final boolean REGEX_EDEFAULT = false;
    private transient Pattern pattern;
    private transient int lastVersion;

    protected LMFilterImpl() {
    }

    protected EClass eStaticClass() {
        return LMSecurityPackage.Literals.LM_FILTER;
    }

    @Override
    public boolean isRegex() {
        return (Boolean)this.eDynamicGet(0, (EStructuralFeature)LMSecurityPackage.Literals.LM_FILTER__REGEX, true, true);
    }

    @Override
    public void setRegex(boolean newRegex) {
        this.eDynamicSet(0, (EStructuralFeature)LMSecurityPackage.Literals.LM_FILTER__REGEX, newRegex);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isRegex();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRegex((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRegex(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isRegex();
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean isImpacted(PermissionImpl.CommitImpactContext context) {
        return false;
    }

    public String format() {
        String operator = this.isRegex() ? " ~= " : " == ";
        String result = this.getComparisonKey() + operator + this.getComparisonValue();
        if (this.filterMissingComparisonValue()) {
            result = "Or(" + result + ", " + this.getComparisonKey() + " == null)";
        }
        return result;
    }

    protected final boolean filter(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, int level) throws Exception {
        Map authorizationContext = AuthorizationContext.get();
        if (authorizationContext == null) {
            return false;
        }
        String actualComparisonValue = (String)authorizationContext.get(this.getComparisonKey());
        if (StringUtil.isEmpty((String)actualComparisonValue)) {
            return this.filterMissingComparisonValue();
        }
        String expectedComparisonValue = this.getComparisonValue();
        if (this.isRegex()) {
            Pattern pattern = this.getPattern(expectedComparisonValue);
            return pattern.matcher(actualComparisonValue).matches();
        }
        return Objects.equals(actualComparisonValue, expectedComparisonValue);
    }

    protected boolean filterMissingComparisonValue() {
        return false;
    }

    protected abstract String getComparisonKey();

    protected abstract String getComparisonValue();

    private Pattern getPattern(String expectedComparisonValue) {
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null) {
            int currentVersion = revision.getVersion();
            if (currentVersion > this.lastVersion) {
                this.pattern = null;
                this.lastVersion = currentVersion;
            }
            if (this.pattern != null) {
                return this.pattern;
            }
        }
        this.pattern = Pattern.compile(expectedComparisonValue);
        return this.pattern;
    }
}

