/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.tabs;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.control.ITerminalListener;
import org.eclipse.terminal.control.TerminalTitleRequestor;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.internal.tabs.TabCommandFieldHandler;
import org.eclipse.terminal.view.ui.internal.tabs.TabFolderManager;

public class TabTerminalListener
implements ITerminalListener {
    private static final String TAB_TERMINAL_LISTENER = "TabTerminalListener";
    final TabFolderManager tabFolderManager;
    private CTabItem tabItem;
    private String tabItemTitle;
    private TerminalState state;

    static void move(CTabItem fromItem, CTabItem toItem) {
        TabTerminalListener listener = (TabTerminalListener)fromItem.getData(TAB_TERMINAL_LISTENER);
        if (listener != null) {
            listener.attachTo(toItem);
        }
    }

    public TabTerminalListener(TabFolderManager tabFolderManager, CTabItem tabItem) {
        Assert.isNotNull((Object)((Object)tabFolderManager));
        Assert.isNotNull((Object)tabItem);
        this.tabFolderManager = tabFolderManager;
        this.tabItemTitle = tabItem.getText();
        this.attachTo(tabItem);
    }

    private void attachTo(CTabItem item) {
        if (this.tabItem != null) {
            this.tabItem.setData(TAB_TERMINAL_LISTENER, null);
        }
        item.setData(TAB_TERMINAL_LISTENER, (Object)this);
        this.tabItem = item;
    }

    protected final CTabItem getTabItem() {
        return this.tabItem;
    }

    public void setState(TerminalState state) {
        this.state = state;
        this.updateTitle(null, TerminalTitleRequestor.OTHER);
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return;
        }
        item.getDisplay().asyncExec(() -> {
            TabCommandFieldHandler handler = this.tabFolderManager.getTabCommandFieldHandler(item);
            if (TerminalState.CLOSED.equals((Object)state) && handler != null && handler.hasCommandInputField()) {
                handler.setCommandInputField(false);
                ISelectionProvider provider = this.tabFolderManager.getParentView().getViewSite().getSelectionProvider();
                Assert.isNotNull((Object)provider);
                provider.setSelection(provider.getSelection());
            } else {
                this.tabFolderManager.updateStatusLine();
            }
        });
    }

    private void updateTitle(String title, TerminalTitleRequestor requestor) {
        if (this.state == null) {
            return;
        }
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return;
        }
        item.getDisplay().asyncExec(() -> {
            String newTitle;
            Boolean disableAnsi;
            Object v;
            if (item.isDisposed()) {
                return;
            }
            Map properties = (Map)item.getData("properties");
            if (properties != null && (v = properties.get("titleDisableAnsiTitle")) instanceof Boolean && (disableAnsi = (Boolean)v).booleanValue() && requestor == TerminalTitleRequestor.ANSI) {
                return;
            }
            if (title != null) {
                this.tabItemTitle = title;
            }
            if ((newTitle = this.getTerminalConsoleTabTitle(this.state)) != null) {
                item.setText(newTitle);
            }
        });
    }

    protected String getTerminalConsoleTabTitle(TerminalState state) {
        Assert.isNotNull((Object)state);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return null;
        }
        String oldTitle = item.getText();
        String newTitle = null;
        if (TerminalState.CLOSED.equals((Object)state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleClosed, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTING.equals((Object)state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleConnecting, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTED.equals((Object)state)) {
            newTitle = this.tabItemTitle;
        }
        return newTitle != null && !newTitle.equals(oldTitle) ? newTitle : null;
    }

    public void setTerminalTitle(String title, TerminalTitleRequestor requestor) {
        this.updateTitle(title, requestor);
    }

    public void setTerminalSelectionChanged() {
        this.tabFolderManager.fireTerminalSelectionChanged();
    }
}

