/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Objects;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.configuration.BaseRunConfigurationProperties;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;

public class AbstractRunConfiguration<T extends BaseRunConfigurationProperties> {
    protected final ProjectConfiguration projectConfiguration;
    protected final T properties;

    public AbstractRunConfiguration(ProjectConfiguration projectConfiguration, T properties) {
        this.projectConfiguration = projectConfiguration;
        this.properties = properties;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    T getProperties() {
        return this.properties;
    }

    public GradleDistribution getGradleDistribution() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).getGradleDistribution();
        }
        return this.projectConfiguration.getBuildConfiguration().getGradleDistribution();
    }

    public File getGradleUserHome() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).getGradleUserHome();
        }
        return this.projectConfiguration.getBuildConfiguration().getGradleUserHome();
    }

    public File getJavaHome() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).getJavaHome();
        }
        return this.projectConfiguration.getBuildConfiguration().getJavaHome();
    }

    public List<String> getJvmArguments() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).getJvmArguments();
        }
        return this.projectConfiguration.getBuildConfiguration().getJvmArguments();
    }

    public List<String> getArguments() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).getArguments();
        }
        return this.projectConfiguration.getBuildConfiguration().getArguments();
    }

    private boolean isBuildScansEnabled() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).isBuildScansEnabled();
        }
        return this.projectConfiguration.getBuildConfiguration().isBuildScansEnabled();
    }

    private boolean isOfflineMode() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).isOfflineMode();
        }
        return this.projectConfiguration.getBuildConfiguration().isOfflineMode();
    }

    public boolean isShowExecutionView() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).isShowExecutionView();
        }
        return this.projectConfiguration.getBuildConfiguration().isShowExecutionsView();
    }

    public boolean isShowConsoleView() {
        if (((BaseRunConfigurationProperties)this.properties).isOverrideBuildSettings()) {
            return ((BaseRunConfigurationProperties)this.properties).isShowConsoleView();
        }
        return this.projectConfiguration.getBuildConfiguration().isShowConsoleView();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractRunConfiguration) {
            AbstractRunConfiguration other = (AbstractRunConfiguration)obj;
            return Objects.equal((Object)this.projectConfiguration, (Object)other.projectConfiguration) && Objects.equal(this.properties, other.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectConfiguration, this.properties});
    }

    public GradleArguments toGradleArguments() {
        return GradleArguments.from(this.getProjectConfiguration().getProjectDir(), this.getGradleDistribution(), this.getGradleUserHome(), this.getJavaHome(), this.isBuildScansEnabled(), this.isOfflineMode(), this.getArguments(), this.getJvmArguments());
    }
}

