/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.ui;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.internal.core.Homebrew;
import org.eclipse.cdt.internal.core.MinGW;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.gnu.cygwin.GnuCygwinConfigurationEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.gnu.macos.MacosEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.gnu.mingw.MingwEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.llvm.ui.LlvmBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.llvm.ui.preferences.LlvmPreferenceStore;
import org.eclipse.cdt.managedbuilder.llvm.util.Separators;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class LlvmEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean preferencesChanged = true;
    private static HashMap<String, LlvmBuildEnvironmentVariable> llvmEnvironmentVariables = new HashMap(7);
    private static final String ENV_VAR_NAME_LLVM_BIN = "LLVM_BIN_PATH";
    private static final String ENV_VAR_NAME_LLVMINTERP = "LLVMINTERP";
    private static final String ENV_VAR_NAME_PATH = "PATH";
    private static final String ENV_VAR_NAME_INCLUDE_PATH = "INCLUDE_PATH";
    private static final String ENV_VAR_NAME_LIBRARY_PATH = "LLVM_LIB_SEARCH_PATH";
    private static final String ENV_VAR_NAME_LIBRARIES = "LIBRARIES";
    private static final List<String> LLVM_BIN_SELECTION_TOOLS = List.of("llvm-ar", "clang");
    private static boolean isInitialized = false;

    public static void initializePaths() {
        String binPath = LlvmEnvironmentVariableSupplier.getBinPath();
        LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariableReplace(ENV_VAR_NAME_LLVM_BIN, binPath);
        if (binPath != null && binPath.length() != 0) {
            IBuildEnvironmentVariable macosPath;
            Object pathStr = binPath;
            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                try {
                    IBuildEnvironmentVariable envPath = llvmEnvironmentVariables.get(ENV_VAR_NAME_PATH);
                    IBuildEnvironmentVariable mingwPath = null;
                    IBuildEnvironmentVariable cygwinPath = null;
                    MingwEnvironmentVariableSupplier mingwEnvironmentVariables = new MingwEnvironmentVariableSupplier();
                    mingwPath = mingwEnvironmentVariables.getVariable(ENV_VAR_NAME_PATH, null, null);
                    GnuCygwinConfigurationEnvironmentSupplier cygwinEnvironmentVariables = new GnuCygwinConfigurationEnvironmentSupplier();
                    cygwinPath = cygwinEnvironmentVariables.getVariable(ENV_VAR_NAME_PATH, null, null);
                    if (mingwPath != null) {
                        pathStr = (String)pathStr + System.getProperty("path.separator") + mingwPath.getValue();
                    }
                    if (cygwinPath != null) {
                        pathStr = (String)pathStr + System.getProperty("path.separator") + cygwinPath.getValue();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("macosx".equals(Platform.getOS()) && (macosPath = new MacosEnvironmentVariableSupplier().getVariable(ENV_VAR_NAME_PATH, null, null)) != null) {
                LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable("HOMEBREW_HOME", Homebrew.getHomebrewHome());
                pathStr = (String)pathStr + File.pathSeparator + macosPath.getValue();
            }
            LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable(ENV_VAR_NAME_PATH, (String)pathStr);
            LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable(ENV_VAR_NAME_LLVMINTERP, binPath + Separators.getFileSeparator() + "lli");
            LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable(ENV_VAR_NAME_INCLUDE_PATH, LlvmEnvironmentVariableSupplier.getSysEnvPath(ENV_VAR_NAME_INCLUDE_PATH));
            LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARY_PATH, LlvmEnvironmentVariableSupplier.getSysEnvPath(ENV_VAR_NAME_LIBRARY_PATH));
            LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARIES, LlvmEnvironmentVariableSupplier.getSysEnvPath(ENV_VAR_NAME_LIBRARIES));
            preferencesChanged = false;
        }
    }

    public static String getBinPath() {
        return LlvmEnvironmentVariableSupplier.findBinDir(ENV_VAR_NAME_LLVM_BIN, "bin");
    }

    public static String getIncludePath() {
        return LlvmEnvironmentVariableSupplier.getLlvmEnvironmentVariable(ENV_VAR_NAME_INCLUDE_PATH).getValue();
    }

    public static String getLibraryPath() {
        return LlvmEnvironmentVariableSupplier.getLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARY_PATH).getValue();
    }

    public static String getLibraries() {
        return LlvmEnvironmentVariableSupplier.getLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARIES).getValue();
    }

    public static void setBinPath(String path) {
        LlvmEnvironmentVariableSupplier.setLlvmEnvironmentVariableReplace(ENV_VAR_NAME_LLVM_BIN, path);
    }

    public static void addIncludePath(String path) {
        String existingIncPaths = LlvmEnvironmentVariableSupplier.getIncludePath();
        if (!existingIncPaths.contains(path)) {
            LlvmEnvironmentVariableSupplier.appendLlvmEnvironmentVariable(ENV_VAR_NAME_INCLUDE_PATH, existingIncPaths, path);
        }
    }

    public static void addLibraryPath(String path) {
        String existingLibPaths = LlvmEnvironmentVariableSupplier.getLibraryPath();
        if (!existingLibPaths.contains(path)) {
            LlvmEnvironmentVariableSupplier.appendLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARY_PATH, existingLibPaths, path);
        }
    }

    public static void addLibrary(String lib) {
        String existingLibs = LlvmEnvironmentVariableSupplier.getLibraries();
        if (!existingLibs.contains(lib)) {
            LlvmEnvironmentVariableSupplier.appendLlvmEnvironmentVariable(ENV_VAR_NAME_LIBRARIES, existingLibs, lib);
        }
    }

    public static void notifyPreferenceChange() {
        preferencesChanged = true;
    }

    private static String findBinDir(String pathKey, String subDirName) {
        String resultPath = null;
        if (!preferencesChanged) {
            LlvmBuildEnvironmentVariable earlierValue = llvmEnvironmentVariables.get(pathKey);
            if (earlierValue != null) {
                return earlierValue.getValue();
            }
        } else {
            String preferenceLocation = LlvmPreferenceStore.getBinPath();
            if (preferenceLocation != null && (preferenceLocation = preferenceLocation.trim()).length() != 0 && (resultPath = LlvmEnvironmentVariableSupplier.getDirIfLlvmFound(preferenceLocation, null)) == null) {
                resultPath = LlvmEnvironmentVariableSupplier.getDirIfLlvmFound(preferenceLocation, subDirName);
            }
            if (resultPath == null) {
                String[] paths;
                String pathVariable = System.getenv(ENV_VAR_NAME_PATH);
                String[] stringArray = paths = pathVariable.split(Separators.getPathSeparator());
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String pathStr = stringArray[n2];
                    resultPath = LlvmEnvironmentVariableSupplier.getDirIfLlvmFound(pathStr, null);
                    if (resultPath != null) break;
                    ++n2;
                }
            }
            return resultPath;
        }
        return null;
    }

    private static String getDirIfLlvmFound(String candidatePath, String subPath) {
        Object llvmPath = candidatePath;
        if (((String)llvmPath).endsWith(Separators.getFileSeparator()) && ((String)llvmPath).length() > 1) {
            llvmPath = ((String)llvmPath).substring(0, candidatePath.length() - 1);
        }
        if (subPath != null && !subPath.isEmpty()) {
            llvmPath = (String)llvmPath + Separators.getFileSeparator() + subPath;
        }
        return LlvmEnvironmentVariableSupplier.getBinDirIfLlvm((String)llvmPath);
    }

    /*
     * WARNING - void declaration
     */
    private static String getBinDirIfLlvm(String binPathTemp) {
        if (new Path(binPathTemp).toFile().isDirectory()) {
            for (String string : LLVM_BIN_SELECTION_TOOLS) {
                void var1_2;
                File arFileFullPath = null;
                if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    String string2 = string + ".exe";
                }
                if (!(arFileFullPath = new File(binPathTemp, (String)var1_2)).isFile()) continue;
                return binPathTemp;
            }
        }
        return null;
    }

    @Deprecated
    private static IPath getBinDir() {
        IPath binDir = null;
        String minGWHome = MinGW.getMinGWHome();
        if (minGWHome != null) {
            binDir = new Path(minGWHome).append("bin");
        }
        return binDir;
    }

    public static String getMinGWStdLib() {
        StringBuilder sB;
        IPath mingwBinPath = LlvmEnvironmentVariableSupplier.getBinDir();
        if (mingwBinPath != null && (sB = new StringBuilder(mingwBinPath.toOSString())).length() >= 3) {
            String[] list;
            sB.delete(sB.length() - 3, sB.length());
            sB.append("lib\\gcc\\mingw32\\");
            File f = new File(sB.toString());
            if (f.isDirectory() && (list = f.list()).length > 0) {
                sB.append(list[0]);
                return sB.toString();
            }
        }
        return null;
    }

    public static LlvmBuildEnvironmentVariable getLlvmEnvironmentVariable(String envName) {
        return llvmEnvironmentVariables.get(envName);
    }

    private static void setLlvmEnvironmentVariable(String name, String path) {
        llvmEnvironmentVariables.put(name, new LlvmBuildEnvironmentVariable(name, path, 4));
    }

    public static void setLlvmEnvironmentVariableReplace(String name, String path) {
        llvmEnvironmentVariables.put(name, new LlvmBuildEnvironmentVariable(name, path, 1));
    }

    public static void appendLlvmEnvironmentVariable(String name, String oldPath, String path) {
        String newPath = null;
        boolean ok = false;
        if (oldPath != null && !oldPath.trim().isEmpty()) {
            StringBuilder sB = new StringBuilder();
            sB.append(oldPath);
            sB.append(Separators.getPathSeparator());
            sB.append(path);
            newPath = sB.toString();
            ok = true;
        }
        if (!ok) {
            newPath = path;
        }
        if (newPath != null && !newPath.trim().isEmpty()) {
            llvmEnvironmentVariables.put(name, new LlvmBuildEnvironmentVariable(name, newPath, 4));
        }
    }

    private static String getSysEnvPath(String envName) {
        String path = System.getenv(envName);
        if (path != null) {
            return path;
        }
        return "";
    }

    private static synchronized void init() {
        if (!isInitialized) {
            LlvmEnvironmentVariableSupplier.initializePaths();
            isInitialized = true;
        }
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        LlvmEnvironmentVariableSupplier.init();
        return llvmEnvironmentVariables.get(variableName);
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        LlvmEnvironmentVariableSupplier.init();
        return llvmEnvironmentVariables.values().toArray(new IBuildEnvironmentVariable[0]);
    }
}

