/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.profiling.core.base.FlameWithKernelPalette;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStack;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackHostUtils;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackSymbolFactory;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ProcessStatusInterval;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallGraphAnalysis
extends TmfAbstractAnalysisModule
implements ICallGraphProvider2 {
    public static final String ID = "org.eclipse.tracecompass.analysis.callstack.callgraph";
    static final int SELF_TIME_METRIC_INDEX = 0;
    static final int CPU_TIME_METRIC_INDEX = 1;
    private static final String SELF_TIME_TITLE = Objects.requireNonNull(Messages.CallGraphStats_SelfTime);
    private static final String CPU_TIME_TITLE = Objects.requireNonNull(Messages.CallGraphStats_CpuTime);
    private static final String NB_CALLS_TITLE = Objects.requireNonNull(Messages.CallGraphStats_NbCalls);
    private static final IWeightedTreeProvider.MetricType DURATION_METRIC = new IWeightedTreeProvider.MetricType(Objects.requireNonNull(Messages.CallGraphStats_Duration), IWeightedTreeProvider.DataType.NANOSECONDS, null, true);
    private static final List<IWeightedTreeProvider.MetricType> METRICS = ImmutableList.of((Object)new IWeightedTreeProvider.MetricType(SELF_TIME_TITLE, IWeightedTreeProvider.DataType.NANOSECONDS, null, true), (Object)new IWeightedTreeProvider.MetricType(CPU_TIME_TITLE, IWeightedTreeProvider.DataType.NANOSECONDS, null, true), (Object)new IWeightedTreeProvider.MetricType(NB_CALLS_TITLE, IWeightedTreeProvider.DataType.NUMBER, null, false));
    private final IFlameChartProvider fCsProvider;
    private final CallGraph fCallGraph = new CallGraph();
    private @Nullable Collection<ISymbolProvider> fSymbolProviders = null;
    private boolean fHasKernelStatuses = false;
    private final LoadingCache<TmfTimeRange, CallGraph> fRangeCallgraphs = Objects.requireNonNull(CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<TmfTimeRange, CallGraph>(){

        public CallGraph load(TmfTimeRange range) {
            CallGraph cg = new CallGraph();
            CallGraphAnalysis.this.executeForRange(cg, range, (IProgressMonitor)new NullProgressMonitor());
            return cg;
        }
    }));

    public CallGraphAnalysis(IFlameChartProvider csProvider) {
        this.fCsProvider = csProvider;
        this.setName(NLS.bind((String)Messages.CallGraphAnalysis_NamePrefix, (Object)csProvider.getName()));
    }

    public @NonNull String getHelpText() {
        String msg = Messages.CallGraphAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public void setName(String name) {
        super.setName(NLS.bind((String)Messages.CallGraphAnalysis_NamePrefix, (Object)name));
    }

    public @NonNull String getHelpText(ITmfTrace trace) {
        return this.getHelpText();
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        return this.executeForRange(this.fCallGraph, TmfTimeRange.ETERNITY, monitor);
    }

    private boolean executeForRange(CallGraph callgraph, TmfTimeRange range, @Nullable IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (monitor == null || trace == null) {
            return false;
        }
        IFlameChartProvider callstackModule = this.fCsProvider;
        if (!callstackModule.isComplete()) {
            return false;
        }
        CallStackSeries callstack = callstackModule.getCallStackSeries();
        if (callstack != null) {
            long time0 = range.getStartTime().toNanos();
            long time1 = range.getEndTime().toNanos();
            long start = Math.min(time0, time1);
            long end = Math.max(time0, time1);
            this.iterateOverCallstackSerie(callstack, callgraph, start, end, monitor);
            if (monitor.isCanceled()) {
                return false;
            }
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    @VisibleForTesting
    protected void iterateOverCallstackSerie(CallStackSeries callstackSerie, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        Collection<ICallStackElement> rootElements = callstackSerie.getRootElements();
        for (ICallStackElement element : rootElements) {
            if (monitor.isCanceled()) {
                return;
            }
            IFlameChartProvider callstackModule = this.fCsProvider;
            CallStackHostUtils.IHostIdProvider hostIdProvider = Objects.requireNonNull((CallStackHostUtils.IHostIdProvider)callstackModule.getHostIdResolver().apply(element));
            IHostModel model = ModelManager.getModelFor((String)hostIdProvider.apply(start));
            this.iterateOverElement(element, model, callgraph, start, end, monitor);
        }
    }

    private void iterateOverElement(ICallStackElement element, IHostModel model, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        if (element instanceof InstrumentedCallStackElement && ((InstrumentedCallStackElement)element).isCallStack()) {
            this.iterateOverLeafElement(element, model, callgraph, start, end, monitor);
            if (element.isLeaf()) {
                return;
            }
        }
        for (ICallStackElement child : element.getChildrenElements()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.iterateOverElement(child, model, callgraph, start, end, monitor);
        }
    }

    private void iterateOverLeafElement(ICallStackElement element, IHostModel model, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        if (!(element instanceof InstrumentedCallStackElement)) {
            throw new IllegalStateException("Call Graph Analysis: The element does not have the right type");
        }
        InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
        CallStack callStack = insElement.getCallStack();
        if (callStack.getMaxDepth() == 0) {
            return;
        }
        this.fHasKernelStatuses |= callStack.hasKernelStatuses();
        AbstractCalledFunction nextFunction = (AbstractCalledFunction)callStack.getNextFunction(callStack.getStartTime(), 1, null, model, start, end);
        while (nextFunction != null) {
            if (monitor.isCanceled()) {
                return;
            }
            AggregatedCalledFunction aggregatedChild = this.createCallSite(CallStackSymbolFactory.createSymbol(nextFunction.getSymbol(), element, nextFunction.getStart()));
            this.iterateOverCallstack(element, callStack, nextFunction, 2, aggregatedChild, model, start, end, monitor);
            aggregatedChild.addFunctionCall(nextFunction);
            Iterable<ProcessStatusInterval> kernelStatuses = callStack.getKernelStatuses(nextFunction, Collections.emptyList());
            for (ProcessStatusInterval status : kernelStatuses) {
                aggregatedChild.addKernelStatus(status);
            }
            callgraph.addAggregatedCallSite(element, aggregatedChild);
            nextFunction = (AbstractCalledFunction)callStack.getNextFunction(nextFunction.getEnd(), 1, null, model, start, end);
        }
    }

    private void iterateOverCallstack(ICallStackElement element, CallStack callstack, ICalledFunction function, int nextLevel, AggregatedCalledFunction aggregatedCall, IHostModel model, long start, long end, IProgressMonitor monitor) {
        Collection<AggregatedCallSite> samplingData;
        if (nextLevel > callstack.getMaxDepth()) {
            return;
        }
        int threadId = function.getThreadId();
        long lastSampleEnd = start;
        AbstractCalledFunction nextFunction = (AbstractCalledFunction)callstack.getNextFunction(function.getStart(), nextLevel, function, model, Math.max(function.getStart(), start), Math.min(function.getEnd(), end));
        while (nextFunction != null) {
            if (monitor.isCanceled()) {
                return;
            }
            if (threadId > 0) {
                samplingData = model.getSamplingData(threadId, lastSampleEnd, nextFunction.getStart());
                samplingData.forEach(aggregatedCall::addChild);
                lastSampleEnd = nextFunction.getEnd();
            }
            AggregatedCalledFunction aggregatedChild = this.createCallSite(CallStackSymbolFactory.createSymbol(nextFunction.getSymbol(), element, nextFunction.getStart()));
            this.iterateOverCallstack(element, callstack, nextFunction, nextLevel + 1, aggregatedChild, model, start, end, monitor);
            aggregatedCall.addChild(nextFunction, aggregatedChild);
            nextFunction = (AbstractCalledFunction)callstack.getNextFunction(nextFunction.getEnd(), nextLevel, function, model, Math.max(function.getStart(), start), Math.min(function.getEnd(), end));
        }
        if (threadId > 0) {
            samplingData = model.getSamplingData(threadId, lastSampleEnd, function.getEnd() - lastSampleEnd);
            samplingData.forEach(aggregatedCall::addChild);
        }
    }

    public @Nullable CallStackSeries getSeries() {
        return this.fCsProvider.getCallStackSeries();
    }

    protected void canceling() {
    }

    @Override
    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        return (CallGraph)this.fRangeCallgraphs.getUnchecked((Object)new TmfTimeRange(start, end));
    }

    @Override
    public CallGraph getCallGraph() {
        return this.fCallGraph;
    }

    @Override
    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        ArrayList<IWeightedTreeGroupDescriptor> descriptors = new ArrayList<IWeightedTreeGroupDescriptor>();
        CallStackSeries serie = this.fCsProvider.getCallStackSeries();
        if (serie != null) {
            descriptors.add(serie.getRootGroup());
        }
        return descriptors;
    }

    @Override
    public AggregatedCalledFunction createCallSite(Object symbol) {
        return new AggregatedCalledFunction((ICallStackSymbol)symbol);
    }

    @Override
    public List<String> getExtraDataSets() {
        if (this.fHasKernelStatuses) {
            return Collections.singletonList(String.valueOf(Messages.FlameChartDataProvider_KernelStatusTitle));
        }
        return ICallGraphProvider2.super.getExtraDataSets();
    }

    @Override
    public IWeightedTreeProvider.MetricType getWeightType() {
        return DURATION_METRIC;
    }

    @Override
    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return METRICS;
    }

    @Override
    public String toDisplayString(AggregatedCallSite callsite) {
        Collection symbolProviders = this.fSymbolProviders;
        if (symbolProviders == null) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return String.valueOf(callsite.getObject());
            }
            this.fSymbolProviders = symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
        }
        return ((ICallStackSymbol)callsite.getObject()).resolve(symbolProviders);
    }

    @Override
    public Object getAdditionalMetric(AggregatedCallSite object, int metricIndex) {
        if (object instanceof AggregatedCalledFunction) {
            switch (metricIndex) {
                case 0: {
                    return ((AggregatedCalledFunction)object).getSelfTime();
                }
                case 1: {
                    long cpuTime = ((AggregatedCalledFunction)object).getCpuTime();
                    return cpuTime >= 0L ? cpuTime : 0L;
                }
                case 2: {
                    return ((AggregatedCalledFunction)object).getNbCalls();
                }
            }
            Activator.getInstance().logError("Unknown metric at position " + metricIndex);
        }
        return 0L;
    }

    @Override
    public String getTitle() {
        return Objects.requireNonNull(Messages.CallGraphAnalysis_Title);
    }

    @Override
    public @NonNull IDataPalette getPalette() {
        return FlameWithKernelPalette.getInstance();
    }
}

