/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.model.api.IBreadthFirstJavaElementVisitor;
import org.eclipse.scout.sdk.core.java.model.api.IDepthFirstJavaElementVisitor;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.visitor.DefaultDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.DepthFirstVisitorTypeAdapter;
import org.eclipse.scout.sdk.core.util.visitor.IBreadthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.IDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeTraversals;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public abstract class AbstractJavaElementImplementor<SPI extends JavaElementSpi>
implements IJavaElement {
    protected SPI m_spi;

    protected AbstractJavaElementImplementor(SPI spi) {
        this.m_spi = spi;
    }

    @Override
    public IJavaEnvironment javaEnvironment() {
        return this.m_spi.getJavaEnvironment().wrap();
    }

    @Override
    public String elementName() {
        return this.m_spi.getElementName();
    }

    @Override
    public Optional<SourceRange> source() {
        return Optional.ofNullable(this.m_spi.getSource());
    }

    public SPI unwrap() {
        return this.m_spi;
    }

    public void internalSetSpi(SPI spi) {
        this.m_spi = spi;
    }

    @Override
    public TreeVisitResult visit(Consumer<IJavaElement> visitor) {
        return this.visit((IJavaElement element) -> {
            visitor.accept((IJavaElement)element);
            return TreeVisitResult.CONTINUE;
        });
    }

    @Override
    public <T extends IJavaElement> void visit(Consumer<T> visitor, Class<T> type) {
        this.visit((T element) -> {
            visitor.accept(element);
            return TreeVisitResult.CONTINUE;
        }, type);
    }

    @Override
    public TreeVisitResult visit(Function<IJavaElement, TreeVisitResult> visitor) {
        return this.visit(visitor, IJavaElement.class);
    }

    @Override
    public <T extends IJavaElement> TreeVisitResult visit(Function<T, TreeVisitResult> visitor, Class<T> type) {
        return this.visit((IDepthFirstVisitor<IJavaElement>)new DepthFirstVisitorTypeAdapter(visitor, type));
    }

    @Override
    public TreeVisitResult visit(final IDepthFirstJavaElementVisitor visitor) {
        return this.visit((IDepthFirstVisitor<IJavaElement>)new DefaultDepthFirstVisitor<IJavaElement>(this){

            public TreeVisitResult preVisit(IJavaElement element, int level, int index) {
                return element.unwrap().acceptPreOrder(visitor, level, index);
            }

            public boolean postVisit(IJavaElement element, int level, int index) {
                return element.unwrap().acceptPostOrder(visitor, level, index);
            }
        });
    }

    @Override
    public TreeVisitResult visit(IBreadthFirstJavaElementVisitor visitor) {
        Ensure.notNull((Object)visitor);
        IBreadthFirstVisitor v = (element, level, index) -> element.unwrap().acceptLevelOrder(visitor, level, index);
        return TreeTraversals.create((IBreadthFirstVisitor)v, IJavaElement::children).traverse((Object)this);
    }

    protected TreeVisitResult visit(IDepthFirstVisitor<IJavaElement> visitor) {
        return TreeTraversals.create(visitor, IJavaElement::children).traverse((Object)this);
    }

    public int hashCode() {
        return this.m_spi.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.source().map(SourceRange::asCharSequence).map(CharSequence::toString).orElseGet(() -> this.toWorkingCopy().toSource(JavaSourceBuilder::create, (IBuilderContext)new BuilderContext()).toString());
    }
}

