/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class MavenBuild {
    public static final String GOAL_ARCHETYPE_GENERATE = "archetype:generate";
    public static final char OPTION_DEBUG = 'X';
    public static final char OPTION_UPDATE_SNAPSHOTS = 'U';
    public static final char OPTION_OFFLINE = 'o';
    public static final char OPTION_NON_RECURSIVE = 'N';
    public static final String PROPERTY_INTERACTIVE_MODE = "interactiveMode";
    public static final String PROPERTY_SKIP_TESTS = "skipTests";
    public static final String PROPERTY_SKIP_TEST_CREATION = "maven.test.skip";
    public static final String PROPERTY_ARCHETYPE_GROUP_ID = "archetypeGroupId";
    public static final String PROPERTY_ARCHETYPE_ARTIFACT_ID = "archetypeArtifactId";
    public static final String PROPERTY_ARCHETYPE_VERSION = "archetypeVersion";
    public static final String PROPERTY_PACKAGE = "package";
    private final Set<String> m_goals;
    private final Map<String, String> m_properties = new LinkedHashMap<String, String>();
    private final Set<String> m_options;
    private Path m_workingDirectory;

    public MavenBuild() {
        this.m_goals = new LinkedHashSet<String>();
        this.m_options = new LinkedHashSet<String>();
        this.withProperty("master_coverage_skip", "true").withProperty("master_test_forkCount", "1").withProperty("master_test_runOrder", "filesystem").withProperty("master_cyclonedx_skip", "true").withProperty("master_git-id_skip", "true");
    }

    public static List<String> getMapAsList(Map<String, String> properties) {
        ArrayList<String> props = new ArrayList<String>(properties.size());
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            StringBuilder propBuilder = new StringBuilder(prop.getKey());
            if (prop.getValue() != null) {
                propBuilder.append('=');
                propBuilder.append(prop.getValue());
            }
            props.add(propBuilder.toString());
        }
        return props;
    }

    public Path getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public MavenBuild withWorkingDirectory(Path workingDirectory) {
        this.m_workingDirectory = (Path)Ensure.notNull((Object)workingDirectory);
        return this;
    }

    public Set<String> getOptions() {
        return Collections.unmodifiableSet(this.m_options);
    }

    public boolean hasOption(String option) {
        return this.m_options.contains(option);
    }

    public boolean hasOption(char option) {
        return this.hasOption(Character.toString(option));
    }

    public MavenBuild withOption(char option) {
        return this.withOption(Character.toString(option));
    }

    public MavenBuild withOption(String option) {
        this.m_options.add((String)Ensure.notBlank((CharSequence)option));
        return this;
    }

    public MavenBuild clearOptions() {
        this.m_options.clear();
        return this;
    }

    public Set<String> getGoals() {
        return Collections.unmodifiableSet(this.m_goals);
    }

    public MavenBuild withGoal(String goals) {
        this.m_goals.add(goals);
        return this;
    }

    public MavenBuild clearGoals() {
        this.m_goals.clear();
        return this;
    }

    public List<String> getPropertiesAsList() {
        return MavenBuild.getMapAsList(this.getProperties());
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_properties);
    }

    public MavenBuild clearProperties() {
        this.m_properties.clear();
        return this;
    }

    public MavenBuild withProperty(char property) {
        return this.withProperty(Character.toString(property));
    }

    public MavenBuild withProperty(String noValueProperty) {
        return this.withProperty(noValueProperty, null);
    }

    public MavenBuild withProperty(String key, String value) {
        this.m_properties.put(Strings.trim((CharSequence)Ensure.notBlank((CharSequence)key)).toString(), value);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.m_goals.hashCode();
        result = prime * result + this.m_options.hashCode();
        result = prime * result + this.m_properties.hashCode();
        result = prime * result + (this.m_workingDirectory == null ? 0 : this.m_workingDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenBuild other = (MavenBuild)obj;
        if (!this.m_goals.equals(other.m_goals)) {
            return false;
        }
        if (!this.m_options.equals(other.m_options)) {
            return false;
        }
        if (!this.m_properties.equals(other.m_properties)) {
            return false;
        }
        return Objects.equals(this.m_workingDirectory, other.m_workingDirectory);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Maven build in dir '").append(this.getWorkingDirectory()).append("': ");
        for (String goal : this.getGoals()) {
            builder.append(goal).append(' ');
        }
        for (String option : this.getOptions()) {
            builder.append('-').append(option).append(' ');
        }
        for (String prop : this.getPropertiesAsList()) {
            builder.append("-D").append(prop).append(' ');
        }
        return builder.toString();
    }
}

