/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingArrayTypeWithEcj
extends AbstractTypeWithEcj {
    private static final FieldBinding LENGTH_FIELD = new FieldBinding("length".toCharArray(), (TypeBinding)TypeBinding.INT, 17, null, null);
    private final ArrayBinding m_binding;
    private final boolean m_isWildcard;
    private final int m_arrayDimension;
    private final FinalValue<TypeSpi> m_leafComponentType;
    private final FinalValue<String> m_name;
    private final FinalValue<PackageSpi> m_package;
    private final FinalValue<String> m_elementName;
    private final FinalValue<List<BindingAnnotationWithEcj>> m_annotations;
    private final FinalValue<List<FieldSpi>> m_fields;
    private final Supplier<ArrayBinding> m_newElementLookupStrategy;

    protected BindingArrayTypeWithEcj(AbstractJavaEnvironment env, ArrayBinding binding, boolean isWildcard, Supplier<ArrayBinding> newElementLookupStrategy) {
        super(env);
        this.m_binding = (ArrayBinding)Ensure.notNull((Object)binding);
        this.m_newElementLookupStrategy = (Supplier)Ensure.notNull(newElementLookupStrategy);
        this.m_isWildcard = isWildcard;
        this.m_arrayDimension = binding.dimensions;
        this.m_package = new FinalValue();
        this.m_elementName = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_fields = new FinalValue();
        this.m_leafComponentType = new FinalValue();
        this.m_name = new FinalValue();
    }

    public TypeSpi internalFindNewElement() {
        TypeSpi same = SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), (TypeBinding)this.m_newElementLookupStrategy.get(), this.getDeclaringType(), this.m_isWildcard, this.m_newElementLookupStrategy);
        if (same != null) {
            return same;
        }
        return this.getJavaEnvironment().findType(this.getName());
    }

    protected IType internalCreateApi() {
        return new TypeImplementor((TypeSpi)this);
    }

    public int getArrayDimension() {
        return this.m_arrayDimension;
    }

    private static TypeBinding getLeafComponentTypeBinding(BindingArrayTypeWithEcj t) {
        return t.m_binding.leafComponentType();
    }

    public TypeSpi getLeafComponentType() {
        return (TypeSpi)this.m_leafComponentType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), BindingArrayTypeWithEcj.getLeafComponentTypeBinding(this), () -> (TypeBinding)this.withNewElement(BindingArrayTypeWithEcj::getLeafComponentTypeBinding)));
    }

    public ArrayBinding getInternalBinding() {
        return this.m_binding;
    }

    public CompilationUnitSpi getCompilationUnit() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PackageSpi getPackage() {
        return (PackageSpi)this.m_package.computeIfAbsentAndGet(() -> BindingTypeWithEcj.packageOf((TypeBinding)this.m_binding, this.javaEnvWithEcj()));
    }

    public String getName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> {
            String componentTypeName = this.getLeafComponentType().getName();
            StringBuilder b = new StringBuilder(componentTypeName.length() + 2 * this.m_arrayDimension);
            b.append(componentTypeName);
            b.append(JavaTypes.arrayMarker((int)this.m_arrayDimension));
            return b.toString();
        });
    }

    public String getElementName() {
        return (String)this.m_elementName.computeIfAbsentAndGet(() -> new String(this.m_binding.sourceName()));
    }

    public List<FieldSpi> getFields() {
        return (List)this.m_fields.computeIfAbsentAndGet(() -> Collections.singletonList(this.javaEnvWithEcj().createBindingField(this, LENGTH_FIELD)));
    }

    public List<MethodSpi> getMethods() {
        return Collections.emptyList();
    }

    public List<TypeSpi> getTypes() {
        return Collections.emptyList();
    }

    public BindingTypeWithEcj getDeclaringType() {
        return null;
    }

    public TypeSpi getSuperClass() {
        return null;
    }

    public List<TypeSpi> getSuperInterfaces() {
        return Collections.emptyList();
    }

    public boolean isWildcardType() {
        return this.m_isWildcard;
    }

    public List<TypeSpi> getTypeArguments() {
        return Collections.emptyList();
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    public List<BindingAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createBindingAnnotations((AnnotatableSpi)this, (Binding)this.m_binding));
    }

    public int getFlags() {
        return 0;
    }

    public boolean isAnonymous() {
        return false;
    }

    public SourceRange getSource() {
        return null;
    }

    public SourceRange getSourceOfStaticInitializer() {
        return null;
    }

    public SourceRange getJavaDoc() {
        return null;
    }
}

