/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndicationWithMonitoring;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class DeleteBranchIndication
extends CDOServerReadIndicationWithMonitoring {
    private int branchID;

    public DeleteBranchIndication(CDOServerProtocol protocol) {
        super(protocol, (short)66);
    }

    protected int getIndicatingWorkPercent() {
        return 1;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.branchID = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        InternalCDOBranch branch = branchManager.getBranch(this.branchID);
        CDOBranch[] branches = branch.delete(monitor);
        InternalSession session = this.getSession();
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.sendBranchNotification(session, CDOBranchChangedEvent.ChangeKind.DELETED, branches);
        out.writeXInt(branches.length);
        int i = 0;
        while (i < branches.length) {
            out.writeXInt(branches[i].getID());
            ++i;
        }
    }
}

