/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.CompareDiagramIDEUISiriusPlugin;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExportComparisonDialog
extends Dialog {
    public static final String DIALOG_SETTINGS_ID = "ExportComparisonAsImagesDialog";
    protected static final ImageFileFormat DEFAULT_VALUE = ImageFileFormat.JPG;
    protected static final ImageFileFormat[] SAFE_VALUES = new ImageFileFormat[]{DEFAULT_VALUE, ImageFileFormat.PNG, ImageFileFormat.BMP, ImageFileFormat.GIF};
    protected static final String EMPTY_STRING = "";
    protected static final String IMAGE_FORMAT_LABEL = "&Image Format";
    protected static final String BROWSE_LABEL = "&Browse...";
    protected static final String DIALOG_SETTINGS_IMAGE_FORMAT = "ExportComparisonAsImageDialog.imageFormat";
    protected static final String ACCES_ERROR_MESSAGE = "Access to path is impossible";
    protected static final String FOLDER_NOT_EXIST_MESSAGE = "Folder does not exist";
    private static final String DIALOG_SETTINGS_FOLDER = "ExportComparisonAsImageDialog.folder";
    private static final String DIRECTORY_DIALOG_MESSAGE = "Select the destination folder";
    private static final String DIRECTORY_DIALOG_TEXT = "Select the destination folder";
    private static final String TO_DIRECTORY = "To directory";
    private static final String DIALOG_TITLE = "Export comparison as image file";
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final int HEIGHT_BROWSE_BUTTON = 14;
    private static final int WIDTH_FOLDER_TEXT = 350;
    private static final int WIDTH_MESSAGE = 300;
    protected Combo folderText;
    protected Combo imageFormatCombo;
    protected ImageFileFormat imageFormat;
    protected String folder;
    private Label messageImageLabel;
    private Label messageLabel;

    public ExportComparisonDialog(Shell parentShell) {
        super(parentShell);
        this.initDialogSettings();
    }

    public static ImageFileFormat resolveImageFormat(int ordinal) {
        return SAFE_VALUES[ordinal];
    }

    public static ImageFileFormat resolveImageFormat(String imageFormat) {
        ImageFileFormat[] imageFileFormatArray = SAFE_VALUES;
        int n = SAFE_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().toLowerCase().equals(imageFormat.toLowerCase())) {
                return element;
            }
            ++n2;
        }
        return ExportComparisonDialog.getDefaultImageFormat();
    }

    public static ImageFileFormat getDefaultImageFormat() {
        return ImageFileFormat.JPG;
    }

    public static GridData makeButtonData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        GridData data = new GridData();
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
        data.widthHint = Math.max(Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gc.dispose();
        return data;
    }

    public IPath getOutputPath() {
        return new Path(this.folder);
    }

    public ImageFileFormat getImageFormat() {
        return this.imageFormat;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = CompareDiagramIDEUISiriusPlugin.getDefault().getDialogSettings();
        if ((settings = settings.getSection(DIALOG_SETTINGS_ID)) == null) {
            settings = CompareDiagramIDEUISiriusPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_ID);
        }
        return settings;
    }

    protected void initDialogSettings() {
        String persistentImageFormat;
        String persistentFolder;
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.folder = "/";
        String workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        if (workspace != null && !workspace.equals(EMPTY_STRING)) {
            this.folder = workspace;
        }
        if ((persistentFolder = dialogSettings.get(DIALOG_SETTINGS_FOLDER)) != null) {
            this.folder = persistentFolder;
        }
        this.imageFormat = (persistentImageFormat = dialogSettings.get(DIALOG_SETTINGS_IMAGE_FORMAT)) == null ? ExportComparisonDialog.getDefaultImageFormat() : ExportComparisonDialog.resolveImageFormat(persistentImageFormat);
    }

    protected void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] directoryNames = dialogSettings.getArray(DIALOG_SETTINGS_FOLDER);
            if (directoryNames == null || directoryNames.length == 0) {
                directoryNames = new String[]{this.folder};
            }
            directoryNames = this.addToHistory(directoryNames, this.folder);
            dialogSettings.put(DIALOG_SETTINGS_FOLDER, directoryNames);
            dialogSettings.put(DIALOG_SETTINGS_IMAGE_FORMAT, this.imageFormat.getName());
        }
    }

    protected void okPressed() {
        this.imageFormat = ExportComparisonDialog.resolveImageFormat(this.imageFormatCombo.getSelectionIndex());
        super.okPressed();
        this.saveDialogSettings();
    }

    protected void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setMessage("Select the destination folder");
        dialog.setText("Select the destination folder");
        String dirName = this.folderText.getText();
        if (!dirName.equals(EMPTY_STRING) && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.folderText.setText(selectedDirectory);
        }
    }

    protected void validateFolderText() {
        if (this.folderText.getText().equals(EMPTY_STRING)) {
            this.setDialogErrorState("Folder cannot be blank");
        } else {
            Path path = new Path(EMPTY_STRING);
            if (!path.isValidPath(this.folderText.getText())) {
                this.setDialogErrorState("Folder is not a valid path");
                return;
            }
            File file = new File(this.folderText.getText());
            File directory = file.getParentFile();
            if (file.exists()) {
                if (!file.canWrite()) {
                    this.setDialogErrorState(ACCES_ERROR_MESSAGE);
                    return;
                }
            } else if (directory != null && !directory.canWrite()) {
                this.setDialogErrorState(ACCES_ERROR_MESSAGE);
                return;
            }
            this.folder = this.folderText.getText();
            this.setDialogOKState();
        }
    }

    protected void setDialogErrorState(String message) {
        this.messageLabel.setText(message);
        this.messageImageLabel.setVisible(true);
        this.messageLabel.setVisible(true);
        this.getButton(0).setEnabled(false);
        this.getButton(1).getShell().setDefaultButton(this.getButton(1));
    }

    protected String[] getImageSafeFormatItems() {
        String[] items = new String[SAFE_VALUES.length];
        int i = 0;
        while (i < SAFE_VALUES.length) {
            items[i] = SAFE_VALUES[i].getName();
            ++i;
        }
        return items;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateFolderText();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFolderGroup(composite);
        this.createImageFormatGroup(composite);
        this.createMessageGroup(composite);
        this.initListeners();
        return composite;
    }

    protected void createFolderGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)3, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)TO_DIRECTORY);
        this.folderText = new Combo(composite, 2052);
        this.restoreWidgetValues();
        this.folderText.setText(this.folder);
        GridData gridData = new GridData(768);
        gridData.widthHint = 350;
        this.folderText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(BROWSE_LABEL);
        button.setLayoutData((Object)ExportComparisonDialog.makeButtonData(button));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportComparisonDialog.this.handleBrowseButtonPressed();
            }
        });
    }

    protected void createImageFormatGroup(Composite parent) {
        Label imageFormatControl;
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)2, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)IMAGE_FORMAT_LABEL);
        String[] imageSafeFormatItems = this.getImageSafeFormatItems();
        if (imageSafeFormatItems != null && imageSafeFormatItems.length > 0) {
            if (imageSafeFormatItems.length == 1) {
                imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)imageSafeFormatItems[0]);
            } else {
                this.imageFormatCombo = new Combo(composite, 12);
                this.imageFormatCombo.setItems(imageSafeFormatItems);
                this.imageFormatCombo.setText(this.imageFormat.getName());
                imageFormatControl = this.imageFormatCombo;
            }
        } else {
            imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)DEFAULT_VALUE.getName());
        }
        GridData gridData = new GridData(4, 0x1000000, true, true);
        imageFormatControl.setLayoutData((Object)gridData);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(DIALOG_SETTINGS_FOLDER);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.folder = directoryNames[0];
            String[] stringArray = directoryNames;
            int n = directoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String directoryName = stringArray[n2];
                this.folderText.add(directoryName);
                ++n2;
            }
        }
    }

    private void createMessageGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)2, (boolean)false);
        this.messageImageLabel = new Label(composite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.messageImageLabel.setVisible(false);
        this.messageLabel = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setVisible(false);
    }

    private void setDialogOKState() {
        this.messageImageLabel.setVisible(false);
        this.messageLabel.setVisible(false);
        this.getButton(0).setEnabled(true);
        this.getButton(0).getShell().setDefaultButton(this.getButton(0));
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected void initListeners() {
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportComparisonDialog.this.validateFolderText();
            }
        });
        this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportComparisonDialog.this.imageFormat = ExportComparisonDialog.resolveImageFormat(ExportComparisonDialog.this.imageFormatCombo.getSelectionIndex());
            }
        });
    }
}

