/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.parser.TMParser;
import org.eclipse.tm4e.core.internal.parser.TMParserPropertyPath;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public class TMParserJSON
implements TMParser {
    public static final TMParserJSON INSTANCE = new TMParserJSON();
    private static final Gson LOADER = new Gson();

    private static String removeTrailingCommas(String jsonString) {
        return jsonString.replaceAll("(,)(\\s*\\n(\\s*\\/\\/.*\\n)*\\s*[\\]}])", "$2");
    }

    protected TMParserJSON() {
    }

    protected Map<String, Object> loadRaw(Reader source) {
        String jsonString = TMParserJSON.removeTrailingCommas(new BufferedReader(source).lines().collect(Collectors.joining("\n")));
        return NullSafetyHelper.castNonNull((Map)LOADER.fromJson(jsonString, Map.class));
    }

    @Override
    public final <T extends PropertySettable<?>> T parse(Reader source, TMParser.ObjectFactory<T> factory) {
        Map<String, Object> rawRoot = this.loadRaw(source);
        return this.transform(rawRoot, factory);
    }

    private <T extends PropertySettable<?>> T transform(Map<String, Object> rawRoot, TMParser.ObjectFactory<T> factory) {
        T root = factory.createRoot();
        TMParserPropertyPath path = new TMParserPropertyPath();
        for (Map.Entry<String, Object> e : rawRoot.entrySet()) {
            this.addChild(factory, path, (PropertySettable<?>)root, e.getKey(), e.getValue());
        }
        return root;
    }

    private <T extends PropertySettable<?>> void addChild(TMParser.ObjectFactory<T> handler, TMParserPropertyPath path, PropertySettable<?> parent, Object propertyId, Object rawChild) {
        path.add(propertyId);
        if (rawChild instanceof Map) {
            Map map = (Map)rawChild;
            PropertySettable<Map> transformedChild = handler.createChild(path, Map.class);
            for (Map.Entry e : map.entrySet()) {
                this.addChild(handler, path, transformedChild, e.getKey(), e.getValue());
            }
            this.setProperty(parent, propertyId, transformedChild);
        } else if (rawChild instanceof List) {
            List list = (List)rawChild;
            PropertySettable<List> transformedChild = handler.createChild(path, List.class);
            int i = 0;
            int l = list.size();
            while (i < l) {
                this.addChild(handler, path, transformedChild, i, list.get(i));
                ++i;
            }
            this.setProperty(parent, propertyId, transformedChild);
        } else {
            this.setProperty(parent, propertyId, rawChild);
        }
        path.removeLast();
    }

    private void setProperty(PropertySettable<?> settable, Object propertyId, Object value) {
        settable.setProperty(propertyId.toString(), value);
    }
}

