/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.listeners;

import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;

public abstract class VisualChangeListener {
    private Node observed;
    private HashMap<ChangeListener<Transform>, Node> localToParentTransformListeners = new HashMap();
    private final ChangeListener<? super Bounds> boundsInLocalListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            if (VisualChangeListener.this.isValidBounds(newValue)) {
                VisualChangeListener.this.boundsInLocalChanged(oldValue, newValue);
                VisualChangeListener.this.onBoundsChanged();
            }
        }
    };

    protected abstract void boundsInLocalChanged(Bounds var1, Bounds var2);

    private Node getNearestCommonAncestor(Node source, Node target) {
        if (source == target) {
            return source;
        }
        HashSet<Node> parents = new HashSet<Node>();
        Node m = source;
        Node n = target;
        while (m != null || n != null) {
            if (m != null) {
                if (parents.contains(m)) {
                    return m;
                }
                parents.add(m);
                if (n != null && parents.contains(n)) {
                    return n;
                }
                m = m.getParent();
            }
            if (n == null) continue;
            if (parents.contains(n)) {
                return n;
            }
            parents.add(n);
            if (m != null && parents.contains(m)) {
                return m;
            }
            n = n.getParent();
        }
        return null;
    }

    public boolean isRegistered() {
        return this.observed != null;
    }

    private boolean isValidBounds(Bounds b) {
        if (Double.isNaN(b.getMinX()) || Double.isInfinite(b.getMinX())) {
            return false;
        }
        if (Double.isNaN(b.getMinY()) || Double.isInfinite(b.getMinY())) {
            return false;
        }
        if (Double.isNaN(b.getMaxX()) || Double.isInfinite(b.getMaxX())) {
            return false;
        }
        return !Double.isNaN(b.getMaxY()) && !Double.isInfinite(b.getMaxY());
    }

    private boolean isValidTransform(Transform t) {
        if (Double.isNaN(t.getMxx()) || Double.isInfinite(t.getMxx())) {
            return false;
        }
        if (Double.isNaN(t.getMxy()) || Double.isInfinite(t.getMxy())) {
            return false;
        }
        if (Double.isNaN(t.getMxz()) || Double.isInfinite(t.getMxz())) {
            return false;
        }
        if (Double.isNaN(t.getMyx()) || Double.isInfinite(t.getMyx())) {
            return false;
        }
        if (Double.isNaN(t.getMyy()) || Double.isInfinite(t.getMyy())) {
            return false;
        }
        if (Double.isNaN(t.getMyz()) || Double.isInfinite(t.getMyz())) {
            return false;
        }
        if (Double.isNaN(t.getMzx()) || Double.isInfinite(t.getMzx())) {
            return false;
        }
        if (Double.isNaN(t.getMzy()) || Double.isInfinite(t.getMzy())) {
            return false;
        }
        if (Double.isNaN(t.getMzz()) || Double.isInfinite(t.getMzz())) {
            return false;
        }
        if (Double.isNaN(t.getTx()) || Double.isInfinite(t.getTx())) {
            return false;
        }
        if (Double.isNaN(t.getTy()) || Double.isInfinite(t.getTy())) {
            return false;
        }
        return !Double.isNaN(t.getTz()) && !Double.isInfinite(t.getTz());
    }

    protected abstract void localToParentTransformChanged(Node var1, Transform var2, Transform var3);

    protected void onBoundsChanged() {
    }

    public void register(Node observed, Node observer) {
        if (this.isRegistered()) {
            this.unregister();
        }
        if (observed == null) {
            throw new IllegalArgumentException("Observed may not be null.");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Observer not be null.");
        }
        Node commonAncestor = this.getNearestCommonAncestor(observed, observer);
        if (commonAncestor == null) {
            throw new IllegalArgumentException("Source and target do not share a common ancestor.");
        }
        this.observed = observed;
        observed.boundsInLocalProperty().addListener(this.boundsInLocalListener);
        this.registerTransformChangeListeners(observed, commonAncestor);
        this.registerTransformChangeListeners(observer, commonAncestor);
    }

    private void registerTransformChangeListeners(Node startingPoint, Node root) {
        Node tmp = startingPoint;
        while (tmp != null && tmp != root) {
            final Node current = tmp;
            ChangeListener<Transform> transformChangeListener = new ChangeListener<Transform>(){

                public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
                    if (VisualChangeListener.this.isValidTransform(newValue)) {
                        VisualChangeListener.this.localToParentTransformChanged(current, oldValue, newValue);
                        VisualChangeListener.this.onBoundsChanged();
                    }
                }
            };
            tmp.localToParentTransformProperty().addListener((ChangeListener)transformChangeListener);
            this.localToParentTransformListeners.put(transformChangeListener, tmp);
            tmp = tmp.getParent();
        }
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.observed.boundsInLocalProperty().removeListener(this.boundsInLocalListener);
        for (ChangeListener<Transform> l : this.localToParentTransformListeners.keySet()) {
            this.localToParentTransformListeners.get(l).localToParentTransformProperty().removeListener(l);
        }
        this.observed = null;
        this.localToParentTransformListeners.clear();
    }
}

