/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class CollaboratorService
extends GitHubService {
    public CollaboratorService() {
    }

    public CollaboratorService(GitHubClient client) {
        super(client);
    }

    public List<User> getCollaborators(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/collaborators");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request);
    }

    protected String createUpdateUri(IRepositoryIdProvider repository, String user) {
        String id = this.getId(repository);
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/collaborators");
        uri.append('/').append(user);
        return uri.toString();
    }

    public boolean isCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        return this.check(this.createUpdateUri(repository, user));
    }

    public void addCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        this.client.put(this.createUpdateUri(repository, user));
    }

    public void removeCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        this.client.delete(this.createUpdateUri(repository, user));
    }
}

