/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOLobEditorInput;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CDOLobStorage
extends AbstractDocumentProvider {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static CDOLobStorage instance;

    public CDOLobStorage() {
        instance = this;
    }

    private CDOLobStorage(boolean dummy) {
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof CDOLobEditorInput) {
            CDOResourceLeaf resource = ((CDOLobEditorInput)((Object)element)).getResource();
            String contents = this.getContents(resource);
            Document document = new Document();
            document.set(contents);
            return document;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        CDOResourceLeaf resource;
        CDOView view;
        if (element instanceof CDOLobEditorInput && (view = (resource = ((CDOLobEditorInput)((Object)element)).getResource()).cdoView()) != null && view.isReadOnly()) {
            return new CDOElementInfo(this.createDocument(element), this.createAnnotationModel(element), view);
        }
        return new AbstractDocumentProvider.ElementInfo((AbstractDocumentProvider)this, this.createDocument(element), this.createAnnotationModel(element));
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (element instanceof CDOElementInfo) {
            ((CDOElementInfo)((Object)element)).dispose();
        }
        super.disposeElementInfo(element, info);
    }

    public boolean isReadOnly(Object element) {
        if (element instanceof CDOLobEditorInput) {
            CDOResourceLeaf resource = ((CDOLobEditorInput)((Object)element)).getResource();
            return resource.cdoView().isReadOnly();
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        return !this.isReadOnly(element);
    }

    public boolean canSaveDocument(Object element) {
        return super.canSaveDocument(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof CDOLobEditorInput) {
            CDOLobEditorInput editorInput = (CDOLobEditorInput)((Object)element);
            CDOResourceLeaf resource = editorInput.getResource();
            String contents = document.get();
            try {
                CDOView view;
                if (resource instanceof CDOTextResource) {
                    CDOTextResource textResource = (CDOTextResource)resource;
                    CDOClob clob = new CDOClob((Reader)new CharArrayReader(contents.toCharArray()));
                    textResource.setContents(clob);
                } else if (resource instanceof CDOBinaryResource) {
                    byte[] bytes = contents.getBytes(this.getDefaultEncoding());
                    CDOBlob blob = new CDOBlob((InputStream)new ByteArrayInputStream(bytes));
                    ((CDOBinaryResource)resource).setContents(blob);
                }
                if (editorInput.isCommitOnSave() && (view = resource.cdoView()) instanceof CDOTransaction) {
                    CDOTransaction transaction = (CDOTransaction)view;
                    transaction.commit();
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContents(CDOResourceLeaf resource) {
        if (resource == null) {
            return "";
        }
        if (FSMUtil.isInvalid((CDOObject)resource)) {
            try {
                CDOResourceLeaf resource2 = (CDOResourceLeaf)resource.cdoView().getObject(resource.cdoID());
                if (resource2 == resource) {
                    return "";
                }
                return this.getContents(resource2);
            }
            catch (Exception ex) {
                return "";
            }
        }
        try {
            if (resource instanceof CDOTextResource) {
                CDOTextResource textResource = (CDOTextResource)resource;
                CDOClob clob = textResource.getContents();
                if (clob == null) {
                    return "";
                }
                return clob.getString();
            }
            if (!(resource instanceof CDOBinaryResource)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ((CDOResource)resource).save((OutputStream)outputStream, null);
                return new String(outputStream.toByteArray(), this.getDefaultEncoding());
            }
            CDOBlob blob = ((CDOBinaryResource)resource).getContents();
            if (blob == null) {
                return "";
            }
            return new String(blob.getBytes(), this.getDefaultEncoding());
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private String getDefaultEncoding() {
        String encoding = CHARSET_UTF_8;
        try {
            encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return encoding;
    }

    public static IDocumentProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        return new CDOLobStorage(true);
    }

    private final class CDOElementInfo
    extends AbstractDocumentProvider.ElementInfo
    implements IListener {
        private final CDOView view;

        public CDOElementInfo(IDocument document, IAnnotationModel model, CDOView view) {
            super((AbstractDocumentProvider)CDOLobStorage.this, document, model);
            this.view = view;
            EventUtil.addListener((Object)view, (IListener)this);
        }

        public void dispose() {
            EventUtil.removeListener((Object)this.view, (IListener)this);
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewInvalidationEvent) {
                UIUtil.asyncExec(() -> {
                    try {
                        CDOLobStorage.this.doResetDocument(this.fElement, null);
                    }
                    catch (CoreException ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                });
            }
        }
    }
}

