/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.ecore.dependencies.DependenciesPackage;
import org.eclipse.emf.cdo.ecore.dependencies.Link;
import org.eclipse.emf.cdo.ecore.dependencies.bundle.DependenciesPlugin;
import org.eclipse.emf.cdo.ecore.dependencies.provider.ModelItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.util.om.pref.OMPreference;

public final class ModelItemProviderForLinkViewer
extends ModelItemProvider {
    private static final Set<EStructuralFeature> GENERIC_FEATURES = ModelItemProviderForLinkViewer.createGenerics();

    public ModelItemProviderForLinkViewer(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void preferenceChanged(OMPreference<?> preference) {
        super.preferenceChanged(preference);
        if (preference == DependenciesPlugin.PREF_SHOW_BROKEN_LINKS || preference == DependenciesPlugin.PREF_SHOW_GENERICS) {
            this.resetChildren();
        }
    }

    @Override
    protected EReference getChildrenFeature() {
        if (((Boolean)DependenciesPlugin.PREF_SHOW_BROKEN_LINKS.getValue()).booleanValue()) {
            return DependenciesPackage.Literals.MODEL__BROKEN_LINKS;
        }
        return DependenciesPackage.Literals.MODEL__OUTGOING_LINKS;
    }

    @Override
    protected Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        Object value = super.getValue(eObject, eStructuralFeature);
        if (eStructuralFeature == this.getChildrenFeature()) {
            ArrayList links = new ArrayList((List)value);
            if (!((Boolean)DependenciesPlugin.PREF_SHOW_GENERICS.getValue()).booleanValue()) {
                Iterator it = links.iterator();
                while (it.hasNext()) {
                    Link link = (Link)it.next();
                    if (link.isBroken()) continue;
                    String uri = link.getSource().getUri().toString();
                    if (uri.indexOf("@eGeneric") != -1) {
                        it.remove();
                        continue;
                    }
                    EReference reference = link.getReference();
                    if (!GENERIC_FEATURES.contains(reference)) continue;
                    it.remove();
                }
            }
            links.sort(Link.ALPHABETICAL_COMPARATOR);
            return links;
        }
        return value;
    }

    private static Set<EStructuralFeature> createGenerics() {
        HashSet<EStructuralFeature> generics = new HashSet<EStructuralFeature>();
        generics.add((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__ETYPE_PARAMETERS);
        generics.add((EStructuralFeature)EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES);
        generics.add((EStructuralFeature)EcorePackage.Literals.EOPERATION__ETYPE_PARAMETERS);
        generics.add((EStructuralFeature)EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS);
        generics.add((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE);
        return generics;
    }
}

