/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWSDOMRuntimeManager;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.IWsDOMRuntimeInfo;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.WsDOMRuntimeRegistry;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

public class WsDOMRuntimeManager
implements IWSDOMRuntimeManager {
    private static WsDOMRuntimeManager instance = new WsDOMRuntimeManager();
    private Map<String, IWsDOMRuntimeExtension> domRuntimes = new HashMap<String, IWsDOMRuntimeExtension>();

    protected WsDOMRuntimeManager() {
    }

    public static IWSDOMRuntimeManager instance() {
        return instance;
    }

    @Override
    public synchronized void createDOMRuntimes(IProgressMonitor monitor) {
        for (IWsDOMRuntimeInfo runtimeInfo : WsDOMRuntimeRegistry.getRegisteredRuntimesInfo()) {
            this.createDOMRuntime(runtimeInfo, monitor);
        }
    }

    protected IWsDOMRuntimeExtension createDOMRuntime(IWsDOMRuntimeInfo runtimeInfo, IProgressMonitor monitor) {
        IWsDOMRuntimeExtension domRuntime = this.getDOMRuntime(runtimeInfo);
        if (domRuntime == null) {
            return null;
        }
        try {
            domRuntime.createDOM(monitor);
        }
        catch (Exception unexpected) {
            this.logger().logError("Unexpected Exception! Dom from runtime " + runtimeInfo.getName() + " will not be processed!", (Throwable)unexpected);
        }
        return domRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWsDOMRuntimeExtension getDOMRuntime(IWsDOMRuntimeInfo runtimeInfo) {
        if (runtimeInfo == null) {
            return null;
        }
        IWsDOMRuntimeExtension domRuntime = this.domRuntimes.get(runtimeInfo.getId());
        if (domRuntime == null && (domRuntime = WsDOMRuntimeRegistry.instantiateRuntime(runtimeInfo)) != null) {
            Map<String, IWsDOMRuntimeExtension> map = this.domRuntimes;
            synchronized (map) {
                this.domRuntimes.put(runtimeInfo.getId(), domRuntime);
            }
        }
        return domRuntime;
    }

    @Override
    public IWsDOMRuntimeExtension getDOMRuntime(String runtimeId) {
        return this.getDOMRuntime(WsDOMRuntimeRegistry.getRuntimeInfo(runtimeId));
    }

    @Override
    public Collection<IWsDOMRuntimeExtension> getDOMRuntimes() {
        if (this.domRuntimes.size() == 0) {
            Collection<IWsDOMRuntimeInfo> rtInfos = WsDOMRuntimeRegistry.getRegisteredRuntimesInfo();
            for (IWsDOMRuntimeInfo runtimeInfo : rtInfos) {
                this.getDOMRuntime(runtimeInfo);
            }
        }
        return this.domRuntimes.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reloadDOMRuntimes(IProgressMonitor monitor) {
        Map<String, IWsDOMRuntimeExtension> map = this.domRuntimes;
        synchronized (map) {
            this.domRuntimes = new HashMap<String, IWsDOMRuntimeExtension>();
        }
        this.createDOMRuntimes(monitor);
    }

    private ILogger logger() {
        return new Logger();
    }
}

