/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.util.function.Supplier;
import org.eclipse.egit.core.CachingRepository;
import org.eclipse.egit.core.RepositoryHandle;
import org.eclipse.jgit.lib.Repository;

public final class UnitOfWork {
    private UnitOfWork() {
    }

    public static void run(Repository repository, Work work) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ConfigScope scope = new ConfigScope(repository);){
            work.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void execute(Repository repository, Runnable work) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ConfigScope scope = new ConfigScope(repository);){
            work.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T run(Repository repository, WorkWithResult<? extends T> work) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ConfigScope scope = new ConfigScope(repository);){
            return work.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T get(Repository repository, Supplier<? extends T> work) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ConfigScope scope = new ConfigScope(repository);){
            return work.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class ConfigScope
    implements AutoCloseable {
        private CachingRepository repo;

        public ConfigScope(Repository repository) {
            Repository toCache = repository;
            if (repository instanceof RepositoryHandle) {
                toCache = ((RepositoryHandle)repository).getDelegate();
            }
            if (toCache instanceof CachingRepository) {
                this.repo = (CachingRepository)toCache;
                this.repo.cacheConfig(true);
            }
        }

        @Override
        public void close() {
            if (this.repo != null) {
                this.repo.cacheConfig(false);
                this.repo = null;
            }
        }
    }

    @FunctionalInterface
    public static interface Work {
        public void run() throws IOException;
    }

    @FunctionalInterface
    public static interface WorkWithResult<T> {
        public T get() throws IOException;
    }
}

