/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.annotate.mapping.JoinTableAttributes;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JoinColumnsAnnotationEditor;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JoinPropertiesPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectPropertyDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OneToManyJoinPropsPage
extends JoinPropertiesPage {
    private Button mappedByRadio;
    private Text mappedByText;
    private Button mappedByBrowseBtn;
    private Button joinColumnRadio;
    private Button joinTableRadio;
    private Composite joinColumnGroup;
    private Composite joinTableGroup;
    private Text joinTableText;
    private Button joinTableBtn;
    private Control joinColumnsCtl;
    private Control joinColumnsCtl2;
    private Control inverseJoinColumnsCtl;
    private JoinColumnsAnnotationEditor joinColEditor;

    public OneToManyJoinPropsPage(PersistenceUnit persistenceUnit, ResourceManager resourceManager, IProject project, String javaClass, Schema schema, Table table, Table inverseTable, EntityRefPropertyElem refElem) {
        super(persistenceUnit, resourceManager, project, javaClass, schema, table, inverseTable, refElem);
        this.joinColEditor = new JoinColumnsAnnotationEditor(resourceManager, refElem, false, table, inverseTable, this);
    }

    @Override
    public Composite createJoinProps(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        group.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.mappedByRadio = AssociationAnnotationWizard.createButton(group, 1, JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_MAPPEDBY, -1, 16);
        this.mappedByText = AssociationAnnotationWizard.createText(group, true, 1, 2048);
        this.mappedByBrowseBtn = AssociationAnnotationWizard.createImageButton(group, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        if (!this.isJpa1_0Project()) {
            this.joinColumnRadio = AssociationAnnotationWizard.createButton(group, 3, JptJpaUiMakePersistentMessages.JOIN_COLUMNS_LABEL, -1, 16);
            this.joinColumnGroup = new Composite(group, 0);
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 3;
            this.joinColumnGroup.setLayoutData((Object)gd2);
            GridLayout gl2 = new GridLayout(1, false);
            gl2.marginHeight = 0;
            gl2.marginWidth = 0;
            this.joinColumnGroup.setLayout((Layout)gl2);
        }
        this.joinTableRadio = AssociationAnnotationWizard.createButton(group, 1, JptJpaUiMakePersistentMessages.PROPS_MAPPING_PAGE_JOIN_TABLE, -1, 16);
        this.joinTableText = AssociationAnnotationWizard.createText(group, true, 1, 2048);
        Image listImage = this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES);
        this.joinTableBtn = AssociationAnnotationWizard.createImageButton(group, listImage, 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        this.joinTableGroup = new Composite(group, 0);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 3;
        gd3.widthHint = 400;
        gd3.heightHint = 280;
        this.joinTableGroup.setLayoutData((Object)gd3);
        GridLayout gl3 = new GridLayout(1, false);
        gl3.marginHeight = 0;
        gl3.marginWidth = 0;
        this.joinTableGroup.setLayout((Layout)gl3);
        return group;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.mappedByRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OneToManyJoinPropsPage.this.handleJoinPropsChange();
            }
        });
        if (!this.isJpa1_0Project()) {
            this.joinColumnRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OneToManyJoinPropsPage.this.handleJoinPropsChange();
                }
            });
        }
        this.joinTableRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OneToManyJoinPropsPage.this.handleJoinPropsChange();
            }
        });
        this.mappedByText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OneToManyJoinPropsPage.this.handleMappedByChange(OneToManyJoinPropsPage.this.mappedByText);
            }
        });
        this.mappedByBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OneToManyJoinPropsPage.this.chooseMappedBy();
            }
        });
        this.joinTableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OneToManyJoinPropsPage.this.handleJoinTableChange(OneToManyJoinPropsPage.this.joinTableText);
            }
        });
        this.joinTableBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OneToManyJoinPropsPage.this.chooseJoinTable(OneToManyJoinPropsPage.this.joinTableText);
            }
        });
    }

    @Override
    protected void initFields() {
        String mappedBy = this.refElem.getMappedBy();
        if (mappedBy != null || this.refElem.getJoinTable() == null && this.refElem.getJoinColumns().isEmpty()) {
            this.mappedByRadio.setSelection(true);
            this.mappedByText.setEnabled(true);
            this.mappedByBrowseBtn.setEnabled(true);
            if (mappedBy != null) {
                this.mappedByText.setText(mappedBy);
            }
            this.joinTableRadio.setSelection(false);
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
            if (!this.isJpa1_0Project()) {
                this.joinColumnRadio.setSelection(false);
            }
        } else if (this.refElem.getJoinTable() != null) {
            this.mappedByRadio.setSelection(false);
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
            this.joinTableRadio.setSelection(true);
            this.joinTableText.setEnabled(true);
            this.joinTableBtn.setEnabled(true);
            if (this.refElem.getJoinTable() != null) {
                this.joinTableText.setText(this.refElem.getJoinTable().getTableName());
            }
            if (!this.isJpa1_0Project()) {
                this.joinColumnRadio.setSelection(false);
            }
        } else if (!this.isJpa1_0Project() && !this.refElem.getJoinColumns().isEmpty()) {
            this.mappedByRadio.setSelection(false);
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
            this.joinTableRadio.setSelection(false);
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
            this.joinColumnRadio.setSelection(true);
        }
    }

    @Override
    protected void refreshJoinProperties() {
        if (this.joinColumnsCtl != null) {
            this.joinColumnsCtl.dispose();
            this.joinColumnsCtl = null;
        }
        Composite joinProps = this.getJoinPropsComposite();
        if (!this.isJpa1_0Project() && this.refElem.getJoinStrategy() == JoinStrategy.JOIN_COLUMNS) {
            Composite parent = this.joinColumnGroup != null ? this.joinColumnGroup : joinProps;
            this.joinColumnsCtl = this.joinColEditor.createJoinColumnsControl(parent);
            if (this.joinColumnsCtl != null) {
                GridData gd2 = new GridData(768);
                gd2.grabExcessHorizontalSpace = true;
                this.joinColumnsCtl.setLayoutData((Object)gd2);
                parent.pack();
                parent.layout();
            }
        }
        this.refreshJoinTableGroup();
        joinProps.pack();
        joinProps.layout();
    }

    private void refreshJoinTableGroup() {
        if (this.joinColumnsCtl2 != null) {
            this.joinColumnsCtl2.dispose();
            this.joinColumnsCtl2 = null;
        }
        if (this.inverseJoinColumnsCtl != null) {
            this.inverseJoinColumnsCtl.dispose();
            this.inverseJoinColumnsCtl = null;
        }
        if (this.refElem.getJoinStrategy() != JoinStrategy.JOIN_TABLE) {
            return;
        }
        String joinTableName = this.getJoinTableName();
        Table joinTable = null;
        if (joinTableName != null) {
            joinTable = this.schema.getTableNamed(joinTableName);
        }
        JoinColumnsAnnotationEditor joinColEditor = new JoinColumnsAnnotationEditor(this.resourceManager, this.refElem, false, joinTable, this.table, this);
        this.joinColumnsCtl2 = joinColEditor.createJoinColumnsControl(this.joinTableGroup);
        if (this.joinColumnsCtl2 != null) {
            GridData gd2 = new GridData(768);
            gd2.grabExcessHorizontalSpace = true;
            this.joinColumnsCtl2.setLayoutData((Object)gd2);
            this.joinTableGroup.pack();
            this.joinTableGroup.layout();
        }
        JoinColumnsAnnotationEditor inverseJoinColEditor = new JoinColumnsAnnotationEditor(this.resourceManager, this.refElem, true, joinTable, this.inverseTable, this);
        this.inverseJoinColumnsCtl = inverseJoinColEditor.createJoinColumnsControl(this.joinTableGroup);
        if (this.inverseJoinColumnsCtl != null) {
            GridData gd2 = new GridData(768);
            gd2.grabExcessHorizontalSpace = true;
            this.inverseJoinColumnsCtl.setLayoutData((Object)gd2);
            this.joinTableGroup.pack();
            this.joinTableGroup.layout();
        }
    }

    private void chooseMappedBy() {
        if (this.refElem.getRefEntityClassName() == null) {
            AssociationAnnotationWizard.displayNoTargetEntityError(this.refElem.getPropertyName());
            return;
        }
        SelectPropertyDialog dlg = new SelectPropertyDialog(Display.getDefault().getActiveShell(), this.project, this.javaClass, this.refElem, false);
        if (dlg.open() == 0) {
            this.mappedByText.setText(dlg.getSelectedProp());
        }
    }

    private void handleJoinPropsChange() {
        if (this.mappedByRadio.getSelection()) {
            this.refElem.setJoinStrategy(JoinStrategy.MAPPED_BY);
            this.refElem.removeAllJoinColumns();
            this.refElem.removeJoinTable();
            this.refreshJoinProperties();
            this.mappedByText.setEnabled(true);
            this.mappedByBrowseBtn.setEnabled(true);
            this.joinTableRadio.setSelection(false);
            this.joinTableText.setText("");
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
            if (!this.isJpa1_0Project()) {
                this.joinColumnRadio.setSelection(false);
            }
        } else if (this.joinTableRadio.getSelection()) {
            this.refElem.setJoinStrategy(JoinStrategy.JOIN_TABLE);
            this.refElem.removeAllJoinColumns();
            this.refElem.removeMappedBy();
            JoinTableAttributes joinTblAttr = this.refElem.getJoinTable();
            if (joinTblAttr == null) {
                joinTblAttr = new JoinTableAttributes();
                this.refElem.setJoinTable(joinTblAttr);
            }
            this.refreshJoinProperties();
            this.mappedByRadio.setSelection(false);
            this.mappedByText.setText("");
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
            this.joinTableText.setEnabled(true);
            this.joinTableBtn.setEnabled(true);
            if (!this.isJpa1_0Project()) {
                this.joinColumnRadio.setSelection(false);
            }
        } else {
            this.refElem.setJoinStrategy(JoinStrategy.JOIN_COLUMNS);
            this.refElem.removeJoinTable();
            this.refElem.removeMappedBy();
            this.refreshJoinProperties();
            this.mappedByRadio.setSelection(false);
            this.mappedByText.setText("");
            this.mappedByText.setEnabled(false);
            this.mappedByBrowseBtn.setEnabled(false);
            this.joinTableText.setText("");
            this.joinTableText.setEnabled(false);
            this.joinTableBtn.setEnabled(false);
            this.joinTableRadio.setSelection(false);
        }
    }
}

