/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.NamedConverterAnnotation;

abstract class EclipseLinkSourceNamedConverterAnnotation
extends SourceAnnotation
implements NamedConverterAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    final AnnotationElementAdapter<String> nameAdapter;
    String name;
    TextRange nameTextRange;

    EclipseLinkSourceNamedConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, element, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.nameDeclarationAdapter = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)this.getNameElementName());
        this.nameAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.nameDeclarationAdapter);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    abstract String getNameElementName();
}

